/* water.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "effects.h"
/*---------------------------------------------------------------------------*/
/* #define */
#define WATER_DELAY_MIN 0
#define WATER_DELAY_MAX 32768
#define WATER_DELAY_STEP 1

#define WATER_DENSITY_MIN 0
#define WATER_DENSITY_MAX 32768
#define WATER_DENSITY_STEP 1

#define WATER_HEIGHT_MIN 0
#define WATER_HEIGHT_MAX 32768
#define WATER_HEIGHT_STEP 100

#define WATER_LIGHT_MIN 0
#define WATER_LIGHT_MAX 1
#define WATER_LIGHT_STEP 1

#define WATER_MATERIAL_MIN 0
#define WATER_MATERIAL_MAX 1
#define WATER_MATERIAL_STEP 1

#define WATER_MOVEMENT_MIN 0
#define WATER_MOVEMENT_MAX 1
#define WATER_MOVEMENT_STEP 1

#define WATER_RADIUS_MIN 0
#define WATER_RADIUS_MAX 32768
#define WATER_RADIUS_STEP 1

#define WATER_SORT_MIN 0
#define WATER_SORT_MAX 6
#define WATER_SORT_STEP 1

#define WATER_X_MIN 0
#define WATER_X_MAX SCREEN_W
#define WATER_X_STEP 10

#define WATER_Y_MIN 0
#define WATER_Y_MAX SCREEN_H
#define WATER_Y_STEP 10
/*---------------------------------------------------------------------------*/
/* variables */
uchr *bufptr;
int height[2][WATERWID * WATERHGT];
int fsintab[2048];
int fcostab[2048];
int hpage, offset, ox, oy, swirlangle, x, xang, y, yang;

uchr bkgdimagepre[WATERWID * WATERHGT];
uchr bkgdimage[WATERWID * WATERHGT];
uchr bkgdimagepost[WATERWID * WATERHGT];

long water_delay;
int water_density;
int water_height;
int water_light;
int water_material;
int water_movement;
int water_radius;
int water_sort;
int water_x;
int water_y;

static tkeyparse
  see_f9_0 = {K_0, keysee_f9_0}, /* water.c specific */
  see_f9_1 = {K_1, keysee_f9_1},
  see_f9_2 = {K_2, keysee_f9_2},
  see_f9_3 = {K_3, keysee_f9_3},
  see_f9_4 = {K_4, keysee_f9_4},
  see_f9_5 = {K_5, keysee_f9_5},
  see_f9_6 = {K_6, keysee_f9_6},
  see_f9_7 = {K_7, keysee_f9_7},
  see_f9_8 = {K_8, keysee_f9_8},
  see_f9_9 = {K_9, keysee_f9_9},
  see_f9_d = {K_d, keysee_f9_d},
  see_f9_D = {K_D, keysee_f9_D},
  see_f9_e = {K_e, keysee_f9_e},
  see_f9_E = {K_E, keysee_f9_E},
  see_f9_h = {K_h, keysee_f9_h},
  see_f9_H = {K_H, keysee_f9_H},
  see_f9_l = {K_l, keysee_f9_l},
  see_f9_L = {K_L, keysee_f9_L},
  see_f9_m = {K_m, keysee_f9_m},
  see_f9_M = {K_M, keysee_f9_M},
  see_f9_o = {K_o, keysee_f9_o},
  see_f9_O = {K_O, keysee_f9_O},
  see_f9_r = {K_r, keysee_f9_r},
  see_f9_R = {K_R, keysee_f9_R},
  see_f9_s = {K_s, keysee_f9_s},
  see_f9_S = {K_S, keysee_f9_S},
  see_f9_x = {K_x, keysee_f9_x},
  see_f9_X = {K_X, keysee_f9_X},
  see_f9_y = {K_y, keysee_f9_y},
  see_f9_Y = {K_Y, keysee_f9_Y}
;

tkeyparse* tkeyparsetbl_water[] =
{
  TKEYPARSETBL_SEE, /* see.c specific */
  &see_f9_0, /* water.c specific */
  &see_f9_1,
  &see_f9_2,
  &see_f9_3,
  &see_f9_4,
  &see_f9_5,
  &see_f9_6,
  &see_f9_7,
  &see_f9_8,
  &see_f9_9,
  &see_f9_d,
  &see_f9_D,
  &see_f9_e,
  &see_f9_E,
  &see_f9_h,
  &see_f9_H,
  &see_f9_l,
  &see_f9_L,
  &see_f9_m,
  &see_f9_M,
  &see_f9_o,
  &see_f9_O,
  &see_f9_r,
  &see_f9_R,
  &see_f9_s,
  &see_f9_S,
  &see_f9_x,
  &see_f9_X,
  &see_f9_y,
  &see_f9_Y,
  NULL
};
/*---------------------------------------------------------------------------*/
void calcwater(int npage, int adensity)
{
  int count = WATERWID + 1, newh;
  int *newptr = &height[npage][0];
  int *oldptr = &height[npage^1][0];
  int x, y;

  for (y = (WATERHGT - 1) * WATERWID; count < y; count += 2)
    {
      for (x = count + WATERWID - 2; count < x; count++)
	{
	  newh =((oldptr[count + WATERWID]
		  + oldptr[count - WATERWID]
		  + oldptr[count + 1]
		  + oldptr[count - 1]
		  + oldptr[count - WATERWID - 1]
		  + oldptr[count - WATERWID + 1]
		  + oldptr[count + WATERWID - 1]
		  + oldptr[count + WATERWID + 1]) >> 2) - newptr[count];
	  newptr[count] = newh - (newh >> adensity);
	}
    }
}
/*---------------------------------------------------------------------------*/
void calcwaterbigfilter(int npage, int adensity)
{
  int newh, x, y;
  int count = (2 * WATERWID) + 2;
  int *newptr = &height[npage][0];
  int *oldptr = &height[npage^1][0];

  for (y = 2; y < WATERHGT - 2; y++)
    {
      for (x = 2; x < WATERWID - 2; x++)
 	{
	  newh = (((
		    (oldptr[count + WATERWID]
		     + oldptr[count - WATERWID]
		     + oldptr[count + 1]
		     + oldptr[count - 1]) << 1) +
		   ((oldptr[count - WATERWID - 1]
		     + oldptr[count - WATERWID + 1]
		     + oldptr[count + WATERWID - 1]
		     + oldptr[count + WATERWID + 1])) +
		   ((oldptr[count - (WATERWID * 2)]
		     + oldptr[count + (WATERWID * 2)]
		     + oldptr[count - 2]
		     + oldptr[count + 2]) >> 1 ) +
		   ((oldptr[count - (WATERWID * 2) - 1]
		     + oldptr[count - (WATERWID * 2) + 1]
		     + oldptr[count + (WATERWID * 2) - 1]
		     + oldptr[count + (WATERWID * 2) + 1]
		     + oldptr[count - 2 - WATERWID]
		     + oldptr[count - 2 + WATERWID]
		     + oldptr[count + 2 - WATERWID]
		     + oldptr[count + 2 + WATERWID]) >> 2)) >> 3) - (newptr[count]);
	  newptr[count] = newh - (newh >> adensity);
	  count++;
	}
      count += 4;
    }
}
/*---------------------------------------------------------------------------*/
void drawwaternolight(int page)
{
  int c, dx, dy, x, y;
  int offset = WATERWID + 1;
  int *ptr = &height[page][0];

  for (y = (WATERHGT - 1) * WATERWID; offset < y; offset += 2)
    {
      for(x = offset + WATERWID - 2; offset < x; offset++)
	{
	  dx = ptr[offset] - ptr[offset + 1];
	  dy = ptr[offset] - ptr[offset + WATERWID];
	  c = bkgdimage[offset + WATERWID * (dy >> 3) + (dx >> 3)];
	  bufptr[offset] = (c < 0) ? 0 : (c > 255) ? 255 : c;
	  offset++;
	  dx = ptr[offset] - ptr[offset + 1];
	  dy = ptr[offset] - ptr[offset + WATERWID];
	  c = bkgdimage[offset + WATERWID * (dy >> 3) + (dx >> 3)];
	  bufptr[offset] = (c < 0) ? 0 : (c > 255) ? 255 : c;
 	}
    }
  blit(pbmp, screen, 0, 0, (320 - WATERWID) / 2, (200 - WATERHGT) / 2, WATERWID, WATERHGT);
}
/*---------------------------------------------------------------------------*/
void drawwaterwithlight(int page, int lightmodifier)
{
  int c, dx, dy, x, y;
  int offset = WATERWID + 1;
  int *ptr = &height[page][0];

  for (y = (WATERHGT - 1) * WATERWID; offset < y; offset += 2)
    {
      for (x = offset + WATERWID - 2; offset < x; offset++)
 	{
	  dx = ptr[offset] - ptr[offset + 1];
	  dy = ptr[offset] - ptr[offset + WATERWID];
	  c = bkgdimage[offset + WATERWID * (dy >> 3) + (dx >> 3)] - (dx >> lightmodifier);
	  bufptr[offset] = (c < 0) ? 0 : (c > 255) ? 255 : c;
	  offset++;
	  dx = ptr[offset] - ptr[offset + 1];
	  dy = ptr[offset] - ptr[offset + WATERWID];
	  c = bkgdimage[offset + WATERWID * (dy >> 3) + (dx >> 3)] - (dx >> lightmodifier);
	  bufptr[offset] = (c < 0) ? 0 : (c > 255) ? 255 : c;
	}
    }
  blit(pbmp, screen, 0, 0, (320 - WATERWID) / 2, (200 - WATERHGT) / 2, WATERWID, WATERHGT);
}
/*---------------------------------------------------------------------------*/
int fcosa(int angle)
{
  return fcostab[angle & FSINMAX];
}
/*---------------------------------------------------------------------------*/
void fcreatesines()
{
  int i;
  double angle;

  for (i = 0; i < 2048; i++)
  {
    angle = (float) i * (PI / 1024.0);
    fsintab[i] = (int) (sin(angle) * (float) 0x10000);
    fcostab[i] = (int) (cos(angle) * (float) 0x10000);
  }
}
/*---------------------------------------------------------------------------*/
int fsina(int angle)
{
  return fsintab[angle & FSINMAX];
}
/*---------------------------------------------------------------------------*/
void heightblob(int x, int y, int aradius, int aheight, int page)
{
  int bottom, cx, cy, cyq, left, right, rquad, top;

  rquad = aradius * aradius;
  if (x < 0)
    {
      x = 1 + aradius + rand() % (WATERWID - 2 * aradius - 1);
    }
  if (y < 0)
    {
      y = 1 + aradius + rand() % (WATERHGT - 2 * aradius - 1);
    }
  left = -aradius;
  right = aradius;
  top = -aradius;
  bottom = aradius;
  if (x - aradius < 1)
    {
      left -= (x - aradius - 1);
    }
  if (y - aradius < 1)
    {
      top -= (y - aradius - 1);
    }
  if (x + aradius > WATERWID - 1)
    {
      right -= (x + aradius - WATERWID + 1);
    }
  if (y + aradius > WATERHGT - 1)
    {
      bottom -= (y + aradius - WATERHGT + 1);
    }
  for (cy = top; cy < bottom; cy++)
    {
      cyq = cy * cy;
      for (cx = left; cx < right; cx++)
 	{
	  if (cx * cx + cyq < rquad)
	    height[page][WATERWID * (cy + y) + (cx + x)] += aheight;
 	}
    }
}
/*---------------------------------------------------------------------------*/
void heightbox(int x, int y, int aradius, int aheight, int page)
{
  int bottom, cx, cy, left, right, top;

  if (x < 0) x = 1 + aradius + rand() % (WATERWID - 2 * aradius - 1);
  if (y < 0) y = 1 + aradius + rand() % (WATERHGT - 2 * aradius - 1);
  left = -aradius;
  right = aradius;
  top = -aradius;
  bottom = aradius;
  if (x - aradius < 1)
    {
      left -= (x - aradius - 1);
    }
  if (y - aradius < 1)
    {
      top -= (y - aradius - 1);
    }
  if (x + aradius > WATERWID - 1)
    {
      right -= (x + aradius - WATERWID + 1);
    }
  if (y + aradius > WATERHGT - 1)
    {
      bottom -= (y + aradius - WATERHGT + 1);
    }
  for (cy = top; cy < bottom; cy++)
    {
      for (cx = left; cx < right; cx++)
 	{
	  height[page][WATERWID * (cy + y) + (cx + x)] = aheight;
 	}
    }
}
/*---------------------------------------------------------------------------*/
void keysee_f9_0()
{
  int pi;
  char **tps;

  water_restore();
  tps = get_config_argv("[See]", "f9_0", &pi);
  water_delay = atoi(tps[1]);
  water_density = atoi(tps[2]);
  water_height = atoi(tps[3]);
  water_light = atoi(tps[4]);
  water_material = atoi(tps[5]);
  water_movement = atoi(tps[6]);
  water_radius = atoi(tps[7]);
  water_sort = atoi(tps[8]);
  water_x = atoi(tps[9]);
  water_y = atoi(tps[10]);
  water();
}
/*---------------------------------------------------------------------------*/
void keysee_f9_1()
{
  int pi;
  char **tps;

  water_restore();
  tps = get_config_argv("[See]", "f9_1", &pi);
  water_delay = atoi(tps[1]);
  water_density = atoi(tps[2]);
  water_height = atoi(tps[3]);
  water_light = atoi(tps[4]);
  water_material = atoi(tps[5]);
  water_movement = atoi(tps[6]);
  water_radius = atoi(tps[7]);
  water_sort = atoi(tps[8]);
  water_x = atoi(tps[9]);
  water_y = atoi(tps[10]);
  water();
}
/*---------------------------------------------------------------------------*/
void keysee_f9_2()
{
  int pi;
  char **tps;

  water_restore();
  tps = get_config_argv("[See]", "f9_2", &pi);
  water_delay = atoi(tps[1]);
  water_density = atoi(tps[2]);
  water_height = atoi(tps[3]);
  water_light = atoi(tps[4]);
  water_material = atoi(tps[5]);
  water_movement = atoi(tps[6]);
  water_radius = atoi(tps[7]);
  water_sort = atoi(tps[8]);
  water_x = atoi(tps[9]);
  water_y = atoi(tps[10]);
  water();
}
/*---------------------------------------------------------------------------*/
void keysee_f9_3()
{
  int pi;
  char **tps;

  water_restore();
  tps = get_config_argv("[See]", "f9_3", &pi);
  water_delay = atoi(tps[1]);
  water_density = atoi(tps[2]);
  water_height = atoi(tps[3]);
  water_light = atoi(tps[4]);
  water_material = atoi(tps[5]);
  water_movement = atoi(tps[6]);
  water_radius = atoi(tps[7]);
  water_sort = atoi(tps[8]);
  water_x = atoi(tps[9]);
  water_y = atoi(tps[10]);
  water();
}
/*---------------------------------------------------------------------------*/
void keysee_f9_4()
{
  int pi;
  char **tps;

  water_restore();
  tps = get_config_argv("[See]", "f9_4", &pi);
  water_delay = atoi(tps[1]);
  water_density = atoi(tps[2]);
  water_height = atoi(tps[3]);
  water_light = atoi(tps[4]);
  water_material = atoi(tps[5]);
  water_movement = atoi(tps[6]);
  water_radius = atoi(tps[7]);
  water_sort = atoi(tps[8]);
  water_x = atoi(tps[9]);
  water_y = atoi(tps[10]);
  water();
}
/*---------------------------------------------------------------------------*/
void keysee_f9_5()
{
  int pi;
  char **tps;

  water_restore();
  tps = get_config_argv("[See]", "f9_5", &pi);
  water_delay = atoi(tps[1]);
  water_density = atoi(tps[2]);
  water_height = atoi(tps[3]);
  water_light = atoi(tps[4]);
  water_material = atoi(tps[5]);
  water_movement = atoi(tps[6]);
  water_radius = atoi(tps[7]);
  water_sort = atoi(tps[8]);
  water_x = atoi(tps[9]);
  water_y = atoi(tps[10]);
  water();
}
/*---------------------------------------------------------------------------*/
void keysee_f9_6()
{
  int pi;
  char **tps;

  water_restore();
  tps = get_config_argv("[See]", "f9_6", &pi);
  water_delay = atoi(tps[1]);
  water_density = atoi(tps[2]);
  water_height = atoi(tps[3]);
  water_light = atoi(tps[4]);
  water_material = atoi(tps[5]);
  water_movement = atoi(tps[6]);
  water_radius = atoi(tps[7]);
  water_sort = atoi(tps[8]);
  water_x = atoi(tps[9]);
  water_y = atoi(tps[10]);
  water();
}
/*---------------------------------------------------------------------------*/
void keysee_f9_7()
{
  int pi;
  char **tps;

  water_restore();
  tps = get_config_argv("[See]", "f9_7", &pi);
  water_delay = atoi(tps[1]);
  water_density = atoi(tps[2]);
  water_height = atoi(tps[3]);
  water_light = atoi(tps[4]);
  water_material = atoi(tps[5]);
  water_movement = atoi(tps[6]);
  water_radius = atoi(tps[7]);
  water_sort = atoi(tps[8]);
  water_x = atoi(tps[9]);
  water_y = atoi(tps[10]);
  water();
}
/*---------------------------------------------------------------------------*/
void keysee_f9_8()
{
  int pi;
  char **tps;

  water_restore();
  tps = get_config_argv("[See]", "f9_8", &pi);
  water_delay = atoi(tps[1]);
  water_density = atoi(tps[2]);
  water_height = atoi(tps[3]);
  water_light = atoi(tps[4]);
  water_material = atoi(tps[5]);
  water_movement = atoi(tps[6]);
  water_radius = atoi(tps[7]);
  water_sort = atoi(tps[8]);
  water_x = atoi(tps[9]);
  water_y = atoi(tps[10]);
  water();
}
/*---------------------------------------------------------------------------*/
void keysee_f9_9()
{
  int pi;
  char **tps;

  water_restore();
  tps = get_config_argv("[See]", "f9_9", &pi);
  water_delay = atoi(tps[1]);
  water_density = atoi(tps[2]);
  water_height = atoi(tps[3]);
  water_light = atoi(tps[4]);
  water_material = atoi(tps[5]);
  water_movement = atoi(tps[6]);
  water_radius = atoi(tps[7]);
  water_sort = atoi(tps[8]);
  water_x = atoi(tps[9]);
  water_y = atoi(tps[10]);
  water();
}
/*---------------------------------------------------------------------------*/
void keysee_f9_d()
{
  paralong(&water_delay, WATER_DELAY_MIN, WATER_DELAY_MAX, WATER_DELAY_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f9_D()
{
  paralong(&water_delay, WATER_DELAY_MIN, WATER_DELAY_MAX, WATER_DELAY_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f9_e()
{
  paraint(&water_density, WATER_DENSITY_MIN, WATER_DENSITY_MAX, WATER_DENSITY_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f9_E()
{
  paraint(&water_density, WATER_DENSITY_MIN, WATER_DENSITY_MAX, WATER_DENSITY_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f9_h()
{
  paraint(&water_height, WATER_HEIGHT_MIN, WATER_HEIGHT_MAX, WATER_HEIGHT_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f9_H()
{
  paraint(&water_height, WATER_HEIGHT_MIN, WATER_HEIGHT_MAX, WATER_HEIGHT_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f9_l()
{
  paraint(&water_light, WATER_LIGHT_MIN, WATER_LIGHT_MAX, WATER_LIGHT_STEP, 0, 1);
}
/*---------------------------------------------------------------------------*/
void keysee_f9_L()
{
  paraint(&water_light, WATER_LIGHT_MIN, WATER_LIGHT_MAX, WATER_LIGHT_STEP, 1, 1);
}
/*---------------------------------------------------------------------------*/
void keysee_f9_m()
{
  paraint(&water_material, WATER_MATERIAL_MIN, WATER_MATERIAL_MAX, WATER_MATERIAL_STEP, 0, 1);
}
/*---------------------------------------------------------------------------*/
void keysee_f9_M()
{
  paraint(&water_material, WATER_MATERIAL_MIN, WATER_MATERIAL_MAX, WATER_MATERIAL_STEP, 1, 1);
}
/*---------------------------------------------------------------------------*/
void keysee_f9_o()
{
  paraint(&water_movement, WATER_MOVEMENT_MIN, WATER_MOVEMENT_MAX, WATER_MOVEMENT_STEP, 0, 1);
}
/*---------------------------------------------------------------------------*/
void keysee_f9_O()
{
  paraint(&water_movement, WATER_MOVEMENT_MIN, WATER_MOVEMENT_MAX, WATER_MOVEMENT_STEP, 1, 1);
}
/*---------------------------------------------------------------------------*/
void keysee_f9_r()
{
  paraint(&water_radius, WATER_RADIUS_MIN, WATER_RADIUS_MAX, WATER_RADIUS_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f9_R()
{
  paraint(&water_radius, WATER_RADIUS_MIN, WATER_RADIUS_MAX, WATER_RADIUS_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f9_s()
{
  paraint(&water_sort, WATER_SORT_MIN, WATER_SORT_MAX, WATER_SORT_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f9_S()
{
  paraint(&water_sort, WATER_SORT_MIN, WATER_SORT_MAX, WATER_SORT_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f9_x()
{
  paraint(&water_x, WATER_X_MIN, WATER_X_MAX, WATER_X_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f9_X()
{
  paraint(&water_x, WATER_X_MIN, WATER_X_MAX, WATER_X_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f9_y()
{
  paraint(&water_y, WATER_Y_MIN, WATER_Y_MAX, WATER_Y_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f9_Y()
{
  paraint(&water_y, WATER_Y_MIN, WATER_Y_MAX, WATER_Y_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void sineblob(int x, int y, int aradius, int aheight, int page)
{
  int bottom, cx, cy, dist, left, right, square, top;
  int radsquare = aradius * aradius;
  float length = (1024.0 / (float) aradius) * (1024.0 / (float) aradius);

  if (x < 0)
    {
      x = 1 + aradius + rand() % (WATERWID - 2 * aradius - 1);
    }
  if (y < 0)
    {
      y = 1 + aradius + rand() % (WATERHGT - 2 * aradius - 1);
    }
  radsquare = (aradius * aradius);
  left = -aradius;
  right = aradius;
  top = -aradius;
  bottom = aradius;
  if (x - aradius < 1)
    {
      left -= (x - aradius - 1);
    }
  if (y - aradius < 1)
    {
      top -= (y - aradius - 1);
    }
  if (x + aradius > WATERWID-1)
    {
      right -= (x + aradius - WATERWID + 1);
    }
  if (y + aradius > WATERHGT - 1)
    {
      bottom -= (y + aradius - WATERHGT + 1);
    }
  for (cy = top; cy < bottom; cy++)
    {
      for (cx = left; cx < right; cx++)
 	{
	  square = cy * cy + cx * cx;
	  if (square < radsquare)
 	    {
	      dist = sqrt(square * length);
	      height[page][WATERWID * (cy + y) + cx + x] +=
		(int)((fcosa(dist) + 0xFFFF) * (aheight)) >> 19;
 	    }
	}
    }
}
/*---------------------------------------------------------------------------*/
void smoothwater(int npage)
{
  int newh, x, y;
  int count = WATERWID + 1;

  int *newptr = &height[npage][0];
  int *oldptr = &height[npage^1][0];

  for (y = 1; y < WATERHGT - 1; y++)
    {
      for (x = 1; x < WATERWID - 1; x++)
 	{
	  newh = ((oldptr[count + WATERWID]
		   + oldptr[count - WATERWID]
		   + oldptr[count + 1]
		   + oldptr[count - 1]
		   + oldptr[count - WATERWID - 1]
		   + oldptr[count - WATERWID + 1]
		   + oldptr[count + WATERWID - 1]
		   + oldptr[count + WATERWID + 1]) >> 3) + newptr[count];
	  newptr[count] = newh >> 1;
	  count++;
 	}
      count += 2;
    }
}
/*---------------------------------------------------------------------------*/
void warpblob(int x, int y, int aradius, int aheight, int page)
{
  int cx, cy;
  int left, top, right, bottom;
  int square;
  int radsquare = aradius * aradius;

  radsquare = (aradius * aradius);
  aheight /= 64;
  left = -aradius;
  right = aradius;
  top = -aradius;
  bottom = aradius;
  if (x - aradius < 1)
    {
      left -= (x - aradius - 1);
    }
  if (y - aradius < 1)
    {
      top -= (y - aradius - 1);
    }
  if (x + aradius > WATERWID - 1)
    {
      right -= (x + aradius - WATERWID + 1);
    }
  if (y + aradius > WATERHGT - 1)
    {
      bottom -= (y + aradius - WATERHGT + 1);
    }
  for (cy = top; cy < bottom; cy++)
    {
      for (cx = left; cx < right; cx++)
 	{
	  square = cy * cy + cx * cx;
	  if (square < radsquare)
 	    {
	      height[page][WATERWID * (cy + y) + cx + x] +=
		(aradius - sqrt(square)) * (float)(aheight);
 	    }
	}
    }
}
/*---------------------------------------------------------------------------*/
void water()
{
  hpage = 0;
  offset = 0;
  ox = 80;
  oy = 60;
  swirlangle = 0;
  x = 0;
  xang = 0;
  y = 0;
  yang = 0;
  srand(time(NULL));
  fcreatesines();
  xang = rand() % 2048;
  yang = rand() % 2048;
  swirlangle = rand() % 2048;
  memset(height[0], 0, sizeof(int) * WATERWID * WATERHGT);
  memset(height[1], 0, sizeof(int) * WATERWID * WATERHGT);
  bufptr = (uchr*) pbmp->dat;
  memcpy(bkgdimagepre, bufptr, WATERWID * WATERHGT);
  memcpy(bkgdimage, bufptr, WATERWID * WATERHGT);
  memcpy(bkgdimagepost, bufptr, WATERWID * WATERHGT);
  lastkey = K_d;
  do
    {
      switch (water_sort)
	{
	case 0:
	  water_surfer();
	  break;
	case 1:
	  water_raindrops();
	  break;
	case 2:
	  water_splashes();
	  break;
	case 3:
	  water_swirling();
	  break;
	case 4:
	  water_test1();
	  break;
	case 5:
	  water_test2();
	  break;
	case 6:
	  water_test3();
	  break;
	default:
	  break;
	}
      if (water_light)
	{
	  drawwaterwithlight(hpage, water_light - 1);
	}
      else
	{
	  drawwaternolight(hpage);
	}
      if (water_movement)
	{
	  calcwater(hpage^1, water_density);
	}
      else
	{
	  memcpy(&height[hpage^1][0], &height[hpage][0], sizeof(int) * WATERWID * WATERHGT);
	}
      hpage ^= 1;
      for (x = 0; x < 20; x++)
	{
	  if (retrace_count > x)
	    {
	      putpixel(pbmp, x << 1, 0, 255);
	    }
	  else
	    {
	      putpixel(pbmp, x << 1, 0, 0);
	    }
	  putpixel(pbmp, (x << 1) + 1, 0, 0);
	}
      retrace_count = 0;
      ptkeyparsetbl = tkeyparsetbl_water;
      key_scan();
      rest(water_delay);
    }
  while ((lastkey == K_d) || (lastkey == K_D) ||
	 (lastkey == K_e) || (lastkey == K_E) ||
	 (lastkey == K_h) || (lastkey == K_H) ||
	 (lastkey == K_l) || (lastkey == K_L) ||
	 (lastkey == K_m) || (lastkey == K_M) ||
	 (lastkey == K_o) || (lastkey == K_O) ||
	 (lastkey == K_r) || (lastkey == K_R) ||
	 (lastkey == K_s) || (lastkey == K_S) ||
	 (lastkey == K_x) || (lastkey == K_X) ||
	 (lastkey == K_y) || (lastkey == K_Y));
  if (lastkey == K_ESC)
    {
      esc_hit = 1;
    }
}
/*---------------------------------------------------------------------------*/
void water_raindrops()
{
  x = rand() % (WATERWID - 2) + 1;
  y = rand() % (WATERHGT - 2) + 1;
  height[hpage][y * WATERWID + x] = rand() % (water_height << 2);
}
/*---------------------------------------------------------------------------*/
void water_restore()
{
  keysee_insert();
}
/*---------------------------------------------------------------------------*/
void water_splashes()
{
  if (rand() % 20 == 0)
    {
      if (water_material == 0)
	{
	  heightblob(-1, -1, water_radius, water_height, hpage);
	}
      else
	{
	  sineblob(-1, -1, water_radius, -water_height, hpage);
	}
    }
}
/*---------------------------------------------------------------------------*/
void water_surfer()
{
  x = (WATERWID / 2) + ((((fsina((xang * 65) >> 8) >> 8) *
			  (fsina((xang * 349) >> 8) >> 8)) *
			 ((WATERWID - 8) / 2)) >> 16);
  y = (WATERHGT / 2) + ((((fsina((yang * 377) >> 8) >> 8) *
			  (fsina((yang * 84) >> 8) >> 8)) *
			 ((WATERHGT - 8) / 2)) >> 16);
  xang += 13;
  yang += 12;
  if (water_material == 0)
    {
      offset = (oy + y) / 2 * WATERWID + (ox + x) / 2;
      height[hpage][offset] = water_height;
      height[hpage][offset + 1] =
	height[hpage][offset - 1] =
	height[hpage][offset + WATERWID] =
	height[hpage][offset - WATERWID] = water_height >> 1;
      offset = y * WATERWID + x;
      height[hpage][offset] = water_height << 1;
      height[hpage][offset + 1] =
	height[hpage][offset - 1] =
	height[hpage][offset + WATERWID] =
	height[hpage][offset - WATERWID] = water_height;
    }
  else
    {
      sineblob((ox + x) / 2, (oy + y) / 2, 3, -1200, hpage);
      sineblob(x, y, 4, -2000, hpage);
    }
  ox = x;
  oy = y;
}
/*---------------------------------------------------------------------------*/
void water_swirling()
{
  x = (WATERWID / 2) + (((fcosa(swirlangle)) * (25)) >> 16);
  y = (WATERHGT / 2) + (((fsina(swirlangle)) * (25)) >> 16);
  swirlangle += 50;
  if (water_material == 0)
    {
      heightblob(x, y, water_radius / 3, water_height, hpage);
    }
  else
    {
      warpblob(x, y, water_radius, water_height, hpage);
    }
}
/*---------------------------------------------------------------------------*/
void water_test1()
{
  warpblob(water_x, water_y, water_radius, water_height, hpage);
}
/*---------------------------------------------------------------------------*/
void water_test2()
{
  sineblob(water_x, water_y, water_radius, water_height, hpage);
}
/*---------------------------------------------------------------------------*/
void water_test3()
{
  heightblob(water_x, water_y, water_radius, water_height, hpage);
}
