/* virtch.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
/*---------------------------------------------------------------------------*/
/* global variables : use */
/* driver variables */
extern driver *md_driver;
extern ushr md_device;
extern ushr md_mixfreq;
extern ushr md_dmabufsize;
extern ushr md_mode;
extern uchr md_numchn;
extern uchr md_bpm;
/*---------------------------------------------------------------------------*/
/* variables */
int ampshift;
ushr samplesthatfit;
static ushr TICKLEFT;
long idxsize, idxlpos, idxlend, maxvol;
long per256;
char *vsamples[MAXSAMPLEHANDLES];
long VC_TICKBUF[TICKLSIZE];
vinfo *vnf;
vinfo vinf[32];
/*---------------------------------------------------------------------------*/
int vc_init()
{
  int t;

  for (t = 0; t < md_numchn; t++)
    {
      vinf[t].current = 0;
      vinf[t].flags = 0;
      vinf[t].handle = 0;
      vinf[t].kick = 0;
      vinf[t].active = 0;
      vinf[t].frq = 10000;
      vinf[t].vol = 0;
      vinf[t].pan = (t & 1) ? 0 : 255;
    }
  return 1;
}
/*---------------------------------------------------------------------------*/
short vc_sampleload(FILE *fp, ulng length, ulng reppos, ulng repend, ushr flags)
{
  int handle;
  ulng t;

  sl_init(fp, flags, (flags | SF_SIGNED) & ~SF_16BITS);
  /* find empty slot to put sample address in */
  for (handle = 0; handle < MAXSAMPLEHANDLES; handle++)
    {
      if (vsamples[handle] == NULL)
	{
	  break;
	}
    }
  if (handle == MAXSAMPLEHANDLES)
    {
      mod_error();
      printf("(vc_sampleload) handle == MAXSAMPLEHANDLES\n");
      return -1;
    }
  if ((vsamples[handle] = malloc(length + 16)) == NULL)
    {
      mod_error();
      printf("(vc_sampleload) (vsamples[handle] = malloc(length + 16)) == NULL\n");
      return -1;
    }
  /* read sample into buffer */
  largeread(vsamples[handle], length);
  /* unclick samples: */
  if (flags & SF_LOOP)
    {
      if (flags & SF_BIDI)
	{
	  for (t = 0; t < 16; t++)
	    {
	      vsamples[handle][repend + t] = vsamples[handle][(repend - t) - 1];
	    }
	}
      else
	{
	  for (t = 0; t < 16; t++)
	    {
	      vsamples[handle][repend + t] = vsamples[handle][t + reppos];
	    }
	}
    }
  else
    {
      for (t = 0; t < 16; t++)
	{
	  vsamples[handle][t + length] = 0;
	}
    }
  return handle;
}
/*---------------------------------------------------------------------------*/
/* Writes 'todo' mixed chars (!!) to 'buf'. It returns the number of */
/* chars actually written to 'buf' (which is rounded to number of samples */
/* that fit into 'todo' bytes). */
ushr vc_writebytes(char *buf, ushr todo)
{
  todo = bytes2samples(todo);
  vc_writesamples(buf, todo);
  return samples2bytes(todo);
}
/*---------------------------------------------------------------------------*/
void vc_sampleunload(short handle)
{
  void *sampleadr = vsamples[handle];

  free(sampleadr);
  vsamples[handle] = NULL;
}
/*---------------------------------------------------------------------------*/
void vc_voiceplay(uchr voice, short handle, ulng start, ulng size, ulng reppos, ulng repend, ushr flags)
{
  if (start >= size)
    {
      return;
    }
  if (flags & SF_LOOP)
    {
      if (repend > size)
	{
	  repend = size; /* repend can't be bigger than size */
	}
    }
  vinf[voice].flags = flags;
  vinf[voice].handle = handle;
  vinf[voice].start = start;
  vinf[voice].size = size;
  vinf[voice].reppos = reppos;
  vinf[voice].repend = repend;
  vinf[voice].kick = 1;
}
/*---------------------------------------------------------------------------*/
void vc_voicesetfrequency(uchr voice, ulng frq)
{
  vinf[voice].frq = frq;
}
/*---------------------------------------------------------------------------*/
void vc_voicesetpanning(uchr voice, ulng pan)
{
  vinf[voice].pan = pan;
}
/*---------------------------------------------------------------------------*/
void vc_voicesetvolume(uchr voice, uchr vol)
{
  vinf[voice].vol = vol;
}
/*---------------------------------------------------------------------------*/
void vc_writesamples(char *buf, ushr todo)
{
  int t;
  ushr part;

  while (todo > 0)
    {
      if (TICKLEFT == 0)
	{
	  md_player();
	  TICKLEFT = (125L * md_mixfreq) / (50L * md_bpm);
	  /* compute volume, frequency counter & panning parameters for each channel */
	  for (t = 0; t < md_numchn; t++)
	    {
	      int pan, vol, lvol, rvol;
	      if (vinf[t].kick)
		{
		  vinf[t].current = (vinf[t].start << FRACBITS);
		  vinf[t].active = 1;
		  vinf[t].kick = 0;
		}
	      if (vinf[t].frq == 0)
		{
		  vinf[t].active = 0;
		}
	      if (vinf[t].active)
		{
		  vinf[t].increment = fraction2long(vinf[t].frq, md_mixfreq);
		  if (vinf[t].flags & SF_REVERSE)
		    {
		      vinf[t].increment = -vinf[t].increment;
		    }
		  vol = vinf[t].vol;
		  pan = vinf[t].pan;
		  if (md_mode & DMODE_STEREO)
		    {
		      lvol =  ( vol * (255-pan) ) / 255;
		      rvol =  ( vol * pan ) / 255;
		      vinf[t].lvolmul = (maxvol * lvol) / 64;
		      vinf[t].rvolmul = (maxvol * rvol) / 64;
		    }
		  else
		    {
		      vinf[t].lvolmul = (maxvol * vol) / 64;
		    }
		}
	    }
	}
      part = MIN(TICKLEFT, todo);
      vc_writeportion(buf, part);
      TICKLEFT -= part;
      todo -= part;
      buf += samples2bytes(part);
    }
}
/*---------------------------------------------------------------------------*/
void vc_sample32to8copy(long *srce, char *dest, ushr count)
{
  long c;
  int shift = (24 - ampshift);

  while (count--)
    {
      c = *srce >> shift;
      if (c > 127)
	{
	  c = 127;
	}
      else if (c < -128)
	{
	  c = -128;
	}
      *dest++ = c + 128;
      srce++;
    }
}
/*---------------------------------------------------------------------------*/
void vc_sample32to16copy(long *srce, short *dest, ushr count)
{
  long c;
  int shift = (16 - ampshift);

  while (count--)
    {
      c = *srce >> shift;
      if (c > 32767)
	{
	  c = 32767;
	}
      else if (c < -32768)
	{
	  c = -32768;
	}
      *dest++ = c;
      srce++;
    }
}
/*---------------------------------------------------------------------------*/
/* Converts the fraction 'dividend/divisor' into a fixed point longword. */
long fraction2long(ulng dividend, ushr divisor)
{
  ulng whole, part;

  whole = dividend / divisor;
  part = ((dividend % divisor) << FRACBITS) / divisor;
  return ((whole << FRACBITS) | part);
}
/*---------------------------------------------------------------------------*/
ushr samples2bytes(ushr samples)
{
  if (md_mode & DMODE_16BITS)
    {
      samples <<= 1;
    }
  if (md_mode & DMODE_STEREO)
    {
      samples <<= 1;
    }
  return samples;
}
/*---------------------------------------------------------------------------*/
ushr bytes2samples(ushr bytes)
{
  if (md_mode & DMODE_16BITS)
    {
      bytes >>= 1;
    }
  if (md_mode & DMODE_STEREO)
    {
      bytes >>= 1;
    }
  return bytes;
}
/*---------------------------------------------------------------------------*/
int largeread(char *buffer, ulng size)
{
  int t;
  ulng todo;

  while (size)
    {
      /* how many bytes to load (in chunks of 8000) ? */
      todo = (size > 8000) ? 8000 : size;
      /* read data */
      sl_load(buffer, todo);
      /* and update pointers.. */
      size -= todo;
      buffer += todo;
    }
  return 1;
}
/*---------------------------------------------------------------------------*/
void (*samplemix)(char *srce, long *dest, long index, long increment, long lvolt, long rvolt, ushr todo);
/*---------------------------------------------------------------------------*/
void mixstereonormal(char *srce, long *dest, long index, long increment, long lvolt, long rvolt, ushr todo)
{
  char sample;

  while (todo > 0)
    {
      sample = srce[index >> FRACBITS];
      *(dest++) += lvolt * sample;
      *(dest++) += rvolt * sample;
      index += increment;
      todo--;
    }
}
/*---------------------------------------------------------------------------*/
void mixmononormal(char *srce, long *dest, long index, long increment, long lvolt, long rvolt, ushr todo)
{
  char sample;

  while (todo > 0)
    {
      sample = srce[index >> FRACBITS];
      *(dest++) += lvolt * sample;
      index += increment;
      todo--;
    }
}
/*---------------------------------------------------------------------------*/
void mixstereointerp(char *srce, long *dest, long index, long increment, long lvolt, long rvolt, ushr todo)
{
  short sample, a, b;

  while (todo > 0)
    {
      a = srce[index >> FRACBITS];
      b = srce[1 + (index >> FRACBITS)];
      sample = a + (((long)(b - a) * (index & FRACMASK)) >> FRACBITS);
      *(dest++) += lvolt * sample;
      *(dest++) += rvolt * sample;
      index += increment;
      todo--;
    }
}
/*---------------------------------------------------------------------------*/
void mixmonointerp(char *srce, long *dest, long index, long increment, long lvolt, long rvolt, ushr todo)
{
  short sample, a, b;

  while (todo > 0)
    {
      a = srce[index >> FRACBITS];
      b = srce[1 + (index >> FRACBITS)];
      sample = a + (((long)(b - a) * (index & FRACMASK)) >> FRACBITS);
      *(dest++) += lvolt * sample;
      index += increment;
      todo--;
    }
}
/*---------------------------------------------------------------------------*/
/* This functions returns the number of resamplings we can do so that: */
/* - it never accesses indexes bigger than index 'end' */
/* - it doesn't do more than 'todo' resamplings */
ushr newpredict(long index, long end, long increment, ushr todo)
{
  long di;

  di = (end - index) / increment;
  index += (di * increment);
  if (increment < 0)
    {
      while (index >= end)
	{
	  index += increment;
	  di++;
	}
    }
  else
    {
      while (index <= end)
	{
	  index += increment;
	  di++;
	}
    }
  return ((di < todo) ? di : todo);
}
/*---------------------------------------------------------------------------*/
/* Mixes 'todo' stereo or mono samples of the current channel to the tickbuffer. */
void vc_addchannel(long *ptr, ushr todo)
{
  long end;
  ushr done, needs;
  char *s;

  while (todo > 0)
    {
      /* update the 'current' index so the sample loops, or */
      /* stops playing if it reached the end of the sample */
      if (vnf->flags & SF_REVERSE)
	{
	  /* The sample is playing in reverse */
	  if (vnf->flags & SF_LOOP)
	    {
	      /* the sample is looping, so check if */
	      /* it reached the loopstart index */
	      if (vnf->current < idxlpos)
		{
		  if (vnf->flags & SF_BIDI)
		    {
		      /* sample is doing bidirectional loops, so 'bounce' */
		      /* the current index against the idxlpos */
		      vnf->current = idxlpos + (idxlpos - vnf->current);
		      vnf->flags &= ~SF_REVERSE;
		      vnf->increment = -vnf->increment;
		    }
		  else
		    /* normal backwards looping, so set the current position to loopend index */
		    vnf->current = idxlend - (idxlpos - vnf->current);
		}
	    }
	  else
	    {
	      /* the sample is not looping, so check if it reached index 0 */
	      if (vnf->current < 0)
		{
		  /* playing index reached 0, so stop playing this sample */
		  vnf->current = 0;
		  vnf->active = 0;
		  break;
		}
	    }
	}
      else
	{
	  /* The sample is playing forward */
	  if (vnf->flags & SF_LOOP)
	    {
	      /* the sample is looping, so check if it reached the loopend index */
	      if (vnf->current > idxlend)
		{
		  if (vnf->flags & SF_BIDI)
		    {
		      /* sample is doing bidirectional loops, so 'bounce' */
		      /* the current index against the idxlend */
		      vnf->flags |= SF_REVERSE;
		      vnf->increment = -vnf->increment;
		      vnf->current = idxlend - (vnf->current - idxlend);
		    }
		  else
		    {
		      /* normal backwards looping, so set the current position to loopend index*/
		      vnf->current = idxlpos + (vnf->current - idxlend);
		    }
		}
	    }
	  else
	    {
	      /* sample is not looping, so check if it reached the last position */
	      if (vnf->current > idxsize)
		{
		  /* yes, so stop playing this sample */
		  vnf->current = 0;
		  vnf->active = 0;
		  break;
		}
	    }
	}
      /* Vraag een far ptr op van het sampleadres op byte offset vnf->current, en */
      /* hoeveel samples daarvan geldig zijn (VOORDAT segment overschrijding optreed) */
      if (!(s = vsamples[vnf->handle]))
	{
	  vnf->current = 0;
	  vnf->active = 0;
	  break;
	}
      if (vnf->flags & SF_REVERSE)
	{
	  end = (vnf->flags & SF_LOOP) ? idxlpos : 0;
	}
      else
	{
	  end = (vnf->flags & SF_LOOP) ? idxlend : idxsize;
	}
      /* Als de sample simpelweg niet beschikbaar is, of als sample gestopt moet worden */
      /* sample stilleggen en stoppen */
      /* mix 'em: */
      done = newpredict(vnf->current, end, vnf->increment, todo);
      if (!done)
	{
	  printf("predict stopped it. current %ld, end %ld\n", vnf->current, end);
	  vnf->active = 0;
	  break;
	}
      samplemix(s, ptr, vnf->current, vnf->increment, vnf->lvolmul, vnf->rvolmul, done);
      vnf->current += (vnf->increment * done);
      todo -= done;
      ptr += (md_mode & DMODE_STEREO) ? (done << 1) : done;
    }
}
/*---------------------------------------------------------------------------*/
/* Mixes 'todo' samples to 'buf'.. The number of samples has to fit into the tickbuffer. */
void vc_filltick(char *buf, ushr todo)
{
  int t;

  /* clear the mixing buffer: */
  memset(VC_TICKBUF, 0, (md_mode & DMODE_STEREO) ? todo << 3 : todo << 2);
  for (t = 0; t < md_numchn; t++)
    {
      vnf = &vinf[t];
      vnf = &vinf[t];
      idxsize = (vnf->size << FRACBITS) - 1;
      idxlpos = vnf->reppos << FRACBITS;
      idxlend = (vnf->repend << FRACBITS) - 1;
      if (vnf->active)
	{
	  vc_addchannel(VC_TICKBUF, todo);
	}
    }
  if (md_mode & DMODE_16BITS)
    {
      vc_sample32to16copy(VC_TICKBUF, (short *)buf, (md_mode & DMODE_STEREO) ? todo << 1 : todo);
    }
  else
    {
      vc_sample32to8copy(VC_TICKBUF, buf, (md_mode & DMODE_STEREO) ? todo << 1 : todo);
    }
}
/*---------------------------------------------------------------------------*/
/* Writes 'todo' mixed SAMPLES (!!) to 'buf'. When todo is bigger than the */
/* number of samples that fit into VC_TICKBUF, the mixing operation is split */
/* up into a number of smaller chunks. */
void vc_writeportion(char *buf, ushr todo)
{
  ushr part;

  /* write 'part' samples to the buffer */
  while (todo)
    {
      part = MIN(todo, samplesthatfit);
      vc_filltick(buf, part);
      buf += samples2bytes(part);
      todo -= part;
    }
}
/*---------------------------------------------------------------------------*/
void vc_playstart()
{
  int t;
  long q, c;
  ushr i;

  maxvol = 16777200L / md_numchn;
  /* instead of using an amplifying lookup table, I'm using a simple shift */
  /* amplify now.. amplifying doubles with every extra 4 channels, and also */
  /* doubles in stereo mode.. this seems to give similar volume levels */
  /* across the channel range */
  ampshift = md_numchn / 8;
  if (md_mode & DMODE_STEREO)
    {
      ampshift++;
    }

  if (md_mode & DMODE_INTERP)
    {
      samplemix = (md_mode & DMODE_STEREO) ? mixstereointerp : mixmonointerp;
    }
  else
    {
      samplemix = (md_mode & DMODE_STEREO) ? mixstereonormal : mixmononormal;
    }
  samplesthatfit = TICKLSIZE;
  if (md_mode & DMODE_STEREO)
    {
      samplesthatfit >>= 1;
    }
  TICKLEFT = 0;
}
