/* type.h v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* type */
struct lzw_string
{
  short base;
  char new;
  short length;
};
/*---------------------------------------------------------------------------*/
typedef __dpmi_paddr *pvi;
/*---------------------------------------------------------------------------*/
typedef struct
{
  uchr dma_disable; /* bits to disable dma channel */
  uchr dma_enable; /* bits to enable dma channel */
  ushr page; /* page port location */
  ushr addr; /* addr port location */
  ushr count; /* count port location */
  ushr single; /* single mode port location */
  ushr mode; /* mode port location */
  ushr clear_ff; /* clear flip-flop port location */
  uchr write; /* bits for write transfer */
  uchr read; /* bits for read transfer */
} dma_entry;
/*---------------------------------------------------------------------------*/
typedef struct envpt
{
  short pos;
  short val;
} envpt;
/*---------------------------------------------------------------------------*/
typedef struct envpr
{
  uchr flg; /* envelope flag */
  uchr pts; /* number of envelope points */
  uchr sus; /* envelope sustain index */
  uchr beg; /* envelope loop begin */
  uchr end; /* envelope loop end */
  short p; /* current envelope counter */
  ushr a; /* envelope index a */
  ushr b; /* envelope index b */
  envpt *env; /* envelope points */
} envpr;
/*---------------------------------------------------------------------------*/
typedef struct msample
{
  ushr c2spd; /* finetune frequency */
  char transpose; /* transpose value */
  uchr volume; /* volume 0-64 */
  uchr panning; /* panning */
  ulng length; /* length of sample (in samples !) */
  ulng loopstart; /* repeat position (relative to start, in samples) */
  ulng loopend; /* repeat end */
  ushr flags; /* sample format */
  ulng seekpos; /* seek position in file */
  char *samplename; /* name of the sample */
  short handle; /* sample handle */
} msample;
/*---------------------------------------------------------------------------*/
typedef struct instrument
{
  uchr numsmp;
  uchr samplenumber[96];

  uchr volflg; /* bit 0: on 1: sustain 2: loop */
  uchr volpts;
  uchr volsus;
  uchr volbeg;
  uchr volend;
  envpt volenv[12];

  uchr panflg; /* bit 0: on 1: sustain 2: loop */
  uchr panpts;
  uchr pansus;
  uchr panbeg;
  uchr panend;
  envpt panenv[12];

  uchr vibtype;
  uchr vibsweep;
  uchr vibdepth;
  uchr vibrate;

  ushr volfade;
  char *insname;
  msample *samples;
} instrument;
/*---------------------------------------------------------------------------*/
typedef struct audtmp
{
  instrument *i;
  msample *s;

  short fadevol; /* fading volume */

  envpr venv;
  envpr penv;

  uchr keyon; /* if true=key is pressed */
  uchr kick; /* if true=sample has to be restarted */
  uchr sample; /* which sample number (0-31) */
  short handle; /* which sample-handle */

  ulng start; /* the start byte index in the sample */

  uchr panning; /* panning position */
  uchr pansspd; /* panslide speed */

  char volume; /* amiga volume (0 t/m 64) to play the sample at */
  ushr period; /* period to play the sample at */

  /* you should not have to use the values below in the player routine */

  char transpose;

  uchr note;

  short ownper;
  short ownvol;

  uchr *row; /* row currently playing on this channel */

  char retrig; /* retrig value (0 means don't retrig) */
  ushr c2spd; /* what finetune to use */

  char tmpvolume; /* tmp volume */

  ushr tmpperiod; /* tmp period */
  ushr wantedperiod; /* period to slide to (with effect 3 or 5) */

  ushr slidespeed;
  ushr portspeed; /* noteslide speed (toneportamento) */

  uchr s3mtremor; /* s3m tremor (effect I) counter */

  uchr s3mvolslide; /* last used volslide */

  uchr s3mrtgspeed; /* last used retrig speed */
  uchr s3mrtgslide; /* last used retrig slide */

  uchr glissando; /* glissando (0 means off) */
  uchr wavecontrol;

  char vibpos; /* current vibrato position */
  uchr vibspd;	/* "" speed */
  uchr vibdepth; /* "" depth */

  char trmpos; /* current tremolo position */
  uchr trmspd; /* "" speed */
  uchr trmdepth; /* "" depth */

  ushr soffset; /* last used sample-offset (effect 9) */
} audtmp;
/*---------------------------------------------------------------------------*/
typedef struct driver
{
  struct driver *next;
  char *name;
  char *version;
  int (*ispresent)();
  short (*sampleload)(FILE *fp, ulng size, ulng reppos, ulng repend, ushr flags);
  void (*sampleunload) (short handle);
  int (*init)();
  void (*exit)();
  void (*playstart)();
  void (*playstop)();
  void (*update)();
  void (*voicesetvolume)(uchr voice, uchr vol);
  void (*voicesetfrequency)(uchr voice, ulng frq);
  void (*voicesetpanning)(uchr voice, ulng pan);
  void (*voiceplay)(uchr voice, short handle, ulng start, ulng size, ulng reppos, ulng repend, ushr flags);
} driver;
/*---------------------------------------------------------------------------*/
typedef struct loader
{
  struct loader *next;
  char *type;
  char *version;
  int (*init)();
  int (*test)();
  int (*load)();
  void (*cleanup)();
} loader;
/*---------------------------------------------------------------------------*/
typedef struct modnote
{
  uchr a, b, c, d;
} modnote;
/*---------------------------------------------------------------------------*/
/* struct to identify type of module */
typedef struct modtype
{
  char id[4];
  uchr channels;
  char *name;
} modtype;
/*---------------------------------------------------------------------------*/
/* sample header as it appears in a module */
typedef struct msampinfo
{
  uchr samplename[22];
  ushr length;
  uchr finetune;
  uchr volume;
  ushr reppos;
  ushr replen;
} msampinfo;
/*---------------------------------------------------------------------------*/
/* module header */
typedef struct moduleheader
{
  uchr songname[20]; /* the songname */
  msampinfo samples[31]; /* all sampleinfo */
  uchr songlength; /* number of patterns used */
  uchr magic1; /* should be 127 */
  uchr positions[128];	/* which pattern to play at pos */
  uchr magic2[4]; /* string "M.K." or "FLT4" or "FLT8" */
} moduleheader;
/*---------------------------------------------------------------------------*/
typedef struct mtmheader
{
  uchr id[3]; /* MTM file marker */
  uchr version;	/* upper major, lower nibble minor version number */
  char songname[20]; /* ASCIIZ songname */
  ushr numtracks; /* number of tracks saved */
  uchr lastpattern; /* last pattern number saved */
  uchr lastorder; /* last order number to play (songlength - 1) */
  ushr commentsize; /* length of comment field */
  uchr numsamples; /* number of samples saved */
  uchr attribute; /* attribute byte (unused) */
  uchr beatspertrack; /* */
  uchr numchannels; /* number of channels used */
  uchr panpos[32]; /* voice pan positions */
} mtmheader;
/*---------------------------------------------------------------------------*/
typedef struct mtmnote
{
  uchr a, b, c;
} mtmnote;
/*---------------------------------------------------------------------------*/
typedef struct mtmsample
{
  char samplename[22];
  ulng length;
  ulng reppos;
  ulng repend;
  uchr finetune;
  uchr volume;
  uchr attribute;
} mtmsample;
/*---------------------------------------------------------------------------*/
typedef struct
{
  float x, y; /* position */
  float xdir, ydir; /* velocity */
  int size, mass; /* radius in pixels, and mass used in calculations */
  int color; /* screen color */
} planet;
/*---------------------------------------------------------------------------*/
typedef struct s3mheader
{
  char songname[28];
  char t1a;
  char type;
  char unused1[2];
  ushr ordnum;
  ushr insnum;
  ushr patnum;
  ushr flags;
  ushr tracker;
  ushr fileformat;
  char scrm[4];
  uchr mastervol;
  uchr initspeed;
  uchr inittempo;
  uchr mastermult;
  uchr ultraclick;
  uchr pantable;
  char unused2[8];
  ushr special;
  uchr channels[32];
} s3mheader;
/*---------------------------------------------------------------------------*/
typedef struct s3mnote
{
  uchr note, ins, vol, cmd, inf;
} s3mnote;
/*---------------------------------------------------------------------------*/
typedef struct s3msample
{
  uchr type;
  char filename[12];
  uchr memsegh;
  ushr memsegl;
  ulng length;
  ulng loopbeg;
  ulng loopend;
  uchr volume;
  uchr dsk;
  uchr pack;
  uchr flags;
  ulng c2spd;
  char unused[12];
  char sampname[28];
  char scrs[4];
} s3msample;
/*---------------------------------------------------------------------------*/
typedef struct sample
{
  uchr type;
  uint size;
  long offset;
  char *filename;
} sample;
/*---------------------------------------------------------------------------*/
typedef struct tfilename
{
  char fn[256];
  uchr sel;
  ushr col;
} tfilename;
/*---------------------------------------------------------------------------*/
typedef struct tkeyparse
{
  int key;
  void (*key_handler)();
} tkeyparse;
/*---------------------------------------------------------------------------*/
typedef struct unimod
{
  uchr numchn; /* number of channels */
  ushr numpos; /* number of positions in this song */
  ushr reppos; /* restart position */
  ushr numpat; /* number of patterns in this song */
  ushr numtrk; /* number of tracks */
  ushr numins; /* number of samples */
  uchr initspeed;
  uchr inittempo;
  uchr positions[256]; /* all positions */
  uchr panning[32]; /* 32 panning positions */
  uchr flags;
  char *songname; /* name of the song */
  char *modtype; /* string type of module */
  char *comment; /* module comments */
  instrument *instruments; /* all samples */
  ushr *patterns; /* array of PATTERN */
  ushr *pattrows; /* array of number of rows for each pattern */
  uchr **tracks; /* array of pointers to tracks */
} unimod;
/*---------------------------------------------------------------------------*/
typedef struct
{
  uchr kick; /* =1 -> sample has to be restarted */
  uchr active; /* =1 -> sample is playing */
  ushr flags; /* 16/8 bits looping/one-shot */
  short handle; /* identifies the sample */
  ulng start; /* start index */
  ulng size; /* samplesize */
  ulng reppos; /* loop start */
  ulng repend; /* loop end */
  ulng frq; /* current frequency */
  uchr vol; /* current volume */
  uchr pan; /* current panning position */
  long current; /* current index in the sample */
  long increment; /* fixed-point increment value */
  long lvolmul; /* left volume multiply */
  long rvolmul; /* right volume multiply */
} vinfo;
/*---------------------------------------------------------------------------*/
typedef struct wavformat
{
  ushr wformattag; /* format type */
  ushr nchannels; /* number of channels (i.e. mono, stereo...) */
  uint nsamplespersec; /* sample rate */
  uint navgbytespersec; /* for buffer estimation */
  ushr nblockalign; /* block size of data */
  ushr wbitspersample;
} wavformat;
/*---------------------------------------------------------------------------*/
typedef struct xmheader
{
  char id[17]; /* ID text: 'Extended module: ' */
  char songname[21]; /* Module name, padded with zeroes and 0x1A at the end */
  char trackername[20]; /* Tracker name */
  ushr version; /* (word) version number, hi-byte major and low-byte minor */
  ulng headersize; /* Header size */
  ushr songlength; /* (word) Song length (in pattern order table) */
  ushr restart; /* (word) Restart position */
  ushr numchn; /* (word) Number of channels (2,4,6,8,10,...,32) */
  ushr numpat; /* (word) Number of patterns (max 256) */
  ushr numins; /* (word) Number of instruments (max 128) */
  /* (word) Flags: bit 0: 0 = Amiga frequency table (see below) */
  /*                      1 = Linear frequency table */
  ushr flags;
  ushr tempo; /* (word) Default tempo */
  ushr bpm; /* (word) Default BPM */
  uchr orders[256]; /* (byte) Pattern order table */
} xmheader;
/*---------------------------------------------------------------------------*/
typedef struct xminstheader
{
  ulng size; /* (dword) instrument size */
  char name[22]; /* (char) instrument name */
  uchr type; /* (byte) instrument type (always 0) */
  ushr numsmp; /* (word) number of samples in instrument */
  ulng ssize;
} xminstheader;
/*---------------------------------------------------------------------------*/
typedef struct xmnote
{
  uchr note, ins, vol, eff, dat;
} xmnote;
/*---------------------------------------------------------------------------*/
typedef struct xmpatchheader
{
  uchr what[96]; /* (byte) sample number for all notes */
  uchr volenv[48]; /* (byte) points for volume envelope */
  uchr panenv[48]; /* (byte) points for panning envelope */
  uchr volpts; /* (byte) number of volume points */
  uchr panpts; /* (byte) number of panning points */
  uchr volsus; /* (byte) volume sustain point */
  uchr volbeg; /* (byte) volume loop start point */
  uchr volend; /* (byte) volume loop end point */
  uchr pansus; /* (byte) panning sustain point */
  uchr panbeg; /* (byte) panning loop start point */
  uchr panend; /* (byte) panning loop end point */
  uchr volflg; /* (byte) volume type: bit 0: on; 1: sustain; 2: loop */
  uchr panflg; /* (byte) panning type: bit 0: on; 1: sustain; 2: loop */
  uchr vibflg; /* (byte) vibrato type */
  uchr vibsweep; /* (byte) vibrato sweep */
  uchr vibdepth; /* (byte) vibrato depth */
  uchr vibrate; /* (byte) vibrato rate */
  ushr volfade; /* (word) volume fadeout */
  ushr reserved[11]; /* (word) reserved */
} xmpatchheader;
/*---------------------------------------------------------------------------*/
typedef struct xmpatheader
{
  ulng size; /* (dword) pattern header length */
  uchr packing; /* (byte) packing type (always 0) */
  ushr numrows; /* (word) number of rows in pattern (1..256) */
  ushr packsize; /* (word) packed patterndata size */
} xmpatheader;
/*---------------------------------------------------------------------------*/
typedef struct xmwavheader
{
  ulng length; /* (dword) sample length */
  ulng loopstart; /* (dword) sample loop start */
  ulng looplength; /* (dword) sample loop length */
  uchr volume; /* (byte) volume */
  char finetune; /* (byte) finetune (signed byte -128..+127) */
  uchr type; /* (byte) Type: Bit 0-1: 0 = No loop, 1 = Forward loop, */
  /*                                  2 = Ping-pong loop; */
  /*                                  4 = 16-bit sampledata */
  uchr panning; /* (byte) panning (0-255) */
  char relnote; /* (byte) relative note number (signed byte) */
  uchr reserved; /* (byte) reserved */
  char samplename[22]; /* (char) sample name */
} xmwavheader;
