/* see.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
#include <allegro.h>
#include <jpeg.h>
/*---------------------------------------------------------------------------*/
/* global variables : use */
extern int lastkey;
extern int esc_hit;
extern struct tkeyparse **ptkeyparsetbl;
/*---------------------------------------------------------------------------*/
/* global variables : declare */
BITMAP *pbmp; /* contains the currently displayed bitmap = workcopy */
BITMAP *pbmpo; /* contains the originally loaded bitmap = restore */
PALETTE pal; /* contains the currently displayed palette = workcopy */
PALETTE palo; /* contains the originally loaded palette = restore */
/*---------------------------------------------------------------------------*/
/* variables */
uchr confname[256], intrname[256], loginname[256];
uchr string[4096];
char retvalsee[256];
int empty_string, curr_bit_size, bit_overflow;
int bit_pos, data_pos, data_len, entire, code;
int cc, string_length, i, bit_size;
int image_x, image_y, image_w, image_h, x, y;
int interlace;
struct lzw_string str[4096];
BITMAP *bmp; /* used in load_gif and in output_string */
PACKFILE *f;
/*---------------------------------------------------------------------------*/
/* prototypes */
void writemap(char s[256], PALLETE apal);
/*---------------------------------------------------------------------------*/
static tkeyparse
  see_end = {K_END, keysee_end},
  see_f1 = {K_F1, keysee_f1},
  see_f2 = {K_F2, keysee_f2},
  see_f3 = {K_F3, keysee_f3},
  see_f4 = {K_F4, keysee_f4},
  see_f5 = {K_F5, keysee_f5},
  see_f6 = {K_F6, keysee_f6},
  see_f7 = {K_F7, keysee_f7},
  see_f8 = {K_F8, keysee_f8},
  see_f9 = {K_F9, keysee_f9},
  see_f10 = {K_F10, keysee_f10},
  see_home = {K_HOME, keysee_home},
  see_i = {K_I, keysee_i},
  see_insert = {K_INSERT, keysee_insert},
  see_pagedown = {K_PAGEDOWN, keysee_pagedown},
  see_pageup = {K_PAGEUP, keysee_pageup}
;

tkeyparse* tkeyparsetbl_see[] =
{
  &see_end,
  &see_f1,
  &see_f2,
  &see_f3,
  &see_f4,
  &see_f5,
  &see_f6,
  &see_f7,
  &see_f8,
  &see_f9,
  &see_f10,
  &see_home,
  &see_i,
  &see_insert,
  &see_pagedown,
  &see_pageup,
  NULL
};
/*---------------------------------------------------------------------------*/
/* local prototypes */
BITMAP *load_gif(char *filename, RGB *pal);
/*---------------------------------------------------------------------------*/
void main(int argc, char *argv[])
{
  char d[MAXDRIVE], p[MAXDIR], f[MAXFILE], e[MAXEXT], *s;
  int choice = 0; /* choice default to BMP|LBM|PCX|TGA */

  if (argc < 2)
    {
      printf("\nSEE v0.70 (copywrong) 1997-1998 by Edward Boone\n");
      printf("usage : see filename.[BMP|FLC|FLI|GIF|JPG|LBM|PCX|TGA]\n");
      exit(1);
    }
  s = getenv("mi_login");
  if (!s) /* mi_login is not known if you run this program as a standalone program */
    {
      strcpy(confname, DEFNAME);
      strcpy(intrname, INTRNAME);
    }
  else
    {
      strcpy(loginname, s);
      sprintf(confname, "%smich%s.txt", EXEPATH, loginname);
      sprintf(intrname, "%sintr%s.txt", UTILPATH, loginname);
    }
  set_config_file(confname);
  strcpy(retvalsee, argv[1]);
  fnsplit(retvalsee, d, p, f, e);
  strlwr(e);
  if (!strcmp(e, ".bmp")) choice = 0;
  else if (!strcmp(e, ".flc")) choice = 1;
  else if (!strcmp(e, ".fli")) choice = 1;
  else if (!strcmp(e, ".gif")) choice = 2;
  else if (!strcmp(e, ".jpg")) choice = 3;
  else if (!strcmp(e, ".lbm")) choice = 0;
  else if (!strcmp(e, ".pcx")) choice = 0;
  else if (!strcmp(e, ".tga")) choice = 0;
  switch(choice)
    {
    case 0:
      {
	see_xxx();
	break;
      }
    case 1:
      {
	see_fli();
	break;
      }
    case 2:
      {
	see_gif();
	break;
      }
    case 3:
      {
	see_jpg();
	break;
      }
    }

  get_palette(pal); /* save pal to pal */
  get_palette(palo); /* save pal to palo */

  pbmpo = create_bitmap(SCREEN_W, SCREEN_H); /* save pbmp to pbmpo */
  blit(pbmp, pbmpo, 0, 0, 0, 0, SCREEN_W, SCREEN_H);

  main_loops();
  destroy_bitmap(pbmp);
}
/*---------------------------------------------------------------------------*/
void clear_table()
{
  empty_string = cc + 2;
  curr_bit_size = bit_size + 1;
  bit_overflow = 0;
}
/*---------------------------------------------------------------------------*/
void cs2doss(char* s)
{
  char* p;
  for (p = s; *p; ++p)
    {
      if (*p == '/')
	*p = '\\';
      if (isupper(*p))
	*p = tolower(*p);
    }
}
/*---------------------------------------------------------------------------*/
void get_code()
{
  if (bit_pos + curr_bit_size > 8)
    {
      if (data_pos >= data_len)
	{
	  data_len = pack_getc(f);
	  data_pos = 0;
	}
      entire = (pack_getc(f) << 8) + entire;
      data_pos++;
    }
  if (bit_pos + curr_bit_size > 16)
    {
      if (data_pos >= data_len)
	{
	  data_len = pack_getc(f);
	  data_pos = 0;
	}
      entire = (pack_getc(f) << 16) + entire;
      data_pos++;
    }
  code = (entire >> bit_pos) & ((1 << curr_bit_size) - 1);
  if (bit_pos + curr_bit_size > 8)
    entire >>= 8;
  if (bit_pos + curr_bit_size > 16)
    entire >>= 8;
  bit_pos = (bit_pos + curr_bit_size) % 8;
  if (bit_pos == 0)
    {
      if (data_pos >= data_len)
	{
	  data_len = pack_getc(f);
	  data_pos = 0;
	}
      entire = pack_getc(f);
      data_pos++;
    }
}
/*---------------------------------------------------------------------------*/
void get_string(int num)
{
  if (num < cc)
    {
      string_length = 1;
      string[0] = str[num].new;
    }
  else
    {
      i = str[num].length;
      string_length = i;
      while (i > 0)
	{
	  i--;
	  string[i] = str[num].new;
	  num = str[num].base;
	}
    }
}
/*---------------------------------------------------------------------------*/
int key_checker()
{
  int step = FALSE;

  if (step)
    {
      if ((readkey() & 0xFF) == 27)
	return 1;
      else
	return 0;
    }
  else
    {
      if (keypressed())
	return 1;
      else
	return 0;
    }
}
/*---------------------------------------------------------------------------*/
/* write pal to .map in DATAPATH */
/* in format 0..255 */
void keysee_end()
{
  char d[MAXDRIVE], p[MAXDIR], f[MAXFILE], e[MAXEXT], s[256];
  fnsplit(retvalsee, d, p, f, e);
  sprintf(s, "%s%s%s", DATAPATH, f, ".map");
  writemap(s, pal);
}
/*---------------------------------------------------------------------------*/
void keysee_f1()
{
  keysee_f1_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f2()
{
  keysee_f2_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f3()
{
  keysee_f3_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f4()
{
  keysee_f4_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f5()
{
  keysee_f5_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f6()
{
  keysee_f6_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f7()
{
  keysee_f7_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f8()
{
  keysee_f8_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f9()
{
  keysee_f9_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f10()
{
  keysee_f10_0();
}
/*---------------------------------------------------------------------------*/
void keysee_home()
{
  set_palette(palo);
  get_palette(pal);
}
/*---------------------------------------------------------------------------*/
void keysee_i()
{
  char *s = "", s0[256] = "";
  char *p;
  FILE *t;

  t = NULL;
  s = searchpath(retvalsee);
  p = s;
  if (*p == '.')
    {
      p++;
      getcwd(s0, 100);
      strcat(s0, p);
    }
  cs2doss(s0);
  if (!access(intrname, F_OK))
    {
      t = fopen(intrname, "at");
      fprintf(t, "%s\n", s0);
    }
  else
    {
      t = fopen(intrname, "wt");
      fprintf(t, "%s\n", s0);
    }
  fclose(t);
}
/*---------------------------------------------------------------------------*/
void keysee_insert()
{
  blit(pbmpo, pbmp, 0, 0, 0, 0, SCREEN_W, SCREEN_H); /* save pbmpo to pbmp */
  blit(pbmp, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}
/*---------------------------------------------------------------------------*/
#define BORDER 5

void keysee_pagedown()
{
  char dir[256], drive[256], ext[256], name[256];
  char s[256];
  BITMAP *pbmp1, *pbmp2, *pbmp3;
  PALETTE apal;

  get_palette(apal);
  pbmp1 = create_bitmap(SCREEN_W, SCREEN_H);
  pbmp3 = create_bitmap(SCREEN_W, SCREEN_H);
  blit(screen, pbmp1, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
  pbmp2 = create_sub_bitmap(pbmp1, BORDER, BORDER, SCREEN_W - (2*BORDER), SCREEN_H - (2*BORDER));

  stretch_blit(pbmp2, pbmp3, 0, 0, pbmp2->w, pbmp2->h, 0, 0, SCREEN_W, SCREEN_H);

  fnsplit(retvalsee, drive, dir, name, ext);
  sprintf(s, "%s%s.pcx", DATAPATH, name);
  save_bitmap(s, pbmp3, apal);

  destroy_bitmap(pbmp1);
  destroy_bitmap(pbmp2);
  destroy_bitmap(pbmp3);
}
/*---------------------------------------------------------------------------*/
void keysee_pageup()
{
  blit(pbmpo, pbmp, 0, 0, 0, 0, SCREEN_W, SCREEN_H); /* save pbmpo to pbmp */
  blit(pbmp, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);

  set_palette(palo);
  get_palette(pal);
}
/*---------------------------------------------------------------------------*/
/* load_gif : loads a 2-256 colour GIF file onto a bitmap, returning the
   bitmap structure and storing the pallete data in the specified pallete
   (this should be an array of at least 256 RGB structures) */

BITMAP* load_gif(char *filename, RGB * pal)
{
  int width, height, depth;
  int old;
  BITMAP *bmp2;
  int dest_depth;

  f = pack_fopen(filename, F_READ);
  if (!f) /* could not open filename */
    {
      return NULL;
    }

  i = pack_mgetw(f) << 8;
  i += pack_getc(f);
  if (i != 0x474946) /* it's not in the GIF-format */
    {
      pack_fclose(f);
      return NULL;
    }
  pack_fseek(f, 3); /* skip version */

  width = pack_igetw(f);
  height = pack_igetw(f);

  bmp = create_bitmap_ex(8, width, height);
  if (bmp == NULL) /* couldn't create bitmap */
    {
      pack_fclose(f);
      return NULL;
    }
  clear(bmp);

  i = pack_getc(f);
  if (i & 128)
    depth = (i & 7) + 1;
  else
    depth = 0; /* no global colour table */

  pack_fseek(f, 2); /* skip background colour and aspect ratio */

  if (pal && depth) /* only read palette if pal and depth are not 0 */
    {
      for (i = 0; i < (1 << depth); i++)
	{
	  pal[i].r = pack_getc(f) / 4;
	  pal[i].g = pack_getc(f) / 4;
	  pal[i].b = pack_getc(f) / 4;
	}
    }
  else
    if (depth)
      {
	pack_fseek(f, (1 << depth) * 3);
      }

  do
    {
      i = pack_getc(f);
      switch (i)
	{
	case 0x2C: /* image descriptor */
	  image_x = pack_igetw(f); /* individual image dimensions */
	  image_y = pack_igetw(f);
	  image_w = pack_igetw(f);
	  image_h = pack_igetw(f);

	  i = pack_getc(f);
	  if (i & 64)
	    interlace = 8;
	  else
	    interlace = 1;

	  if (i & 128)
	    {
	      depth = (i & 7) + 1;
	      if (pal)
		{
		  for (i = 0; i < (1 << depth); i++)
		    {
		      pal[i].r = pack_getc(f) / 4;
		      pal[i].g = pack_getc(f) / 4;
		      pal[i].b = pack_getc(f) / 4;
		    }
		}
	      else
		pack_fseek(f, (1 << depth) * 3);
	    }
	  /* lzw stream starts now */
	  bit_size = pack_getc(f);
	  cc = 1 << bit_size;
	  
	  /* initialise string table */
	  for (i = 0; i < cc; i++)
	    {
	      str[i].base = -1;
	      str[i].new = i;
	      str[i].length = 1;
	    }

	  /* initialise the variables */
	  bit_pos = 0;
	  data_len = pack_getc(f);
	  data_pos = 0;
	  entire = pack_getc(f);
	  data_pos++;
	  string_length = 0;
	  x = image_x;
	  y = image_y;

	  /* starting code */
	  clear_table();
	  get_code();
	  if (code == cc)
	    get_code();
	  get_string(code);
	  output_string();
	  old = code;
	  
	  while (TRUE)
	    {
	      get_code();
	      
	      if (code == cc)
		{
		  /* starting code */
		  clear_table();
		  get_code();
		  get_string(code);
		  output_string();
		  old = code;
		}
	      else if (code == cc + 1)
		  {
		    break;
		  }
		else if (code < empty_string)
		    {
		      get_string(code);
		      output_string();
		      
		      if (bit_overflow == 0)
			{
			  str[empty_string].base = old;
			  str[empty_string].new = string[0];
			  str[empty_string].length = str[old].length + 1;
			  empty_string++;
			  if (empty_string == (1 << curr_bit_size))
			    curr_bit_size++;
			  if (curr_bit_size == 13)
			    {
			      curr_bit_size = 12;
			      bit_overflow = 1;
			    }
			}
		      old = code;
		    }
		  else
		    {
		      get_string(old);
		      string[str[old].length] = string[0];
		      string_length++;
		      
		      if (bit_overflow == 0)
			{
			  str[empty_string].base = old;
			  str[empty_string].new = string[0];
			  str[empty_string].length = str[old].length + 1;
			  empty_string++;
			  if (empty_string == (1 << curr_bit_size))
			    curr_bit_size++;
			  if (curr_bit_size == 13)
			    {
			      curr_bit_size = 12;
			      bit_overflow = 1;
			    }
			}
		      output_string();
		      old = code;
		    }
	    }
	  break;
	case 0x21: /* extension introducer */
	  i = pack_getc(f);
	  if (i == 0xF9) /* graphic control extension */
	    {
	      pack_fseek(f, 1);	/* skip size (it's 4) */
	      i = pack_getc(f);
	      if (i & 1) /* is transparency enabled ? */
		{
		  pack_fseek(f, 2);
		  pack_getc(f); /* transparent colour */
		}
	      else
		pack_fseek(f, 3);
	    }
	  i = pack_getc(f);
	  while (i) /* skip data sub-blocks */
	    {
	      pack_fseek(f, i);
	      i = pack_getc(f);
	    }
	  break;
	case 0x3B: /* trailer - end of data */
	  pack_fclose(f);
	  /* convert to correct colour depth */
	  dest_depth = _color_load_depth(8);
	  if (dest_depth != 8)
	    {
	      bmp2 = create_bitmap_ex(dest_depth, bmp->w, bmp->h);
	      if (!bmp2)
		{
		  destroy_bitmap(bmp);
		  return NULL;
		}
	      select_palette(pal);
	      blit(bmp, bmp2, 0, 0, 0, 0, bmp->w, bmp->h);
	      unselect_palette();
	      destroy_bitmap(bmp);
	      bmp = bmp2;
	    }
	  return bmp;
	}
    }
  while (TRUE);
  /* this is never executed but DJGPP complains if you leave it out */
  return NULL;
}
/*---------------------------------------------------------------------------*/
void main_loops()
{
  do
    {
      ptkeyparsetbl = tkeyparsetbl_see;
      key_scan();
    }
  while ((lastkey != K_ESC) && (!esc_hit));
  esc_hit = 1;
}
/*---------------------------------------------------------------------------*/
void output_string()
{
  for (i = 0; i < string_length; i++)
    {
      putpixel(bmp, x, y, string[i]);
      x++;
      if (x >= image_x + image_w)
	{
	  x = image_x;
	  y += interlace;
	  if (interlace)
	    {
	      if (y >= image_y + image_h)
		{
		  if (interlace == 8 && (y - image_y) % 8 == 0)
		    {
		      interlace = 8;
		      y = image_y + 4;
		    }
		  else
		    if (interlace == 8 && (y - image_y) % 8 == 4)
		      {
			interlace = 4;
			y = image_y + 2;
		      }
		    else
		      if (interlace == 4)
			{
			  interlace = 2;
			  y = image_y + 1;
			}
		}
	    }
	}
    }
}
/*---------------------------------------------------------------------------*/
void scan_vga()
{
  int vga, w, h, finish = FALSE;

  vga = get_config_int("[graphics]", "gfx_card", 3);
  if (pbmp->w <= 320 && pbmp->h <= 200)
    {
      vga = GFX_VGA;
      w = 320;
      h = 200;
    }
  else if (pbmp->w <= 640 && pbmp->h <= 480)
    {
      w = 640;
      h = 480;
    }
  else if (pbmp->w <= 800 && pbmp->h <= 600)
    {
      w = 800;
      h = 600;
    }
  else
    {
      w = 1024;
      h = 768;
    }
  do
    {
      if (set_gfx_mode(vga, w, h, 0, 0))
	{
	  if (w == 1024)
	    {
	      w = 800;
	      h = 600;
	    }
	  else
	    if (w == 800)
	      {
		w = 600;
		h = 480;
	      }
	    else
	      if (w == 640)
		{
		  vga = GFX_VGA;
		  w = 320;
		  h = 200;
		}
	      else exit(1);
	}
      else finish = TRUE;
    }
  while (!finish);
}
/*---------------------------------------------------------------------------*/
void see_fli()
{
  int loop = TRUE;
  int c, ret;
  int vga, w, h;

  vga = GFX_VGA;
  w = 320;
  h = 200;
  allegro_init();
  install_keyboard();
  install_timer();
  if (set_gfx_mode(vga, w, h, 0, 0) != 0)
    {
      allegro_exit();
      printf("Cannot find/load %s\n", retvalsee);
      exit(1);
    }
  ret = play_fli(retvalsee, screen, loop, key_checker);
  allegro_exit();
  if (ret < 0)
    printf("Cannot find/load %s\n", retvalsee);
  exit(0);
}
/*---------------------------------------------------------------------------*/
void see_gif() 
{
  pbmp = load_gif(retvalsee, pal);
  if (!pbmp) 
    {
      printf("Cannot find/load %s\n", retvalsee);
      exit(1);
    }  
  allegro_init();
  install_timer();
  scan_vga();
  set_pallete(pal);
  blit(pbmp, screen, 0, 0, 0, 0, pbmp->w, pbmp->h);
}
/*---------------------------------------------------------------------------*/
void see_jpg() 
{
  pbmp = (BITMAP *) load_jpeg(retvalsee, pal);
  if (!pbmp) 
    {
      printf("Cannot find/load %s\n", retvalsee);
      exit(1);
    }  
  allegro_init();
  install_timer();
  scan_vga();
  set_pallete(pal);
  blit(pbmp, screen, 0, 0, (SCREEN_W - pbmp->w)/2,
       (SCREEN_H - pbmp->h)/2, pbmp->w, pbmp->h);
}
/*---------------------------------------------------------------------------*/
void see_xxx() 
{
  pbmp = (BITMAP *) load_bitmap(retvalsee, pal);
  if (!pbmp)
    {
      printf("Cannot find/load %s\n", retvalsee);
      exit(1);
    }  
  allegro_init();
  install_timer();
  scan_vga();
  set_pallete(pal);
  blit(pbmp, screen, 0, 0, (SCREEN_W - pbmp->w)/2,
       (SCREEN_H - pbmp->h)/2, pbmp->w, pbmp->h);
}
/*---------------------------------------------------------------------------*/
/* writes apal in a .map-file in 0..255 format */
void writemap(char s[256], PALLETE apal)
{
  int i = 0;
  FILE *fp;

  fp = fopen(s, "wt");
  for (i = 0; i < 256; i++)
    {
      fprintf(fp, "%i ", apal[i].r * 4);
      fprintf(fp, "%i ", apal[i].g * 4);
      fprintf(fp, "%i\n", apal[i].b * 4);
    }
  fclose(fp);
}
