/* scale.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "effects.h"
/*---------------------------------------------------------------------------*/
#define SCALE_DELAY_MIN 0
#define SCALE_DELAY_MAX 3000
#define SCALE_DELAY_STEP 100

#define SCALE_DIRECTION_MIN 0
#define SCALE_DIRECTION_MAX 1
#define SCALE_DIRECTION_STEP 1

#define SCALE_MAX_MIN 0.02
#define SCALE_MAX_MAX 5
#define SCALE_MAX_STEP 0.01

#define SCALE_MIN_MIN 0.01
#define SCALE_MIN_MAX 4
#define SCALE_MIN_STEP 0.01

#define SCALE_SORT_MIN 1
#define SCALE_SORT_MAX 4
#define SCALE_SORT_STEP 1

#define SCALE_STEP_MIN 0.01
#define SCALE_STEP_MAX 2
#define SCALE_STEP_STEP 0.01

#define SCALE_X_MIN 0
#define SCALE_X_MAX SCREEN_W
#define SCALE_X_STEP 10

#define SCALE_Y_MIN 0
#define SCALE_Y_MAX SCREEN_H
#define SCALE_Y_STEP 10
/*---------------------------------------------------------------------------*/
/* variables */
float scalef;

long scale_delay;
int scale_direction;
float scale_max;
float scale_min;
int scale_sort;
float scale_step;
int scale_x;
int scale_y;

static tkeyparse
  see_f8_0 = {K_0, keysee_f8_0}, /* scale.c specific */
  see_f8_1 = {K_1, keysee_f8_1},
  see_f8_2 = {K_2, keysee_f8_2},
  see_f8_3 = {K_3, keysee_f8_3},
  see_f8_4 = {K_4, keysee_f8_4},
  see_f8_5 = {K_5, keysee_f8_5},
  see_f8_6 = {K_6, keysee_f8_6},
  see_f8_7 = {K_7, keysee_f8_7},
  see_f8_8 = {K_8, keysee_f8_8},
  see_f8_9 = {K_9, keysee_f8_9},
  see_f8_d = {K_d, keysee_f8_d},
  see_f8_D = {K_D, keysee_f8_D},
  see_f8_r = {K_r, keysee_f8_r},
  see_f8_R = {K_R, keysee_f8_R},
  see_f8_m = {K_m, keysee_f8_m},
  see_f8_M = {K_M, keysee_f8_M},
  see_f8_n = {K_n, keysee_f8_n},
  see_f8_N = {K_N, keysee_f8_N},
  see_f8_s = {K_s, keysee_f8_s},
  see_f8_S = {K_S, keysee_f8_S},
  see_f8_t = {K_t, keysee_f8_t},
  see_f8_T = {K_T, keysee_f8_T},
  see_f8_x = {K_x, keysee_f8_x},
  see_f8_X = {K_X, keysee_f8_X},
  see_f8_y = {K_y, keysee_f8_y},
  see_f8_Y = {K_Y, keysee_f8_Y}
;

tkeyparse* tkeyparsetbl_scale[] =
{
  TKEYPARSETBL_SEE, /* see.c specific */  
  &see_f8_0, /* scale.c specific */
  &see_f8_1,
  &see_f8_2,
  &see_f8_3,
  &see_f8_4,
  &see_f8_5,
  &see_f8_6,
  &see_f8_7,
  &see_f8_8,
  &see_f8_9,
  &see_f8_d,
  &see_f8_D,
  &see_f8_r,
  &see_f8_R,
  &see_f8_m,
  &see_f8_M,
  &see_f8_n,
  &see_f8_N,
  &see_f8_s,
  &see_f8_S,
  &see_f8_t,
  &see_f8_T,
  &see_f8_x,
  &see_f8_X,
  &see_f8_y,
  &see_f8_Y,
  NULL
};
/*---------------------------------------------------------------------------*/
void keysee_f8_0()
{
  keysee_f8_gen("f8_0");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_1()
{
  keysee_f8_gen("f8_1");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_2()
{
  keysee_f8_gen("f8_2");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_3()
{
  keysee_f8_gen("f8_3");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_4()
{
  keysee_f8_gen("f8_4");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_5()
{
  keysee_f8_gen("f8_5");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_6()
{
  keysee_f8_gen("f8_6");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_7()
{
  keysee_f8_gen("f8_7");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_8()
{
  keysee_f8_gen("f8_8");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_9()
{
  keysee_f8_gen("f8_9");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_D()
{
  paralong(&scale_delay, SCALE_DELAY_MIN, SCALE_DELAY_MAX, SCALE_DELAY_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_M()
{
  parafloat(&scale_max, SCALE_MAX_MIN, SCALE_MAX_MAX, SCALE_MAX_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_N()
{
  parafloat(&scale_min, SCALE_MIN_MIN, SCALE_MIN_MAX, SCALE_MIN_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_R()
{
  /* scalef */
  paraint(&scale_direction, SCALE_DIRECTION_MIN, SCALE_DIRECTION_MAX, SCALE_DIRECTION_STEP, 1,1);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_S()
{
  paraint(&scale_sort, SCALE_SORT_MIN, SCALE_SORT_MAX, SCALE_SORT_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_T()
{
  parafloat(&scale_step, SCALE_STEP_MIN, SCALE_STEP_MAX, SCALE_STEP_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_X()
{
  paraint(&scale_x, SCALE_X_MIN, SCALE_X_MAX, SCALE_X_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_Y()
{
  paraint(&scale_y, SCALE_Y_MIN, SCALE_Y_MAX, SCALE_Y_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_d()
{
  paralong(&scale_delay, SCALE_DELAY_MIN, SCALE_DELAY_MAX, SCALE_DELAY_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_gen(char s[256])
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", s, &pi);
  scale_delay = atoi(tps[1]);
  scale_direction = atoi(tps[2]);
  scale_max = atof(tps[3]);
  scale_min = atof(tps[4]);
  if (scale_direction == 0)
  {
    scalef = scale_min;
  }
  else if (scale_direction == 1)
  {
    scalef = scale_max;
  }
  scale_sort = atoi(tps[5]);
  scale_step = atof(tps[6]);
  scale_x = atoi(tps[7]);
  scale_y = atoi(tps[8]);
  scale();
}
/*---------------------------------------------------------------------------*/
void keysee_f8_m()
{
  parafloat(&scale_max, SCALE_MAX_MIN, SCALE_MAX_MAX, SCALE_MAX_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_n()
{
  parafloat(&scale_min, SCALE_MIN_MIN, SCALE_MIN_MAX, SCALE_MIN_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_r()
{
  /* scalef */
  paraint(&scale_direction, SCALE_DIRECTION_MIN, SCALE_DIRECTION_MAX, SCALE_DIRECTION_STEP, 0,1);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_s()
{
  paraint(&scale_sort, SCALE_SORT_MIN, SCALE_SORT_MAX, SCALE_SORT_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_t()
{
  parafloat(&scale_step, SCALE_STEP_MIN, SCALE_STEP_MAX, SCALE_STEP_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_x()
{
  paraint(&scale_x, SCALE_X_MIN, SCALE_X_MAX, SCALE_X_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_y()
{
  paraint(&scale_y, SCALE_Y_MIN, SCALE_Y_MAX, SCALE_Y_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void scale()
{
  lastkey = K_d;
  do
    {
      if (scale_sort == 1)
	{
	  stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, scale_x, scale_y,
		       pbmp->w * scalef, pbmp->h * scalef);
	}
      else if (scale_sort == 2)
	{
	  stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, scale_x, scale_y,
		       pbmp->w * scalef, pbmp->h * scalef);
	  stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, scale_x + SCREEN_W/2, scale_y,
		       pbmp->w * scalef, pbmp->h * scalef);
	}
      else if (scale_sort == 3)
	{
	  stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, scale_x, scale_y,
		       pbmp->w * scalef, pbmp->h * scalef);
	  stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, scale_x + SCREEN_W/2, scale_y,
		       pbmp->w * scalef, pbmp->h * scalef);
	  stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, scale_x + SCREEN_W/2,
		       scale_y + SCREEN_H/2, pbmp->w * scalef, pbmp->h * scalef);
	}
      else if (scale_sort == 4)
	{
	  stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, scale_x, scale_y,
		       pbmp->w * scalef, pbmp->h * scalef);
	  stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, scale_x + SCREEN_W/2, scale_y,
		       pbmp->w * scalef, pbmp->h * scalef);
	  stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, scale_x + SCREEN_W/2,
		       scale_y + SCREEN_H/2, pbmp->w * scalef, pbmp->h * scalef);
	  stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, scale_x, scale_y + SCREEN_H/2,
		       pbmp->w * scalef, pbmp->h * scalef);
	}
      rest(scale_delay);
      if (scale_direction == 0)
	{
	  scalef += scale_step;
	  if (scalef > scale_max)
	    {
	      scalef = scale_min;
	    }
	}
      else if (scale_direction == 1)
	{
	  scalef -= scale_step;
	  if (scalef < scale_min)
	    {
	      scalef = scale_max;
	    }
	}
      ptkeyparsetbl = tkeyparsetbl_scale;
      key_scan();
    }
  while ((lastkey == K_d) || (lastkey == K_D) ||
	 (lastkey == K_r) || (lastkey == K_R) ||
	 (lastkey == K_m) || (lastkey == K_M) ||
	 (lastkey == K_n) || (lastkey == K_N) ||
	 (lastkey == K_s) || (lastkey == K_S) ||
	 (lastkey == K_t) || (lastkey == K_T) ||
	 (lastkey == K_x) || (lastkey == K_X) ||
	 (lastkey == K_y) || (lastkey == K_Y));
  scale_save();
  if (lastkey == K_ESC)
    {
      esc_hit = 1;
    }
}
/*---------------------------------------------------------------------------*/
void scale_save()
{
  blit(screen, pbmp, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}
