/* move.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "effects.h"
/*---------------------------------------------------------------------------*/
/* #define */
#define MOVE_DELAY_MIN 1
#define MOVE_DELAY_MAX 64
#define MOVE_DELAY_STEP 1

#define MOVE_X_MIN 0
#define MOVE_X_MAX SCREEN_W
#define MOVE_X_STEP 10

#define MOVE_Y_MIN 0
#define MOVE_Y_MAX SCREEN_H
#define MOVE_Y_STEP 10
/*---------------------------------------------------------------------------*/
/* variables */
int node_count, number;
fixed curviness;
BITMAP *pbmpe, *page1, *page2, *active_page;
NODE nodes[MOVES_MAXNODES];
planet *space;

long move_delay;
int move_x;
int move_y;

static tkeyparse
  see_f5_0 = {K_0, keysee_f5_0}, /* move.c specific */
  see_f5_1 = {K_1, keysee_f5_1},
  see_f5_2 = {K_2, keysee_f5_2},
  see_f5_3 = {K_3, keysee_f5_3},
  see_f5_4 = {K_4, keysee_f5_4},
  see_f5_5 = {K_5, keysee_f5_5},
  see_f5_6 = {K_6, keysee_f5_6},
  see_f5_7 = {K_7, keysee_f5_7},
  see_f5_8 = {K_8, keysee_f5_8},
  see_f5_9 = {K_9, keysee_f5_9},
  see_f5_d = {K_d, keysee_f5_d},
  see_f5_D = {K_D, keysee_f5_D},
  see_f5_x = {K_x, keysee_f5_x},
  see_f5_X = {K_X, keysee_f5_X},
  see_f5_y = {K_y, keysee_f5_y},
  see_f5_Y = {K_Y, keysee_f5_Y}
;

tkeyparse* tkeyparsetbl_move[] =
{
  TKEYPARSETBL_SEE, /* see.c specific */
  &see_f5_0, /* move.c specific */
  &see_f5_1,
  &see_f5_2,
  &see_f5_3,
  &see_f5_4,
  &see_f5_5,
  &see_f5_6,
  &see_f5_7,
  &see_f5_8,
  &see_f5_9,
  &see_f5_d,
  &see_f5_D,
  &see_f5_x,
  &see_f5_X,
  &see_f5_y,
  &see_f5_Y,
  NULL
};
/*---------------------------------------------------------------------------*/
/* prototypes */
fixed node_dist(NODE n1, NODE n2);
NODE dummy_node(NODE node, NODE prev);
void get_control_points(NODE n1, NODE n2, int points[8]);
/*---------------------------------------------------------------------------*/
fixed node_dist(NODE n1, NODE n2)
{
  fixed dx = itofix(n1.x - n2.x) / move_x;
  fixed dy = itofix(n1.y - n2.y) / move_y;
  return fsqrt(fmul(dx, dx) + fmul(dy, dy)) * move_x;
}
/*---------------------------------------------------------------------------*/
NODE dummy_node(NODE node, NODE prev)
{
  NODE n;

  n.x = node.x - (prev.x - node.x) / 8;
  n.y = node.y - (prev.y - node.y) / 8;
  return n;
}
/*---------------------------------------------------------------------------*/
void calc_tangents()
{
  int i;

  nodes[0] = dummy_node(nodes[1], nodes[2]);
  nodes[node_count] = dummy_node(nodes[node_count - 1], nodes[node_count - 2]);
  node_count++;
  for (i = 1; i < node_count - 1; i++)
    {
      nodes[i].tangent = fatan2(itofix(nodes[i + 1].y - nodes[i - 1].y),
				itofix(nodes[i + 1].x - nodes[i - 1].x));
    }
}
/*---------------------------------------------------------------------------*/
void get_control_points(NODE n1, NODE n2, int points[8])
{
  fixed dist = fmul(node_dist(n1, n2), curviness);

  points[0] = n1.x;
  points[1] = n1.y;
  points[2] = n1.x + fixtoi(fmul(fcos(n1.tangent), dist));
  points[3] = n1.y + fixtoi(fmul(fsin(n1.tangent), dist));
  points[4] = n2.x - fixtoi(fmul(fcos(n2.tangent), dist));
  points[5] = n2.y - fixtoi(fmul(fsin(n2.tangent), dist));
  points[6] = n2.x;
  points[7] = n2.y;
}
/*---------------------------------------------------------------------------*/
void grav()
{
  int i, j, x, y;
  float xforce, yforce;
  float F, G, M, m, r; /* F = G * M * m / (r^2) */
  float angle;

  for (i = 0; i < number; i++)
    {
      space[i].x = rand() % 101 - 50;
      space[i].y = rand() % 101 - 50;
      space[i].xdir = 0; /* rand() % 11 - 5; */
      space[i].ydir = 0; /* rand() % 11 - 5; */
    }
  lastkey = K_d;
  clear(screen);
  do
    {
      G = 0.4;
      for (i = 0; i < number; i++)
 	{
	  xforce = 0;
	  yforce = 0;
	  F = 0;
	  M = space[i].mass;
	  for (j = 0; j < number; j++)
 	    {
	      if (j != i) /* don't process itself */
		{
		  if (sqrt((space[i].x - space[j].x) * (space[i].x - space[j].x)
			   + (space[i].y - space[j].y) * (space[i].y - space[j].y))
		      > (space[i].size + space[j].size) / 2) /* not touching */
 		    {
		      m = space[j].mass;
		      r = sqrt((space[j].x - space[i].x) * (space[j].x - space[i].x)
			       + (space[j].y - space[i].y) * (space[j].y - space[i].y) );
		      F = G * M * m / r / r;
		      angle = atan2((space[j].y - space[i].y), (space[j].x - space[i].x));
		      xforce += F * cos(angle);
		      yforce += F * sin(angle);
 		    }
		}
	    }
	  /* F = m * a, accel = Force / mass */
	  space[i].xdir += xforce / (float)space[i].mass;
	  space[i].ydir += yforce / (float)space[i].mass;
 	}
      pbmpe = create_bitmap(320, 200);
      clear(pbmpe);
      vsync();
      for (i = 0; i < number; i++)
 	{
	  x = (int)space[i].x + 160; /* erase */
	  y = (int)space[i].y + 100;
      	  stretch_blit(pbmpe, screen, 0, 0, pbmp->w, pbmp->h, x, y, space[i].size*10, space[i].size*10);
	  space[i].x += space[i].xdir; /* move */
	  space[i].y += space[i].ydir;
	  x = (int)space[i].x + 160; /* draw */
	  y = (int)space[i].y + 100;
	  stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, x, y, space[i].size*10, space[i].size*10);
	}
      rest(move_delay);
      ptkeyparsetbl = tkeyparsetbl_move;
      destroy_bitmap(pbmpe);
      key_scan();
    }
  while ((lastkey == K_d) || (lastkey == K_D));
  if (lastkey == K_ESC)
    {
      esc_hit = 1;
    }
}
/*---------------------------------------------------------------------------*/
void keysee_f5_0()
{
  keysee_f5_gen("f5_0");
}
/*---------------------------------------------------------------------------*/
void keysee_f5_1()
{
  keysee_f5_gen("f5_1");
}
/*---------------------------------------------------------------------------*/
void keysee_f5_2()
{
  keysee_f5_gen("f5_2");
}
/*---------------------------------------------------------------------------*/
void keysee_f5_3()
{
  keysee_f5_gen("f5_3");
}
/*---------------------------------------------------------------------------*/
void keysee_f5_4()
{
  keysee_f5_gen("f5_4");
}
/*---------------------------------------------------------------------------*/
void keysee_f5_5()
{
  keysee_f5_gen("f5_5");
}
/*---------------------------------------------------------------------------*/
void keysee_f5_6()
{
  keysee_f5_gen("f5_6");
}
/*---------------------------------------------------------------------------*/
void keysee_f5_7()
{
  keysee_f5_gen("f5_7");
}
/*---------------------------------------------------------------------------*/
void keysee_f5_8()
{
  keysee_f5_gen("f5_8");
}
/*---------------------------------------------------------------------------*/
void keysee_f5_9()
{
  keysee_f5_gen("f5_9");
}
/*---------------------------------------------------------------------------*/
void keysee_f5_D()
{
  paralong(&move_delay, MOVE_DELAY_MIN, MOVE_DELAY_MAX, MOVE_DELAY_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f5_X()
{
  paraint(&move_x, MOVE_X_MIN, MOVE_X_MAX, MOVE_X_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f5_Y()
{
  paraint(&move_y, MOVE_Y_MIN, MOVE_Y_MAX, MOVE_Y_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f5_d()
{
  paralong(&move_delay, MOVE_DELAY_MIN, MOVE_DELAY_MAX, MOVE_DELAY_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f5_gen(char s[256])
{
  int i, j;
  char s1[256];
  FILE *fp;

  fp = fopen(confname, "rt");
  if (!fp)
    {
      fp = fopen(DEFNAME, "rt");
    }
  rewind(fp);
  setfilept(fp, s, 0);
  fscanf(fp, "%s", s1); /* skip = */
  fscanf(fp, "%s", s1); /* 1st parameter */
  if (!strcmp(s1, "moves"))
    {
      j = 1;
      fscanf(fp, "%s", s1); /* read width in pixels */
      move_x = atoi(s1);
      fscanf(fp, "%s", s1); /* read heigth in pixels */
      move_y = atoi(s1);
      /* node_count : number of (x,y)-points that follow */
      fscanf(fp, "%s", s1);
      node_count = atoi(s1);
      for (i = 1; i <= node_count; i++)
	{
	  fscanf(fp, "%s", s1); /* read x */
	  nodes[i].x = atoi(s1);
	  fscanf(fp, "%s", s1); /* read y */
	  nodes[i].y = atoi(s1);
          j += 2;
	}
      node_count++;
      moves();
    }
  else if (!strcmp(s1, "grav"))
    {
      fscanf(fp, "%i", &number); /* read number of planets */
      space = (planet *) malloc(sizeof(planet) * number);
      for (i = 0; i < number; i++) /* for each planet */
	{
	  fscanf(fp, "%f", &space[i].x); /* read x */
	  fscanf(fp, "%f", &space[i].y); /* read y */
	  fscanf(fp, "%f", &space[i].xdir); /* read x velocity */
	  fscanf(fp, "%f", &space[i].ydir); /* read y velocity */
	  fscanf(fp, "%i", &space[i].size); /* read radius in pixels */
	  fscanf(fp, "%i", &space[i].mass); /* read mass used in calculations */
	  fscanf(fp, "%i", &space[i].color); /* read screen color, N/A */
	}
      grav();
    }
}
/*---------------------------------------------------------------------------*/
void keysee_f5_x()
{
  paraint(&move_x, MOVE_X_MIN, MOVE_X_MAX, MOVE_X_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f5_y()
{
  paraint(&move_y, MOVE_Y_MIN, MOVE_Y_MAX, MOVE_Y_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void moves()
{
  lastkey = K_d;

  set_gfx_mode(GFX_MODEX, 320, 200, 0, 400);
  set_pallete(pal);
  curviness = ftofix(0.25);
  calc_tangents();
  do
    {
      pbmpe = create_bitmap(320, 200);
      clear(pbmpe);
      page1 = create_sub_bitmap(screen, 0, 0, SCREEN_W, SCREEN_H);
      page2 = create_sub_bitmap(screen, 0, SCREEN_H, SCREEN_W, SCREEN_H);
      active_page = page2;
      walk();
      clear(page1);
      clear(page2);
      destroy_bitmap(pbmpe);
      destroy_bitmap(page1);
      destroy_bitmap(page2);
      destroy_bitmap(active_page);
      rest(move_delay);
      ptkeyparsetbl = tkeyparsetbl_move;
      key_scan();
    }
  while ((lastkey == K_d) || (lastkey == K_D) ||
	 (lastkey == K_x) || (lastkey == K_X) ||
	 (lastkey == K_y) || (lastkey == K_Y));
  if (lastkey == K_ESC)
    {
      esc_hit = 1;
    }
  set_gfx_mode(GFX_MODEX, 320, 200, 0, 0);
  set_pallete(pal);
}
/*---------------------------------------------------------------------------*/
/* moves a sprite along the spline path */
void walk()
{
  int points[8];
  int x[MOVES_MAXPOINTS], y[MOVES_MAXPOINTS];
  int i, n, npoints, ox, oy;

  clear(screen);
  ox = -16;
  oy = -16;
  for (n = 1; !(kbhit()); n++) 
    {
      if (n >= (node_count - 2))
	{
	  n = 1;
	}
      npoints = (fixtoi(node_dist(nodes[n], nodes[n + 1])) + 3) / 4;
      if (npoints < 1)
	{
	  npoints = 1;
	}
      else if (npoints > MOVES_MAXPOINTS)
	{
	  npoints = MOVES_MAXPOINTS;
	}
      get_control_points(nodes[n], nodes[n + 1], points);
      calc_spline(points, npoints, x, y);
      for (i = 1; i < npoints; i++) 
	{
	  clear(active_page);
	  stretch_blit(pbmp, active_page, 0, 0, pbmp->w, pbmp->h, x[i], y[i], move_x, move_y);
	  if (active_page == page1)
	    {
	      scroll_screen(0, 0);
	      active_page = page2;
	    }
	  else
	    {
	      scroll_screen(0, SCREEN_H);
	      active_page = page1;
	    }
	  ox = x[i];
	  oy = y[i];
 	}
    }
  scroll_screen(0, 0);
}
