/* modsub.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
/*---------------------------------------------------------------------------*/
/* global variables : use */
/* declare external loaders */
extern loader load_mod;
extern loader load_mtm;
extern loader load_s3m;
extern loader load_xm;
/* driver variables */
extern ushr md_device;
extern ushr md_mixfreq;
extern ushr md_dmabufsize;
extern ushr md_mode;
/* external driver */
extern driver drv_sb; /* soundblaster DSP driver */

extern int mp_loop;
extern uchr mp_volume;
extern ushr numsamples;
extern struct sample samples[MAX_INSTRUMENTS];
/*---------------------------------------------------------------------------*/
/* variables */
char modext[5], modfn[256];
uint wav_sample_rate = 16574; /* .wav sample rate (middle C) */
FILE *fpmod, *fpwav;
/*---------------------------------------------------------------------------*/
void modsub(char *path)
{
  char dir[256], drive[256], ext[256], name[256], *prefix, s[256], *suffix;
  int i;
  unimod *mf;

  numsamples = 0;
  strcpy(modfn, path);
  suffix = ".wav";
  fnsplit(modfn, drive, dir, name, modext);
  strlwr(modext);
  i = 0;
  while ((i < 6) && (name[i] != '.'))
    {
      s[i] = name[i];
      i++;
    }
  s[i] = '\0';
  prefix = s;

  samples_init();
  md_device = 0; /* device == autodetect */
  md_dmabufsize = 8000; /* dma buffer size */
  md_mixfreq = 22000; /* mixing frequency */
  md_mode = DMODE_16BITS | DMODE_STEREO | DMODE_INTERP; /* mixing mode */
  mp_loop = 0; /* don't loop */
  mp_volume = 100; /* maximal volume */
  ml_registerloader(&load_mod);
  ml_registerloader(&load_mtm);
  ml_registerloader(&load_s3m);
  ml_registerloader(&load_xm);
  md_registerdriver(&drv_sb);
  if (!md_initsub())
    {
      mod_error();
      printf("(main) !md_init()\n");
      exit(1);
    }
  if ((fpmod = fopen(modfn, "rb")) == NULL)
    {
      mod_error();
      printf("(main) (fpmod = fopen(modfn, \"rb\")) == NULL\n");
      exit(1);
    }
  mf = ml_loadfp(fpmod);
  if (mf == NULL)
    {
      mod_error();
      printf("(main) mf == NULL\n");
      fclose(fpmod);
      exit(1);
    }

  assign_filenames(prefix, suffix);
  dump_samples(fpmod);

  fclose(fpmod);
  ml_free(mf);
}
/*---------------------------------------------------------------------------*/
/* fpwav = wav_write(&samples[i], wav_sample_rate) */
FILE* wav_write(sample *sample_info, uint sample_rate)
{
  uint data_size, wave_size;
  wavformat fmt;
  FILE* fp;

  if (sample_info->filename == NULL)
    {
      printf("error (%s):\n", modfn);
      printf("(wav_write) sample_info->filename == NULL\n");
      exit(1);
    }
  if ((fp = fopen(sample_info->filename, "wb")) == NULL)
    {
      printf("error (%s):\n", modfn);
      printf("(wav_write) fp = fopen(sample_info->filename, \"wb\")) == NULL\n");
      exit(1);
    }
  if (!strcmp(modext, ".mod"))
    {
      data_size = (ulng)sample_info->size - SAMPLE_IGNORE_BYTES; /* size in bytes */
    }
  else
    {
      data_size = (ulng)sample_info->size; /* size in bytes */
    }
  wave_size = data_size + 36; /* "RIFF" + "WAVE" + "fmt " + 10 00 00 00 + "data" + size = 36*/

  fputc_uint_l(CC4_RIFF, fp); /* RIFF */
  fputc_uint_l(wave_size, fp); /* size */
  fputc_uint_l(CC4_WAVE, fp); /* WAVE */
  fmt.wformattag = 1;
  fmt.nchannels = 1;
  fmt.nsamplespersec = sample_rate;
  if (sample_info->type == 1)
    {
      fmt.wbitspersample = 16; /* only applicable for some .XM-samples */
    }
  else
    {
      fmt.wbitspersample = 8;
    }
  fmt.nblockalign = fmt.nchannels * ((fmt.wbitspersample + 7) / 8 );
  fmt.navgbytespersec = fmt.nblockalign * sample_rate;
  fputc_uint_l(CC4_FMT, fp); /* "fmt " */
  fputc_uint_l(16, fp); /* 16 */
  fputc_ushr_l(fmt.wformattag, fp); /* 1 */
  fputc_ushr_l(fmt.nchannels, fp); /* 1 */
  fputc_uint_l(fmt.nsamplespersec, fp); /* 16574 */
  fputc_uint_l(fmt.navgbytespersec, fp); /* 16574 */
  fputc_ushr_l(fmt.nblockalign, fp); /* 1, 2 */
  fputc_ushr_l(fmt.wbitspersample, fp); /* 8, 16 */
  fputc_uint_l(CC4_DATA, fp); /* data */
  fputc_uint_l(data_size, fp); /* size */

  return fp;
}
/*---------------------------------------------------------------------------*/
void assign_filenames(char *prefix, char *suffix)
{
  int i;
  char s[256];

  for (i = 0; i < MAX_INSTRUMENTS; i++)
    {
      if (samples[i].size != 0)
	{
	  sprintf(s, "%s%s%d%s", DATAPATH, prefix ? prefix : "inst", i, suffix ? suffix : "");
	  if ((samples[i].filename = malloc(strlen(s) + 1)) == NULL)
	    {
	      printf("error (%s):\n", modfn);
	      printf("(assign_filenames) (samples[i].filename = malloc(strlen(s) + 1)) == NULL\n");
	      exit(1);
	    }
	  strcpy(samples[i].filename, s);
	}
    }
}
/*---------------------------------------------------------------------------*/
void dump_samples(FILE *fp)
{
  char *sample_buff;
  uchr uc;
  int i, len, off, sample_len;
  uint nbytes, ui32;

  sample_buff = malloc(SAMPLE_BUFFER_SIZE); /* 4096 */
  if (sample_buff == NULL)
    {
      printf("error (%s):\n", modfn);
      printf("(dump_samples) sample_buff == NULL\n");
      exit(1);
    }
  /* now seek to these places and read the samples */
  for (i = 0; i < MAX_INSTRUMENTS; i++)
  {
    if (samples[i].size != 0)
      {
	if (fseek(fp, samples[i].offset, SEEK_SET) != 0)
	  {
	    printf("error (%s):\n", modfn);
	    printf("(dump_samples) fseek(fp, samples[i].offset, SEEK_SET) != 0\n");
	    exit(1);
	  }
	if (!strcmp(modext, ".mod"))
	  {
	    len = sample_len = (int) samples[i].size - SAMPLE_IGNORE_BYTES;
	  }
	else
	  {
	    len = sample_len = (int) samples[i].size;
	  }
	if (sample_len > 0)
	  {
	    fpwav = wav_write(&samples[i], wav_sample_rate);
	  }
	while (len > 0)
	  {
	    nbytes = (len > SAMPLE_BUFFER_SIZE) ? SAMPLE_BUFFER_SIZE : len;
	    if (fread(sample_buff, sizeof(signed char), nbytes, fp) != nbytes)
	      {
		printf("error (%s):\n", modfn);
		printf("(dump_samples) fread(sample_buff, sizeof(signed char), nbytes, fp) != nbytes\n");
		printf("nbytes = %i\n", nbytes);
		printf("----------------------\n");
		printf("%i\n", samples[i].type);
		printf("%i\n", samples[i].size);
		printf("%U\n", samples[i].offset);
		printf("%s\n", samples[i].filename);
		printf("----------------------\n");
		exit(1);
	      }
	    if (samples[i].type == 0) /* 8-bits */
	      {
		for (ui32 = 0; ui32 < nbytes; ui32++)
		  {
		    if ((!strcmp(modext, ".s3m")) ||
			(!strcmp(modext, ".mtm")))
		      {
			uc = sample_buff[ui32]; /* allready in unsigned format */
		      }
		    else
		      {
			uc = S_TO_U(sample_buff[ui32]); /* unsigned format */
		      }
		    if (putc(uc, fpwav) == EOF)
		      {
			printf("error (%s):\n", modfn);
			printf("(dump_samples) putc(uc, fpwav) == EOF\n");
			exit(1);
		      }
		  }
	      }
	    else if (samples[i].type == 1) /* 16-bits, only for some .XM samples */
	      {
		uchr uc1, uc2;
		for (ui32 = 0; ui32 < nbytes; ui32 += 2)
		  {
		    uc1 = sample_buff[ui32]; /* unsigned MSB-first format */
		    uc2 = S_TO_U(sample_buff[ui32+1]);
		    if (putc(uc1, fpwav) == EOF)
		      {
			printf("error (%s):\n", modfn);
			printf("(dump_samples) putc(uc2, fpwav) == EOF\n");
			exit(1);
		      }
		    if (putc(uc2, fpwav) == EOF)
		      {
			printf("error (%s):\n", modfn);
			printf("(dump_samples) putc(uc1, fpwav) == EOF\n");
			exit(1);
		      }
		  }
	      }
	    len -= nbytes;
	  }
	if (sample_len > 0)
	  {
	    fclose(fpwav);
	  }
      }
  }
  free(sample_buff);
}
/*---------------------------------------------------------------------------*/
void mod_error()
{
  printf("error in %s\n", modfn);
}
/*---------------------------------------------------------------------------*/
void samples_init()
{
  int i;

  for (i = 0; i < MAX_INSTRUMENTS; i++)
    {
      samples[i].type = 0; /* 8-bits */
      samples[i].size = 0;
      samples[i].offset = 0;
      samples[i].filename = "\0";
    }
}
