/* mloader.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
/*---------------------------------------------------------------------------*/
/* variables */
FILE *modfp;
loader *firstloader = NULL;
unimod of;

ushr finetune[16] =
{
  8363,	8413, 8463, 8529, 8581,	8651, 8723, 8757,
  7895,	7941, 7985, 8046, 8107,	8169, 8232, 8280
};
/*---------------------------------------------------------------------------*/
/* creates a CSTR out of a character buffer of 'len' bytes, but strips any terminating */
/* non-printing characters like 0, spaces etc. */
char *dupstr(uchr *s, ushr len)
{
  char *d = NULL;
  ushr t;

  /* scan for first printing char in buffer [includes high ascii up to 254] */
  while (len)
    {
      if (s[len - 1] > 0x20 && s[len - 1] < 0xFF)
	{
	  break;
	}
      len--;
    }
  if (len)
    {
      /* when the buffer wasn't completely empty, allocate */
      /* a cstring and copy the buffer into that string, except */
      /* for any control-chars */
      if ((d = malloc(len + 1)) != NULL)
	{
	  for (t = 0; t < len; t++)
	    {
	      d[t] = (s[t] < 0x20) ? ' ': s[t];
	    }
	  d[t] = 0;
	}
    }
  return d;
}
/*---------------------------------------------------------------------------*/
int allocinstruments()
{
  ushr t;

  if (!(of.instruments = callocm(of.numins, sizeof(instrument))))
    {
      return 0;
    }
  return 1;
}
/*---------------------------------------------------------------------------*/
int allocpatterns()
{
  int s, t, tracks = 0;

  /* allocate track sequencing array */
  if (!(of.patterns = (ushr *)callocm((ulng)of.numpat * of.numchn, sizeof(ushr))))
    {
      return 0;
    }
  if (!(of.pattrows = (ushr *)callocm(of.numpat, sizeof(ushr))))
    {
      return 0;
    }
  for (t = 0; t < of.numpat; t++)
    {
      of.pattrows[t] = 64;
      for(s = 0; s < of.numchn; s++)
	{
	  of.patterns[(t * of.numchn) + s] = tracks++;
	}
    }
  return 1;
}
/*---------------------------------------------------------------------------*/
int allocsamples(instrument *i)
{
  ushr u, n;

  if (n = i->numsmp)
    {
      if(!(i->samples = callocm(n, sizeof(msample))))
	{
	  return 0;
	}
      for (u = 0; u < n; u++)
	{
	  i->samples[u].panning = 128;
	  i->samples[u].handle = -1;
      }
    }
  return 1;
}
/*---------------------------------------------------------------------------*/
int alloctracks()
{
  if (!(of.tracks = callocm(of.numtrk, sizeof(uchr *))))
    {
      return 0;
    }
  return 1;
}
/*---------------------------------------------------------------------------*/
int ml_loadheader()
{
  int ok = 0;
  loader *l;

  /* Try to find a loader that recognizes the module. */
  for (l = firstloader; l != NULL; l = l->next)
    {
      fseek(modfp, 0, SEEK_SET);
      if (l->test())
	{
	  break;
	}
    }
  if (l == NULL)
    {
      printf("(ml_loadheader) l == NULL\n");
      return 0;
    }
  /* init unitrk routines */
  if (!uniinit())
    {
      printf("(ml_loadheader) !uniinit()\n");
      return 0;
    }
  /* init module loader */
  if (l->init())
    {
      fseek(modfp, 0, SEEK_SET);
      ok = l->load();
    }
  l->cleanup();
  /* free unitrk allocations */
  unicleanup();
  return ok;
}
/*---------------------------------------------------------------------------*/
/* same as calloc, but displays an appropriate message when it failed. */
int ml_loadsamples()
{
  ushr t, u;
  instrument *i;
  msample *s;

  for (t = 0; t < of.numins; t++)
    {
      i = &of.instruments[t];
      for (u = 0; u < i->numsmp; u++)
	{
	  s = &i->samples[u];
	  /* sample has to be loaded ? -> increase */
	  /* number of samples and allocate memory and load sample */
	  if (s->length)
	    {
	      if (s->seekpos)
		{
		  fseek(modfp, s->seekpos, SEEK_SET);
		}
	      /* Call the sample load routine of the driver module. */
	      /* It has to return a 'handle' (>= 0) that identifies the sample. */
	      s->handle = md_sampleload(modfp, s->length, s->loopstart, s->loopend, s->flags);
	      if (s->handle < 0)
		{
		  return 0;
		}
	    }
	}
    }
  return 1;
}
/*---------------------------------------------------------------------------*/
int readcomment(ushr len)
{
  int t;

  if (len)
    {
      if (!(of.comment = (uchr *)mallocm(len + 1)))
	{
	  return 0;
	}
      fread(of.comment, len, 1, modfp);
      of.comment[len] = 0;
      /* strip any control-characters in the comment: */
      for (t = 0; t < len; t++)
	{
	  if (of.comment[t] < 32)
	    {
	      of.comment[t] = ' ';
	    }
	}
    }
  return 1;
}
/*---------------------------------------------------------------------------*/
unimod *ml_loadfn(char *filename)
{
  FILE *fp;
  unimod *mf;

  if ((fp = fopen(filename, "rb")) == NULL)
    {
      mod_error();
      printf("(ml_loadfn) (fp = fopen(filename, \"rb\")) == NULL\n");
      exit(1);
    }
  mf = ml_loadfp(fp);
  fclose(fp);
  return mf;
}
/*---------------------------------------------------------------------------*/
unimod *ml_loadfp(FILE *fp)
{
  int t;
  unimod *mf;

  /* init fileptr, clear errorcode, clear static modfile: */
  modfp = fp;
  memset(&of, 0, sizeof(unimod));
  /* init panning array */
  for (t = 0; t < 32; t++)
    {
      of.panning[t] = ((t + 1) & 2) ? 255 : 0;
    }
  if (!ml_loadheader())
    {
      ml_freeex(&of);
      mod_error();
      printf("(ml_loadfp) !ml_loadheader()\n");
      exit(1);
    }
  if (!ml_loadsamples())
    {
      ml_freeex(&of);
      mod_error();
      printf("(ml_loadfp) !ml_loadsamples()\n");
      exit(1);
    }
  if (!(mf = callocm(1, sizeof(unimod))))
    {
      ml_freeex(&of);
      ml_freeex(&of);
      mod_error();
      printf("(ml_loadfp) !(mf = callocm(1, sizeof(unimod)))\n");
      exit(1);
    }
  /* copy the static unimod contents into the dynamic unimod struct */
  memcpy(mf, &of, sizeof(unimod));
  return mf;
}
/*---------------------------------------------------------------------------*/
void ml_free(unimod *mf)
{
  if (mf != NULL)
    {
      ml_freeex(mf);
      free(mf);
    }
}
/*---------------------------------------------------------------------------*/
void ml_freeex(unimod *mf)
{
  ushr t;

  if (mf->modtype != NULL)
    {
      free(mf->modtype);
    }
  if (mf->patterns != NULL)
    {
      free(mf->patterns);
    }
  if (mf->pattrows != NULL)
    {
      free(mf->pattrows);
    }
  if (mf->tracks != NULL)
    {
      for (t = 0; t < mf->numtrk; t++)
	{
	  if (mf->tracks[t] != NULL)
	    {
	      free(mf->tracks[t]);
	    }
	}
      free(mf->tracks);
    }
  if (mf->instruments != NULL)
    {
      for (t = 0; t < mf->numins; t++)
	{
	  ml_xfreeinstrument(&mf->instruments[t]);
	}
      free(mf->instruments);
    }
  if (mf->songname != NULL)
    {
      free(mf->songname);
    }
  if (mf->comment != NULL)
    {
      free(mf->comment);
    }
}
/*---------------------------------------------------------------------------*/
/* creates a linked list */
/* load_xm -> load_s3m -> load_mtm -> load_mod -> NULL */
void ml_registerloader(loader *ldr)
{
  loader *l;

  if (firstloader == NULL)
    {
      firstloader = ldr;
      ldr->next = NULL;
    }
  else
    {
      ldr->next = firstloader;
      firstloader = ldr;
    }
}
/*---------------------------------------------------------------------------*/
void ml_xfreeinstrument(instrument *i)
{
  ushr t;

  if (i->samples != NULL)
    {
      for (t = 0; t < i->numsmp; t++)
	{
	  if (i->samples[t].handle >= 0)
	    {
	      md_sampleunload(i->samples[t].handle);
	    }
	}
      free(i->samples);
    }
  if(i->insname != NULL)
    {
      free(i->insname);
    }
}
