/* mirq.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
/*---------------------------------------------------------------------------*/
/* Use to enable or disable the specified irq. */
int mirq_onoff(uchr irqno, uchr onoff)
{
  uchr imr = (irqno > 7) ? IMR2 : IMR1;	/* interrupt mask register */
  uchr ocr = (irqno > 7) ? OCR2 : OCR1;	/* ocr */
  uchr msk = 1 << (irqno & 7);	/* interrupt mask */
  uchr eoi = 0x60 | (irqno & 7); /* specific end-of-interrupt */
  int oldstate;

  /* save current setting of this irq */
  oldstate = ((inportb(imr) & msk) == 0);
  if (onoff)
    {
      outportb(imr, inportb(imr) & ~msk);
      outportb(ocr, eoi);
      if (irqno > 7)
	{
	  mirq_onoff(2, 1);
	}
    }
  else
    {
      outportb(imr, inportb(imr) | msk);
    }
  return oldstate;
}
/*---------------------------------------------------------------------------*/
/* DJGPP routines to set and restore interrupt vectors */
/* A tid bit messy if you ask me. -J.F. */
pvi mirq_djsethandlerfunc(uchr irqno, void (*handler) (), int len)
{
  pvi oldvect = (pvi) malloc(sizeof(__dpmi_paddr));
  int vecno = (irqno > 7) ? irqno + 0x68 : irqno + 0x8;
  _go32_dpmi_seginfo wrapper;
  __dpmi_paddr new;

  wrapper.pm_offset = (long int) handler;
  wrapper.pm_selector = _my_cs();
  _go32_dpmi_allocate_iret_wrapper(&wrapper);
  new.offset32 = wrapper.pm_offset;
  new.selector = wrapper.pm_selector;
  __dpmi_get_and_disable_virtual_interrupt_state();
  if (len)
    {
      _go32_dpmi_lock_code(handler, len);
    }
  _go32_dpmi_lock_data(&wrapper, sizeof(_go32_dpmi_seginfo));
  __dpmi_get_protected_mode_interrupt_vector(vecno, oldvect);
  __dpmi_set_protected_mode_interrupt_vector(vecno, &new);
  __dpmi_get_and_enable_virtual_interrupt_state();
  return oldvect;
}
/*---------------------------------------------------------------------------*/
void mirq_djsethandleraddr(uchr irqno, pvi handler)
{
  int vecno = (irqno > 7) ? irqno + 0x68 : irqno + 0x8;
  _go32_dpmi_seginfo wrapper;
  __dpmi_paddr oldhandler;

  __dpmi_get_and_disable_virtual_interrupt_state();
  __dpmi_get_protected_mode_interrupt_vector(vecno, &oldhandler);
  wrapper.pm_offset = oldhandler.offset32;
  wrapper.pm_selector = oldhandler.selector;
  _go32_dpmi_free_iret_wrapper(&wrapper);
  __dpmi_set_protected_mode_interrupt_vector(vecno, handler);
  __dpmi_get_and_enable_virtual_interrupt_state();
  free(handler);
}
/*---------------------------------------------------------------------------*/
/* Clears the specified interrupt request at the interrupt controller. */
void mirq_eoi(uchr irqno)
{
  uchr ocr = (irqno > 7) ? OCR2 : OCR1;	/* ocr */
  uchr eoi = 0x60 | (irqno & 7); /* specific end-of-interrupt */

  outportb(ocr, eoi);
  if (irqno > 7)
    {
      outportb(OCR1, 0x20);
    }
}
