/* mi.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
/*---------------------------------------------------------------------------*/
/* global variables : use */
extern int lastkey;
extern struct tkeyparse **ptkeyparsetbl;
/*---------------------------------------------------------------------------*/
/* variables */
uchr bdir_changed, bview_changed, curc, curl;
long count, disp0;
ushr ci, li;
uchr confname[256], intrname[256], loginname[256], retval[256];
tfilename filenames[MAXFILES - 1];
uchr scr[4000];
char getit_ext[5];
FILE *getit_fp;

static tkeyparse
  mi_altd = {K_ALTD, keymi_altd},
  mi_altm = {K_ALTM, keymi_altm},
  mi_c = {K_c, keymi_c},
  mi_cr = {K_CR, keymi_cr},
  mi_ctrld = {K_CTRLD, keymi_ctrld},
  mi_ctrlk = {K_CTRLK, keymi_ctrlk},
  mi_ctrlo = {K_CTRLO, keymi_ctrlo},
  mi_d = {K_d, keymi_d},
  mi_down = {K_DOWN, keymi_down},
  mi_e = {K_e, keymi_e},
  mi_end = {K_END, keymi_end},
  mi_f1 = {K_F1, keymi_f1},
  mi_f2 = {K_F2, keymi_f2},
  mi_f3 = {K_F3, keymi_f3},
  mi_f4 = {K_F4, keymi_f4},
  mi_f5 = {K_F5, keymi_f5},
  mi_f6 = {K_F6, keymi_f6},
  mi_f7 = {K_F7, keymi_f7},
  mi_h = {K_h, keymi_h},
  mi_home = {K_HOME, keymi_home},
  mi_i = {K_i, keymi_i},
  mi_left = {K_LEFT, keymi_left},
  mi_m = {K_m, keymi_m},
  mi_p = {K_p, keymi_p},
  mi_pagedown = {K_PAGEDOWN, keymi_pagedown},
  mi_pageup = {K_PAGEUP, keymi_pageup},
  mi_r = {K_r, keymi_r},
  mi_right = {K_RIGHT, keymi_right},
  mi_s = {K_s, keymi_s},
  mi_space = {K_SPACE, keymi_space},
  mi_up = {K_UP, keymi_up},
  mi_v = {K_v, keymi_v},
  mi_w = {K_w, keymi_w}
;

tkeyparse* tkeyparsetbl_mi[] =
{
  &mi_altd,
  &mi_altm,
  &mi_c,
  &mi_cr,
  &mi_ctrld,
  &mi_ctrlk,
  &mi_ctrlo,
  &mi_d,
  &mi_down,
  &mi_e,
  &mi_end,
  &mi_f1,
  &mi_f2,
  &mi_f3,
  &mi_f4,
  &mi_f5,
  &mi_f6,
  &mi_f7,
  &mi_h,
  &mi_home,
  &mi_i,
  &mi_left,
  &mi_m,
  &mi_p,
  &mi_pagedown,
  &mi_pageup,
  &mi_r,
  &mi_right,
  &mi_s,
  &mi_space,
  &mi_up,
  &mi_v,
  &mi_w,
  NULL
};
/*---------------------------------------------------------------------------*/
void main()
{
  login();

  main_loop();

  initscr();
  puttext(1, 1, 80, 25, scr);
  _setcursortype(_NORMALCURSOR);
}
/*---------------------------------------------------------------------------*/
void awindow(long x, long y, long dx, long dy, char *s, uchr ab)
{
  uchr tlengte, tstartpos;

  tlengte = strlen(s);
  tstartpos = x + (((ulng)(dx - tlengte)) >> 1);
  frame(ab, x, y, dx, dy);
  writescr(tstartpos - 1, y - 1, SC_NOR, s);
}
/*---------------------------------------------------------------------------*/
void cs2doss(char* s)
{
  char* p;
  for (p = s; *p; ++p)
    {
      if (*p == '/')
	*p = '\\';
      if (isupper(*p))
	*p = tolower(*p);
    }
}
/*---------------------------------------------------------------------------*/
void dir_changed()
{
  uchr nullpos;
  struct ffblk dirinfo;
  char STR1[256];
  char dir[256], drive[256], ext[256], name[256], temp[256];
  char STR3[20];
  int done = 0;
  char *pc1, *pc2;

  bdir_changed = 0;
  count = 1;
  for (li = 1; li <= MAXFILES; li++) {
    *filenames[li - 1].fn = '\0';
    filenames[li - 1].sel = 0;
    filenames[li - 1].col = SC_NOR;
  }
  done = findfirst("*.*", &dirinfo, FA_ANYFILE);

  while (!done)
    {
      strcpy(filenames[count - 1].fn, dirinfo.ff_name);
      if ((dirinfo.ff_attrib & FA_DIREC) != 0 || /* put directories between [] */
	  !strcmp(filenames[count - 1].fn, "..") ||
	  !strcmp(filenames[count - 1].fn, "."))
	{
	  strcpy(temp, filenames[count-1].fn);
	  pc2 = temp;
	  for (pc1 = filenames[count-1].fn; *pc1; ++pc1) /* remove spaces (Win95 DOS-box) */
	    {
	      if (*pc1 == ' ')
		{
		  /* skip white space */
		}
	      else
		{
		  *pc2 = *pc1;
		  ++pc2;
		}
	    }
	  *pc2 = '\0';
	  strcpy(filenames[count-1].fn, temp);
	  strcpy(ext, "\0");
	  fnsplit(filenames[count-1].fn, drive, dir, name, ext);
	  if ((strlen(name) > 8) || (strlen(ext) > 4)) /* change to DOS-format (Win95 DOS-box) */
	    {
	      fnsplit(filenames[count-1].fn, drive, dir, name, ext);
	      filenames[count-1].fn[6] = '~';
	      filenames[count-1].fn[7] = '1';
	      filenames[count-1].fn[8] = ext[0];
	      filenames[count-1].fn[9] = ext[1];
	      filenames[count-1].fn[10] = ext[2];
	      filenames[count-1].fn[11] = ext[3];
	      filenames[count-1].fn[12] = '\0';
	    }
	  sprintf(STR3, "[%s]", filenames[count - 1].fn);
	  strcpy(filenames[count - 1].fn, STR3);
	}
      else
	{
	  strcpy(temp, filenames[count-1].fn);
	  pc2 = temp;
	  for (pc1 = filenames[count-1].fn; *pc1; ++pc1) /* remove spaces (Win95 DOS-box) */
	    {
	      if (*pc1 == ' ')
		{
		  /* skip white space */
		}
	      else
		{
		  *pc2 = *pc1;
		  ++pc2;
		}
	    }
	  *pc2 = '\0';
	  strcpy(filenames[count-1].fn, temp);
	  fnsplit(filenames[count-1].fn, drive, dir, name, ext);
	  if ((strlen(name) > 8) || (strlen(ext) > 4)) /* change to DOS-format (Win95 DOS-box) */
	    {
	      filenames[count-1].fn[6] = '~';
	      filenames[count-1].fn[7] = '1';
	      filenames[count-1].fn[8] = ext[0];
	      filenames[count-1].fn[9] = ext[1];
	      filenames[count-1].fn[10] = ext[2];
	      filenames[count-1].fn[11] = ext[3];
	      filenames[count-1].fn[12] = '\0';
	    }
	}
      count++;
      done = findnext(&dirinfo);
    }
  count--;
  sort_filenames(1, count);
}
/*---------------------------------------------------------------------------*/
void execit(char *commandline)
{
  system(commandline);
}
/*---------------------------------------------------------------------------*/
void frame(uchr ft, long startx, long starty, long dx, long dy)
{
  uchr frames[2][6] = {
    { 218, 191, 217, 192, 196, 179 },
    { 201, 187, 188, 200, 205, 186 }
  };

  long lx, ly;
  char s[256];

  sprintf(s, "%c", frames[ft - 1][0]);
  for (lx = 1; lx <= dx - 2; lx++)
    sprintf(s + strlen(s), "%c", frames[ft - 1][4]);
  sprintf(s + strlen(s), "%c", frames[ft - 1][1]);
  writescr(startx - 1, starty - 1, SC_NOR, s);
  for (ly = 0; ly <= dy - 3; ly++) {
    sprintf(s, "%c", frames[ft - 1][5]);
    for (lx = 1; lx <= dx - 2; lx++)
      strcat(s, " ");
    sprintf(s + strlen(s), "%c", frames[ft - 1][5]);
    writescr(startx - 1, starty + ly, SC_NOR, s);
  }
  sprintf(s, "%c", frames[ft - 1][3]);
  for (lx = 1; lx <= dx - 2; lx++)
    sprintf(s + strlen(s), "%c", frames[ft - 1][4]);
  sprintf(s + strlen(s), "%c", frames[ft - 1][2]);
  writescr(startx - 1, starty + dy - 2, SC_NOR, s);
}
/*---------------------------------------------------------------------------*/
int getall(const char *path, const struct ffblk *ff)
{
  char cmdline[256], dir[256], drive[256], ext[256], name[256];

  fnsplit(path, drive, dir, name, ext);
  strlwr(ext);
  if (!strcmp(".avi", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".bmp", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".fli", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".gif", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".iff", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".it", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".jpg", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".lbm", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".mid", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".mod", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".mov", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".mpg", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".mtm", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".pcd", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".pcx", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".png", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".s3m", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".tga", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".tif", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".voc", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".wav", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (!strcmp(".xm", ext))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline);
    }
  if (strcmp(ff->ff_name, "XXXXX") == 0)
    return 42;
  return 0;
}
/*---------------------------------------------------------------------------*/
int getit(const char *path, const struct ffblk *ff)
{
  char dir[256], drive[256], ext[256], name[256], cmdline[256];
  if (!strcmp(getit_ext, ".*"))
    {
      fprintf(getit_fp, "%s\n", path);
    }
  else
    {
      fnsplit(path, drive, dir, name, ext);
      strlwr(ext);
      if (!strcmp(getit_ext, ext))
	{
	  fprintf(getit_fp, "%s\n", path);
	}
    }
  if (strcmp(ff->ff_name, "XXXXX") == 0)
    return 42;
  return 0;
}
/*---------------------------------------------------------------------------*/
void i2pos(long i)
{
  disp0 = i / (NTOTAL + 1) * NTOTAL;
  curc = (i - disp0) / NLINS;
  if (i % NLINS == 0) curc--;
  curl = i - disp0 - curc * NLINS;
}
/*---------------------------------------------------------------------------*/
void initscr()
{
  ushr w = 0;

  while ((w + 1) < 4000) {
    scr[w] = 219;
    scr[w + 1] = BLUE;
    w += 2;
  }
}
/*---------------------------------------------------------------------------*/
void keymi_altd()
{
  char c;
  ushr l;
  char s[256];

  bdir_changed = 1;
  bview_changed = 1;
  disp0 = 0;
  curc = 0;
  curl = 1;
  do {
    writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
    writescr(PX - 1, PY - 1, SC_NOR, "Enter drive letter : ");
    puttext(1, 1, 80, 25, scr);
    l = strlen("Enter drive letter : ");
    gotoxy(PX + l, PY);
    _setcursortype(_NORMALCURSOR);
    scanf("%c%*[^\n]", &c);
    getchar();
    if (c == '\n')
      c = ' ';
    _setcursortype(_NOCURSOR);
  } while (!isalpha(c));
  *s = '\0';
  sprintf(s, "%c:\\", c);
  chdir(s);
  if (errno != 0) {
    /*    sprintf(s, "Drive %c not found <CR>", toupper(c));
	  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
	  writescr(PX - 1, PY - 1, SC_NOR, s);
	  puttext(1, 1, 80, 25, scr);
	  l = strlen(s);
	  gotoxy(PX + l, PY);
	  _setcursortype(_NORMALCURSOR);
	  scanf("%*[^\n]");
	  getchar();
	  _setcursortype(_NOCURSOR); */
  }
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  puttext(1, 1, 80, 25, scr);
}
/*---------------------------------------------------------------------------*/
void keymi_altm()
{
  uchr b;
  ushr l;
  char cmdline[256], dir[256], drive[256], ext[256], name[256], s[256];
  FILE *tconf;

  bdir_changed = 1;
  bview_changed = 1;
  strcpy(retval, filenames[curc * NLINS + curl + disp0 - 1].fn);
  tconf = NULL;
  b = 0;
  *cmdline = '\0';
  *s = '\0';
  tconf = fopen(confname, "rt");
  rewind(tconf);
  setfilept(tconf, INI_M, 1);
  fnsplit(retval, drive, dir, name, ext);
  strupr(ext);
  while (strcmp(s, TERMIN) && b == 0) {
    fgets(s, 256, tconf);
    l = strlen(s);
    s[l - 1] = '\0'; /* strip \n */
    if (strcmp(s, ext))
      continue;
    fgets(s, 256, tconf);
    l = strlen(s);
    s[l - 1] = '\0'; /* strip \n */
    sprintf(cmdline, " %s %s", s, retval);
    b = 1;
  }
  if (tconf != NULL)
    fclose(tconf);
  tconf = NULL;
  if (b == 0) { /* open with <Make><Default> */
    tconf = fopen(confname, "rt");
    rewind(tconf);
    setfilept(tconf, INI_DEFAULT_M, 1);
    fgets(s, 256, tconf);
    l = strlen(s);
    s[l - 1] = '\0'; /* strip \n */
    sprintf(cmdline, " %s %s", s, retval);
    if (tconf != NULL)
      fclose(tconf);
    tconf = NULL;
  }
  if (*cmdline != '\0') {
    writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
    writescr(PX - 1, PY - 1, SC_NOR, "Enter target : ");
    puttext(1, 1, 80, 25, scr);
    l = strlen("Enter target : ");
    gotoxy(PX + l, PY);
    _setcursortype(_NORMALCURSOR);
    gets(s);
    sprintf(cmdline + strlen(cmdline), " %s", s);
    execit(cmdline);
    _setcursortype(_NOCURSOR);
  }
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  puttext(1, 1, 80, 25, scr);
  if (tconf != NULL)
    fclose(tconf);
}
/*---------------------------------------------------------------------------*/
void keymi_c()
{
  ushr l;
  char cmdline[256], s[256];

  bdir_changed = 1;
  bview_changed = 1;
  strcpy(retval, filenames[curc * NLINS + curl + disp0 - 1].fn);
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  writescr(PX - 1, PY - 1, SC_NOR, "Copy to : ");
  puttext(1, 1, 80, 25, scr);
  l = strlen("Copy to : ");
  gotoxy(PX + l, PY);
  _setcursortype(_NORMALCURSOR);
  gets(s);
  sprintf(cmdline, " copy %s %s", retval, s);
  execit(cmdline);
  _setcursortype(_NOCURSOR);
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  puttext(1, 1, 80, 25, scr);
}
/*---------------------------------------------------------------------------*/
void keymi_cr()
{
  uchr b, l;
  char cmdline[256], dir[256], drive[256], ext[256], name[256], s[256];
  FILE *tconf;

  bdir_changed = 1;
  bview_changed = 1;
  strcpy(retval, filenames[curc * NLINS + curl + disp0 - 1].fn);
  if (retval[0] == '[')
    {
      strip(retval);
      chdir(retval);
      disp0 = 0;
      curc = 0;
      curl = 1;
    }
  else
    {
      tconf = NULL;
      _setcursortype(_NORMALCURSOR);
      b = 0;
      *cmdline = '\0';
      *s = '\0';
      fnsplit(retval, drive, dir, name, ext);
      strupr(ext);
      if (strcmp(ext, ".BAT") && strcmp(ext, ".COM") && strcmp(ext, ".EXE")) {
	tconf = fopen(confname, "rt");
	rewind(tconf);
	setfilept(tconf, INI_CR, 1);
	while (strcmp(s, TERMIN) && b == 0) {
	  fgets(s, 256, tconf);
	  l = strlen(s);
	  s[l - 1] = '\0'; /* strip \n */
	  if (strcmp(s, ext))
	    continue;
	  fgets(s, 256, tconf);
	  l = strlen(s);
	  s[l - 1] = '\0'; /* strip \n */
	  sprintf(cmdline, " %s %s", s, retval);
	  b = 1;
	}
	if (tconf != NULL)
	  fclose(tconf);
	tconf = NULL;
	if (b == 0) {   /* open with <CR><Default> */
	  tconf = fopen(confname, "rt");
	  rewind(tconf);
	  setfilept(tconf, INI_DEFAULT_CR, 1);
	  fgets(s, 256, tconf);
	  l = strlen(s);
	  s[l - 1] = '\0'; /* strip \n */
	  sprintf(cmdline, " %s %s", s, retval);
	  if (tconf != NULL)
	    fclose(tconf);
	  tconf = NULL;
	}
      } else
	sprintf(cmdline, " %s", retval);
      if (*cmdline != '\0')
	execit(cmdline);
      _setcursortype(_NOCURSOR);
      if (tconf != NULL)
	fclose(tconf);
    }
}
/*---------------------------------------------------------------------------*/
void keymi_ctrld()
{
  uint w;
  char c;
  size_t l;

  bdir_changed = 1;
  bview_changed = 1;
  disp0 = 0;
  curc = 0;
  curl = 1;
  do
    {
      writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
      writescr(PX - 1, PY - 1, SC_NOR, "Delete (y/n) : ");
      puttext(1, 1, 80, 25, scr);
      l = strlen("Delete (y/n) : ");
      gotoxy(PX + l, PY);
      _setcursortype(_NORMALCURSOR);
      scanf("%c%*[^\n]", &c);
      getchar();
      if (c == '\n')
	c = ' ';
    }
  while (c != 'n' && c != 'y');
  if (c == 'y')
    {
      for (w = 0; w < count; w++)
	{
	  if (filenames[w].sel == 1)
	    {
	      /* you can't delete these */
	      if ((!strcmp(filenames[w].fn, "[..]")) ||
		  (!strcmp(filenames[w].fn, "[.]")))
		{
		}
	      else
		{
		  /* if a directory, first strip [ and ] */
		  if (filenames[w].fn[0] == '[')
		    {
		      strip(filenames[w].fn);
		    }
		  /* delete */
		  chmod(filenames[w].fn, S_IWUSR);
		  unlink(filenames[w].fn);
		}
	    }
	}
    }
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  puttext(1, 1, 80, 25, scr);
  _setcursortype(_NOCURSOR);
}
/*---------------------------------------------------------------------------*/
void keymi_ctrlk()
{
  ushr l, w;
  char cmdline[256], s[256];

  bdir_changed = 0;
  bview_changed = 1;
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  writescr(PX - 1, PY - 1, SC_NOR, "Copy to : ");
  puttext(1, 1, 80, 25, scr);
  l = strlen("Copy to : ");
  gotoxy(PX + l, PY);
  _setcursortype(_NORMALCURSOR);
  gets(s);
  for (w = 0; w < count; w++) {
    if (filenames[w].sel == 1) {
      filenames[w].sel = 0;
      filenames[w].col = SC_NOR;
      if (filenames[w].fn[0] == '[' && strcmp(filenames[w].fn, "[..]") &&
	  strcmp(filenames[w].fn, "[.]")) {
	strip(filenames[w].fn);
	sprintf(cmdline, " copy %s %s", filenames[w].fn, s);
      } else
	sprintf(cmdline, " copy %s %s", filenames[w].fn, s);
      execit(cmdline);
    }
  }
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  puttext(1, 1, 80, 25, scr);
  _setcursortype(_NOCURSOR);
}
/*---------------------------------------------------------------------------*/
void keymi_ctrlo()
{
  int special = 0;
  char s[256], s1[256];
  size_t l;
  uint w;

  bdir_changed = 1;
  bview_changed = 1;
  disp0 = 0;
  curc = 0;
  curl = 1;
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  writescr(PX - 1, PY - 1, SC_NOR, "Move to : ");
  puttext(1, 1, 80, 25, scr);
  l = strlen("Move to : ");
  gotoxy(PX + l, PY);
  _setcursortype(_NORMALCURSOR);
  gets(s);
  for (w = 0; w < count; w++)
    {
      if (filenames[w].sel == 1)
	{
	  /* you can't move these */
	  if ((!strcmp(filenames[w].fn, "[..]")) ||
	      (!strcmp(filenames[w].fn, "[.]")))
	    {
	    }
	  else
	    {
	      /* if a directory, first strip [ and ] */
	      if (filenames[w].fn[0] == '[')
		{
		  strip(filenames[w].fn);
		}
	      strcpy(s1, "");
	      sprintf(s1, "%s\\%s", s, filenames[w].fn);
	      rename(filenames[w].fn, s1);
	    }
  	}
    }
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  puttext(1, 1, 80, 25, scr);
  _setcursortype(_NOCURSOR);
}
/*---------------------------------------------------------------------------*/
void keymi_d()
{
  int special = 0;
  char c;
  size_t l;

  bdir_changed = 1;
  bview_changed = 1;
  strcpy(retval, filenames[curc * NLINS + curl + disp0 - 1].fn);
  disp0 = 0;
  curc = 0;
  curl = 1;
  /* you can't delete these */
  if ((!strcmp(retval, "[..]")) ||
      (!strcmp(retval, "[.]")))
    {
      special = 1;
    }
  else
    {
      /* if a directory, first strip [ and ] */
      if (retval[0] == '[')
	{
	  strip(retval);
	}
    }
  do
    {
      writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE); /* 0, 23 */
      writescr(PX - 1, PY - 1, SC_NOR, "Delete (y/n) : "); /* 0, 23 */
      puttext(1, 1, 80, 25, scr);
      l = strlen("Delete (y/n) : ");
      gotoxy(PX + l, PY);
      _setcursortype(_NORMALCURSOR);
      scanf("%c%*[^\n]", &c);
      getchar();
      if (c == '\n')
	c = ' ';
    }
  while (c != 'n' && c != 'y');
  if ((c == 'y') && (!special))
    {
      /* delete */
      chmod(retval, S_IWUSR);
      unlink(retval);
    }
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  puttext(1, 1, 80, 25, scr);
  _setcursortype(_NOCURSOR);
}
/*---------------------------------------------------------------------------*/
void keymi_down()
{
  bdir_changed = 0;
  bview_changed = 1;
  if ((nav_etab() == 0) & (nav_escr() == 0) & (nav_ecol() == 1)) {
    curl = 1;
    curc++;
    return;
  }
  if (!((nav_etab() == 0) & (nav_escr() == 1))) {
    if (nav_etab() == 0)
      curl++;
    return;
  }
  curl = 1;
  curc = 0;
  disp0 += NTOTAL;
}
/*---------------------------------------------------------------------------*/
void keymi_e()
{
  uchr b, l;
  char cmdline[256], dir[256], drive[256], ext[256], name[256], s[256];
  FILE *tconf;
  char STR2[256];

  bdir_changed = 1;
  bview_changed = 1;
  strcpy(retval, filenames[curc * NLINS + curl + disp0 - 1].fn);
  b = 0;
  *cmdline = '\0';
  tconf = fopen(confname, "rt");
  rewind(tconf);
  setfilept(tconf, INI_E, 1);
  fnsplit(retval, drive, dir, name, ext);
  strupr(ext);
  while (strcmp(s, TERMIN) && b == 0) {
    fgets(s, 256, tconf);
    l = strlen(s);
    s[l - 1] = '\0'; /* strip \n */
    if (strcmp(s, ext))
      continue;
    fgets(s, 256, tconf);
    l = strlen(s);
    s[l - 1] = '\0'; /* strip \n */
    sprintf(cmdline, "%s %s", s, retval);
    b = 1;
  }
  if (tconf != NULL)
    fclose(tconf);
  tconf = NULL;
  if (b == 0) { /* open with <Edit><Default> */
    tconf = fopen(confname, "rt");
    rewind(tconf);
    setfilept(tconf, INI_DEFAULT_E, 1);
    fgets(s, 256, tconf);
    l = strlen(s);
    s[l - 1] = '\0'; /* strip \n */
    sprintf(cmdline, " %s %s", s, retval);
    if (tconf != NULL)
      fclose(tconf);
    tconf = NULL;
  }
  if (tconf != NULL)
    fclose(tconf);
  if (*cmdline != '\0') {
    _setcursortype(_NORMALCURSOR);
    execit(cmdline);
    _setcursortype(_NOCURSOR);
  }
}
/*---------------------------------------------------------------------------*/
void keymi_end()
{
  bdir_changed = 0;
  bview_changed = 1;
  i2pos(count);
}
/*---------------------------------------------------------------------------*/
void keymi_f1()
{
  ushr w, l;
  char s[256];
  FILE *t;

  bdir_changed = 0;
  bview_changed = 1;
  t = NULL;
  t = fopen(HELPNAME, "rt");
  rewind(t);
  *s = '\0';
  w = 0;
  initscr();
  puttext(1, 1, 80, 25, scr);
  while (fgets(s, 256, t) != NULL) {
    l = strlen(s);
    s[l - 1] = '\0'; /* strip \n */
    puts(s);
    w++;
    if (w % 24 != 0)
      continue;
    printf("Press <ENTER> to continue ... ");
    _setcursortype(_NORMALCURSOR);
    scanf("%*[^\n]");
    getchar();
    _setcursortype(_NOCURSOR);
  }
  if (w % 24 != 0) {
    printf("Press <ENTER> to continue ... ");
    _setcursortype(_NORMALCURSOR);
    scanf("%*[^\n]");
    getchar();
    _setcursortype(_NOCURSOR);
  }
  if (t != NULL)
    fclose(t);
  t = NULL;
  if (t != NULL)
    fclose(t);
}
/*---------------------------------------------------------------------------*/
void keymi_f2()
{
  uchr batchmode, l, fields = 0;
  char afile[256], cmdline[256], s256[256];
  char dir[256], drive[256], ext[256], name[256];
  FILE *pfc, *pff, *pfi;

  bdir_changed = 1;
  bview_changed = 1;
  strcpy(retval, filenames[curc * NLINS + curl + disp0 - 1].fn);
  _setcursortype(_NORMALCURSOR);

  pfc = fopen(confname, "rt");
  setfilept(pfc, INI_OTHER, 1);
  fscanf(pfc, "%s", s256);
  fscanf(pfc, "%s", s256);
  fscanf(pfc, "%s", s256);
  strlwr(s256);
  if (!strcmp(s256, "auto"))
    batchmode = BATCHAUTO;
  else
    batchmode = BATCHMANUAL;
  fclose(pfc);

  fnsplit(retval, drive, dir, name, ext);

  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  writescr(PX - 1, PY - 1, SC_NOR, "Process files in (.txt) : ");
  puttext(1, 1, 80, 25, scr);
  l = strlen("Process files in (.txt) : ");
  gotoxy(PX + l, PY);

  gets(s256);
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  puttext(1, 1, 80, 25, scr);

  pfi = fopen(s256, "rt");
  while (1 == 1)
    {
      fields = fscanf(pfi, "%s", afile);
      if (fields != 1) break;
      sprintf(cmdline, "%s %s", name, afile);
      execit(cmdline);
      if (batchmode == BATCHMANUAL)
	{
	  getch();
	}
    }
  fclose(pfi);

  _setcursortype(_NOCURSOR);
}
/*---------------------------------------------------------------------------*/
void keymi_f3()
{
  uint w;
  int choice = 0; /* choice default to no compressed file */
  char curdir[256], s256[256];
  char dir[256], drive[256], ext[256], name[256];

  bdir_changed = 1;
  bview_changed = 1;
  _setcursortype(_NORMALCURSOR);

  getcwd(curdir, 255);
  cs2doss(curdir);

  sprintf(s256, "%s", "attrib -r *.*");
  execit(s256);

  for (w = 0; w < count; w++)
    {
      fnsplit(filenames[w].fn, drive, dir, name, ext);
      strlwr(ext);
      if (!strcmp(ext, ".arc")) choice = 1;
      else if (!strcmp(ext, ".arj")) choice = 2;
      else if ((ext[1] == 'a') && (ext[2] == '0')) choice = 2;
      else if (!strcmp(ext, ".gz")) choice = 3;
      else if (!strcmp(ext, ".lzh")) choice = 4;
      else if (!strcmp(ext, ".rar")) choice = 5;
      else if ((ext[1] == 'r') && (ext[2] == '0')) choice = 5;
      else if (!strcmp(ext, ".tar")) choice = 6;
      else if (!strcmp(ext, ".tgz")) choice = 7;
      else if (!strcmp(ext, ".zip")) choice = 8;
      else choice = 0;
      if (choice)
	{
	  sprintf(s256, "md %s", name);
	  execit(s256);
	  sprintf(s256, "move %s %s/%s", filenames[w].fn, curdir, name);
	  cs2doss(s256);
	  execit(s256);
	  sprintf(s256, "%s/%s", curdir, name);
	  cs2doss(s256);
	  chdir(s256);
	  switch (choice)
	    {
	    case 1:
	      {
		sprintf(s256, "arc e %s%s", name, ext);
		cs2doss(s256);
		execit(s256);
		break;
	      }
	    case 2:
	      {
		if (ext[2] != '0')
		  {
		    sprintf(s256, "arj e %s%s", name, ext);
		    cs2doss(s256);
		    execit(s256);
		  }
		break;
	      }
	    case 3:
	      {
		sprintf(s256, "gunzip %s%s", name, ext);
		cs2doss(s256);
		execit(s256);
		break;
	      }
	    case 4:
	      {
		sprintf(s256, "lha e %s%s", name, ext);
		cs2doss(s256);
		execit(s256);
		break;
	      }
	    case 5:
	      {
		if (ext[2] != '0')
		  {
		    sprintf(s256, "rar e %s%s", name, ext);
		    cs2doss(s256);
		    execit(s256);
		    break;
		  }
	      }
	    case 6:
	      {
		sprintf(s256, "djtar %s%s", name, ext);
		cs2doss(s256);
		execit(s256);
		break;
	      }
	    case 7:
	      {
		sprintf(s256, "djtar -z %s%s", name, ext);
		cs2doss(s256);
		execit(s256);
		break;
	      }
	    case 8:
	      {
		sprintf(s256, "pkunzip -d %s%s", name, ext);
		cs2doss(s256);
		execit(s256);
		break;
	      }
	    }
	  sprintf(s256, "%s", "attrib -r *.*");
	  execit(s256);
	  chdir(curdir);
	}
    }

  _setcursortype(_NOCURSOR);
}
/*---------------------------------------------------------------------------*/
void keymi_f4()
{
  bdir_changed = 1;
  bview_changed = 1;
  unlink(intrname);
}
/*---------------------------------------------------------------------------*/
void keymi_f5()
{
  uchr l;
  char d[256], n[256];

  bdir_changed = 1;
  bview_changed = 1;
  strcpy(retval, filenames[curc * NLINS + curl + disp0 - 1].fn);
  _setcursortype(_NORMALCURSOR);

  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  writescr(PX - 1, PY - 1, SC_NOR, "scan directory : ");
  puttext(1, 1, 80, 25, scr);
  l = strlen("scan directory : ");
  gotoxy(PX + l, PY);

  gets(d);
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  puttext(1, 1, 80, 25, scr);

  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  writescr(PX - 1, PY - 1, SC_NOR, "for extension : ");
  puttext(1, 1, 80, 25, scr);
  l = strlen("for extension : ");
  gotoxy(PX + l, PY);

  gets(getit_ext);
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  puttext(1, 1, 80, 25, scr);

  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  writescr(PX - 1, PY - 1, SC_NOR, "put filenames in : ");
  puttext(1, 1, 80, 25, scr);
  l = strlen("put filenames in : ");
  gotoxy(PX + l, PY);

  gets(n);
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  puttext(1, 1, 80, 25, scr);

  getit_fp = fopen(n, "wt");
  __file_tree_walk(d, getit);
  fclose(getit_fp);

  _setcursortype(_NOCURSOR);
}
/*---------------------------------------------------------------------------*/
void keymi_f6()
{
  uchr l;
  char d[256], n[256];

  bdir_changed = 1;
  bview_changed = 1;
  strcpy(retval, filenames[curc * NLINS + curl + disp0 - 1].fn);
  _setcursortype(_NORMALCURSOR);

  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  writescr(PX - 1, PY - 1, SC_NOR, "scan directory : ");
  puttext(1, 1, 80, 25, scr);
  l = strlen("scan directory : ");
  gotoxy(PX + l, PY);

  gets(d);
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  puttext(1, 1, 80, 25, scr);

  __file_tree_walk(d, getall);

  _setcursortype(_NOCURSOR);
}
/*---------------------------------------------------------------------------*/
void keymi_f7()
{
  uchr l;
  char d[256], n[256];

  bdir_changed = 1;
  bview_changed = 1;
  strcpy(retval, filenames[curc * NLINS + curl + disp0 - 1].fn);
  _setcursortype(_NORMALCURSOR);

  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  writescr(PX - 1, PY - 1, SC_NOR, "scan directory : ");
  puttext(1, 1, 80, 25, scr);
  l = strlen("scan directory : ");
  gotoxy(PX + l, PY);

  gets(d);
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  puttext(1, 1, 80, 25, scr);

  __file_tree_walk(d, modit);

  _setcursortype(_NOCURSOR);
}
/*---------------------------------------------------------------------------*/
void keymi_h()
{
  ushr w, l;
  char s[256];
  FILE *t;

  bdir_changed = 0;
  bview_changed = 1;
  t = NULL;
  t = fopen(HELPNAME, "rt");
  rewind(t);
  *s = '\0';
  w = 0;
  initscr();
  puttext(1, 1, 80, 25, scr);
  while (fgets(s, 256, t) != NULL) {
    l = strlen(s);
    s[l - 1] = '\0'; /* strip \n */
    puts(s);
    w++;
    if (w % 24 != 0)
      continue;
    printf("Press <ENTER> to continue ... ");
    _setcursortype(_NORMALCURSOR);
    scanf("%*[^\n]");
    getchar();
    _setcursortype(_NOCURSOR);
  }
  if (w % 24 != 0) {
    printf("Press <ENTER> to continue ... ");
    _setcursortype(_NORMALCURSOR);
    scanf("%*[^\n]");
    getchar();
    _setcursortype(_NOCURSOR);
  }
  if (t != NULL)
    fclose(t);
  t = NULL;
  if (t != NULL)
    fclose(t);
}
/*---------------------------------------------------------------------------*/
void keymi_home()
{
  bdir_changed = 0;
  bview_changed = 1;
  i2pos(1);
}
/*---------------------------------------------------------------------------*/
void keymi_i()
{
  char *s = "", s0[256] = "";
  char *p;
  FILE *t;

  if (!access(intrname, F_OK))
    bdir_changed = 0;
  else
    bdir_changed = 1;
  bview_changed = 1;
  strcpy(retval, filenames[curc * NLINS + curl + disp0 - 1].fn);
  t = NULL;
  s = searchpath(retval);
  p = s;
  if (*p == '.')
    {
      p++;
      getcwd(s0, 100);
      strcat(s0, p);
    }
  cs2doss(s0);
  if (!access(intrname, F_OK))
    {
      t = fopen(intrname, "at");
      fprintf(t, "%s\n", s0);
    }
  else
    {
      t = fopen(intrname, "wt");
      fprintf(t, "%s\n", s0);
    }
  fclose(t);
  keymi_down();
}
/*---------------------------------------------------------------------------*/
void keymi_left()
{
  bdir_changed = 0;
  bview_changed = 1;
  if (!((nav_btab() == 0) & (pos2i() > NLINS)))
    return;
  if (curc != 0)
    curc--;
  else {
    curc = 4;
    disp0 -= NTOTAL;
  }
}
/*---------------------------------------------------------------------------*/
void keymi_m()
{
  char s[256];
  size_t l;

  bdir_changed = 1;
  bview_changed = 1;
  strcpy(retval, filenames[curc * NLINS + curl + disp0 - 1].fn);
  disp0 = 0;
  curc = 0;
  curl = 1;
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  writescr(PX - 1, PY - 1, SC_NOR, "Move to : ");
  puttext(1, 1, 80, 25, scr);
  l = strlen("Move to : ");
  gotoxy(PX + l, PY);
  _setcursortype(_NORMALCURSOR);
  gets(s);
  sprintf(s, "%s\\%s", s, retval);
  rename(retval, s);
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  puttext(1, 1, 80, 25, scr);
  _setcursortype(_NOCURSOR);
}
/*---------------------------------------------------------------------------*/
void keymi_p()
{
  uchr b, l;
  char cmdline[256], dir[256], drive[256], ext[256], name[256], s[256];
  FILE *tconf;
  char STR2[256];

  bdir_changed = 0;
  bview_changed = 1;
  strcpy(retval, filenames[curc * NLINS + curl + disp0 - 1].fn);
  tconf = NULL;
  b = 0;
  *cmdline = '\0';
  *s = '\0';
  tconf = fopen(confname, "rt");
  rewind(tconf);
  setfilept(tconf, INI_P, 1);
  fnsplit(retval, drive, dir, name, ext);
  strupr(ext);
  while (strcmp(s, TERMIN) && b == 0) {
    fgets(s, 256, tconf);
    l = strlen(s);
    s[l - 1] = '\0'; /* strip \n */
    if (strcmp(s, ext))
      continue;
    fgets(s, 256, tconf);
    l = strlen(s);
    s[l - 1] = '\0'; /* strip \n */
    sprintf(cmdline, "%s %s", s, retval);
    b = 1;
  }
  if (tconf != NULL)
    fclose(tconf);
  tconf = NULL;
  if (b == 0) { /* open with <Play><Default> */
    tconf = fopen(confname, "rt");
    rewind(tconf);
    setfilept(tconf, INI_DEFAULT_P, 1);
    fgets(s, 256, tconf);
    l = strlen(s);
    s[l - 1] = '\0'; /* strip \n */
    sprintf(cmdline, " %s %s", s, retval);
    if (tconf != NULL)
      fclose(tconf);
    tconf = NULL;
  }
  if (*cmdline != '\0') {
    _setcursortype(_NORMALCURSOR);
    sprintf(cmdline, " %s", strcpy(STR2, cmdline));
    execit(cmdline);
    _setcursortype(_NOCURSOR);
    keymi_down();
  }
  if (tconf != NULL)
    fclose(tconf);
}
/*---------------------------------------------------------------------------*/
void keymi_pagedown()
{
  bdir_changed = 0;
  bview_changed = 1;
  if ((nav_etab() == 0) & (nav_ecol() == 0) & (NLINS - curl <= count - pos2i())) {
    curl = NLINS;
    return;
  }
  if ((nav_etab() == 0) & (nav_ecol() == 0) & (NLINS - curl > count - pos2i())) {
    curl = count % NLINS;
    return;
  }
  if ((nav_etab() == 0) & (nav_ecol() == 1) & (NLINS <= count - pos2i())) {
    curl = NLINS;
    if (curc != 4)
      curc++;
    else {
      curc = 0;
      disp0 += NTOTAL;
    }
    return;
  }
  if (!((nav_etab() == 0) & (nav_ecol() == 1) & (NLINS > count - pos2i())))
    return;
  curl = count % NLINS;
  if (curc != 4)
    curc++;
  else {
    curc = 0;
    disp0 += NTOTAL;
  }
}
/*---------------------------------------------------------------------------*/
void keymi_pageup()
{
  bdir_changed = 0;
  bview_changed = 1;
  if ((nav_btab() == 0) & (nav_bcol() == 0)) {
    curl = 1;
    return;
  }
  if (!((nav_btab() == 0) & (nav_bcol() == 1)))
    return;
  curl = 1;
  if (curc != 0)
    curc--;
  else {
    curc = NCOLS - 1;
    disp0 -= NTOTAL;
  }
}
/*---------------------------------------------------------------------------*/
void keymi_r()
{
  char s[256];
  size_t l;

  bdir_changed = 1;
  bview_changed = 1;
  strcpy(retval, filenames[curc * NLINS + curl + disp0 - 1].fn);
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  writescr(PX - 1, PY - 1, SC_NOR, "Rename to : ");
  puttext(1, 1, 80, 25, scr);
  l = strlen("Rename to : ");
  gotoxy(PX + l, PY);
  _setcursortype(_NORMALCURSOR);
  gets(s);
  rename(retval, s);
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  puttext(1, 1, 80, 25, scr);
  _setcursortype(_NOCURSOR);
}
/*---------------------------------------------------------------------------*/
void keymi_right()
{
  bdir_changed = 0;
  bview_changed = 1;
  if (!((nav_etab() == 0) & (pos2i() + NLINS <= count)))
    return;
  if (curc != 4)
    curc++;
  else {
    curc = 0;
    disp0 += NTOTAL;
  }
}
/*---------------------------------------------------------------------------*/
void keymi_s()
{
  ushr l;
  char cmdline[256], s[256];

  bdir_changed = 1;
  bview_changed = 1;
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  writescr(PX - 1, PY - 1, SC_NOR, "DOS command : ");
  puttext(1, 1, 80, 25, scr);
  l = strlen("DOS command : ");
  gotoxy(PX + l, PY);
  _setcursortype(_NORMALCURSOR);
  gets(s);
  sprintf(cmdline, " %s", s);
  execit(cmdline);
  _setcursortype(_NOCURSOR);
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  puttext(1, 1, 80, 25, scr);
}
/*---------------------------------------------------------------------------*/
void keymi_space()
{
  bdir_changed = 0;
  bview_changed = 1;
  if (filenames[curc * NLINS + curl + disp0 - 1].sel == 1)
    {
      filenames[curc * NLINS + curl + disp0 - 1].sel = 0;
      filenames[curc * NLINS + curl + disp0 - 1].col = SC_NOR;
    }
  else
    {
      filenames[curc * NLINS + curl + disp0 - 1].sel = 1;
      filenames[curc * NLINS + curl + disp0 - 1].col = SC_SEL;
    }
  keymi_down();
}
/*---------------------------------------------------------------------------*/
void keymi_up()
{
  bdir_changed = 0;
  bview_changed = 1;
  if ((nav_btab() == 0) & (nav_bscr() == 0) & (nav_bcol() == 1)) {
    curl = NLINS;
    curc--;
    return;
  }
  if (!((nav_btab() == 0) & (nav_bscr() == 1))) {
    if (nav_btab() == 0)
      curl--;
    return;
  }
  curl = NLINS;
  curc = NCOLS - 1;
  disp0 -= NTOTAL;
}
/*---------------------------------------------------------------------------*/
void keymi_v()
{
  uchr b, l;
  char cmdline[256], dir[256], drive[256], ext[256], name[256], s[256];
  FILE *tconf;
  char STR2[256];

  bdir_changed = 0;
  bview_changed = 1;
  strcpy(retval, filenames[curc * NLINS + curl + disp0 - 1].fn);
  tconf = NULL;
  b = 0;
  *cmdline = '\0';
  *s = '\0';
  tconf = fopen(confname, "rt");
  rewind(tconf);
  setfilept(tconf, INI_V, 1);
  fnsplit(retval, drive, dir, name, ext);
  strupr(ext);
  while (strcmp(s, TERMIN) && b == 0) {
    fgets(s, 256, tconf);
    l = strlen(s);
    s[l - 1] = '\0'; /* strip \n */
    if (strcmp(s, ext))
      continue;
    fgets(s, 256, tconf);
    l = strlen(s);
    s[l - 1] = '\0'; /* strip \n */
    sprintf(cmdline, "%s %s", s, retval);
    b = 1;
  }
  if (tconf != NULL)
    fclose(tconf);
  tconf = NULL;
  if (b == 0) { /* open with <View><Default> */
    tconf = fopen(confname, "rt");
    rewind(tconf);
    setfilept(tconf, INI_DEFAULT_V, 1);
    fgets(s, 256, tconf);
    l = strlen(s);
    s[l - 1] = '\0'; /* strip \n */
    sprintf(cmdline, " %s %s", s, retval);
    if (tconf != NULL)
      fclose(tconf);
    tconf = NULL;
  }
  if (*cmdline != '\0') {
    _setcursortype(_NORMALCURSOR);
    sprintf(cmdline, " %s", strcpy(STR2, cmdline));
    execit(cmdline);
    _setcursortype(_NOCURSOR);
  }
  if (tconf != NULL)
    fclose(tconf);
}
/*---------------------------------------------------------------------------*/
void keymi_w()
{
  ushr l;
  char s[256];

  bdir_changed = 0;
  bview_changed = 1;
  sprintf(s, "%s <CR> ", VERSIONMI);
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  writescr(PX - 1, PY - 1, SC_NOR, s);
  puttext(1, 1, 80, 25, scr);
  l = strlen(s);
  gotoxy(PX + l, PY);
  _setcursortype(_NORMALCURSOR);
  gets(s);
  _setcursortype(_NOCURSOR);
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  puttext(1, 1, 80, 25, scr);
}
/*---------------------------------------------------------------------------*/
void login()
{
  ushr l;
  char s[256];
  FILE *fp, *tdef, *tconf;

  fp = fopen(DEFNAME, "rt");
  if (!fp)
    {
      clrscr();
      printf("OOOPS, couldn't find %s\n", DEFNAME);
      printf("This file may not be moved, renamed, or deleted.\n");
      printf("installation: c:\\djgpp\\pkunzip -d ebmchxxxx.zip\n");
      printf("Enjoy :-)\n");
      exit(1);
    }
  fclose(fp);
  tconf = NULL;
  tdef = NULL;
  bdir_changed = 1;
  bview_changed = 1;
  curc = 0;
  curl = 1;
  disp0 = 0;

  textbackground(BLUE);
  textcolor(LIGHTGRAY);
  initscr();
  awindow(SC_X, SC_Y, SC_WI, SC_LE, SC_TI, SC_FT);
  puttext(1,1,80,25,scr);
  do {
    writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
    writescr(PX - 1, PY - 1, SC_NOR, "Enter your login name (max. 4 chars) : ");
    puttext(1, 1, 80, 25, scr);
    l = strlen("Enter your login name (max. 4 chars) : ");
    gotoxy(PX + l, PY);
    _setcursortype(_NORMALCURSOR);
    gets(loginname);
    _setcursortype(_NOCURSOR);
  } while (strlen(loginname) >= 5);
  setenv("mi_login", loginname, 1);
  sprintf(confname, "%smich%s.txt", EXEPATH, loginname);
  sprintf(intrname, "%sintr%s.txt", UTILPATH, loginname);
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  sprintf(s, "conf. : %s <CR>", confname);
  writescr(PX - 1, PY - 1, SC_NOR, s);
  puttext(1, 1, 80, 25, scr);
  l = strlen(s);
  if (access(confname, F_OK)) {
    tdef = fopen(DEFNAME, "rt");
    rewind(tdef);
    tconf = fopen(confname, "wt");
    rewind(tconf);
    while (fgets(s, 256, tdef) != NULL) {
      fprintf(tconf, "%s", s);
    }
    if (tdef != NULL)
      fclose(tdef);
    tdef = NULL;
    if (tconf != NULL)
      fclose(tconf);
    tconf = NULL;
  }
  gotoxy(PX + l, PY);
  _setcursortype(_NORMALCURSOR);
  scanf("%*[^\n]");
  getchar();
  _setcursortype(_NOCURSOR);
  writescr(PX - 1, PY - 1, SC_NOR, EMPTYLINE);
  puttext(1, 1, 80, 25, scr);
  if (tdef != NULL)
    fclose(tdef);
  if (tconf != NULL)
    fclose(tconf);
}
/*---------------------------------------------------------------------------*/
void main_loop()
{
  ptkeyparsetbl = tkeyparsetbl_mi;
  do
    {
      if (bdir_changed == 1)   /* something changed in current dir */
	dir_changed();
      if (bview_changed == 1)  /* something changed on the screen */
	view_changed();
      key_scan();
    }
  while (lastkey != K_ESC);
}
/*---------------------------------------------------------------------------*/
int modit(const char *path, const struct ffblk *ff)
{
  char apath[256], cmdline[256], dir[256], drive[256], ext[256], name[256];

  strcpy(apath, path);
  fnsplit(path, drive, dir, name, ext);
  strlwr(ext);
  if (!strcmp(".mod", ext))
    {
      modsub(apath);
    }
  if (!strcmp(".mtm", ext))
    {
      modsub(apath);
    }
  if (!strcmp(".s3m", ext))
    {
      modsub(apath);
    }
  if (!strcmp(".xm", ext))
    {
      modsub(apath);
    }
  if (strcmp(ff->ff_name, "XXXXX") == 0)
    return 42;
  return 0;
}
/*---------------------------------------------------------------------------*/
uchr nav_bcol()
{
  uchr b;

  if (curl == 1)
    b = 1;
  else
    b = 0;
  return b;
}
/*---------------------------------------------------------------------------*/
uchr nav_ecol()
{
  uchr b;

  if (curl == NLINS)
    b = 1;
  else
    b = 0;
  return b;
}
/*---------------------------------------------------------------------------*/
uchr nav_bscr()
{
  uchr b;

  if (curc == 0 && curl == 1)
    b = 1;
  else
    b = 0;
  return b;
}
/*---------------------------------------------------------------------------*/
uchr nav_escr()
{
  uchr b;

  if (curc == NCOLS - 1 && curl == NLINS)
    b = 1;
  else
    b = 0;
  return b;
}
/*---------------------------------------------------------------------------*/
uchr nav_btab()
{
  uchr b;

  if (disp0 == 0 && curc == 0 && curl == 1)
    b = 1;
  else
    b = 0;
  return b;
}
/*---------------------------------------------------------------------------*/
uchr nav_etab()
{
  uchr b;

  if (disp0 + curc * NLINS + curl == count)
    b = 1;
  else
    b = 0;
  return b;
}
/*---------------------------------------------------------------------------*/
long pos2i()
{
  return (disp0 + curc * NLINS + curl);
}
/*---------------------------------------------------------------------------*/
void sort_filenames(long first, long last)
{
  tfilename tf;
  long i1, i2;

  for (i1 = first; i1 < last; i1++) {
    for (i2 = first; i2 < last; i2++) {
      if (strcmp(filenames[i2 - 1].fn, filenames[i2].fn) > 0) {
	tf = filenames[i2 - 1];
	filenames[i2 - 1] = filenames[i2];
	filenames[i2] = tf;
      }
    }
  }
}
/*---------------------------------------------------------------------------*/
void strip(char *s)
{
  long i, l;
  char as[256];

  l = strlen(s);
  *as = '\0';
  for (i = 1; i <= l - 2; i++)
    as[i - 1] = s[i];
  as[l - 2] = '\0';
  strcpy(s, as);
}
/*---------------------------------------------------------------------------*/
void view_changed()
{
  bview_changed = 0;
  awindow(SC_X, SC_Y, SC_WI, SC_LE, SC_TI, SC_FT);
  for (ci = 0; ci < NCOLS; ci++) {
    for (li = 1; li <= NLINS; li++) {
      writescr(COL0 + ci * FILENL - 1, LIN0 + li - 1, SC_NOR,
	       "               ");
      writescr(COL0 + ci * FILENL - 1, LIN0 + li - 1,
	       filenames[ci * NLINS + li + disp0 - 1].col,
	       filenames[ci * NLINS + li + disp0 - 1].fn);
    }
  }
  if (filenames[curc * NLINS + curl + disp0 - 1].sel == 1)
    writescr(COL0 + curc * FILENL - 1, LIN0 + curl - 1, SC_CURSEL,
 	     filenames[curc * NLINS + curl + disp0 - 1].fn);
  else
    writescr(COL0 + curc * FILENL - 1, LIN0 + curl - 1, SC_CUR,
	     filenames[curc * NLINS + curl + disp0 - 1].fn);
  puttext(1, 1, 80, 25, scr);
}
/*---------------------------------------------------------------------------*/
void writescr(uchr col, uchr lin, uchr color, char *s)
{
  ushr i, j, l;

  i = lin * 160 + col * 2 + 1;
  j = 1;
  l = strlen(s);
  while (j <= l)
    {
      scr[i - 1] = s[j - 1];
      scr[i] = color;
      i += 2;
      j++;
    }
}
