/* mdriver.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
/*---------------------------------------------------------------------------*/
/* global variables : use */
extern char modext[5];
/*---------------------------------------------------------------------------*/
/* variables */
ushr md_device = 0;
ushr md_mixfreq = 44100;
ushr md_mode = 0;
ushr md_dmabufsize = 8192;
uchr md_numchn = 0;
uchr md_bpm = 125;
ushr numsamples;
driver *firstdriver = NULL, *md_driver;
struct sample samples[MAX_INSTRUMENTS];
static void *sl_fp;
static short sl_old;
static ushr sl_infmt;
static ushr sl_outfmt;
static short sl_buffer[1024];
static int isplaying = 0;
/*---------------------------------------------------------------------------*/
int md_init()
{
  ushr t;

  if (md_device == 0) /* device == autodetect */
    {
      for (t = 1, md_driver = firstdriver; md_driver != NULL; md_driver = md_driver->next, t++)
	{
	  if (md_driver->ispresent())
	    {
	      break;
	    }
	}
      if (md_driver == NULL)
	{
	  mod_error();
	  printf("(md_init)1 md_driver == NULL\n");
	  exit(1);
	}
      md_device = t;
    }
  for (t = 1, md_driver = firstdriver; md_driver != NULL && t != md_device;
       md_driver = md_driver->next, t++);
  {
    if (md_driver == NULL)
      {
	mod_error();
	printf("(md_init)2 md_driver == NULL\n");
	exit(1);
      }
  }
  return (md_driver->init());
}
/*---------------------------------------------------------------------------*/
int md_initsub()
{
  ushr t;

  if (md_device == 0) /* device == autodetect */
    {
      for (t = 1, md_driver = firstdriver; md_driver != NULL; md_driver = md_driver->next, t++)
	{
	  if (md_driver->ispresent())
	    {
	      break;
	    }
	}
      if (md_driver == NULL)
	{
	  mod_error();
	  printf("(md_initsub)1 md_driver == NULL\n");
	  exit(1);
	}
      md_device = t;
    }
  for (t = 1, md_driver = firstdriver; md_driver != NULL && t != md_device;
       md_driver = md_driver->next, t++);
  {
    if (md_driver == NULL)
      {
	mod_error();
	printf("(md_initsub)2 md_driver == NULL\n");
	exit(1);
      }
  }
  return (1);
}
/*---------------------------------------------------------------------------*/
short md_sampleload(FILE * fp, ulng size, ulng reppos, ulng repend, ushr flags)
{
  short result;

  /* record position of sample */
  samples[numsamples].offset = ftell(fp);
  if (!strcmp(modext, ".mod"))
    {
      samples[numsamples].offset += 2;
    }
  /* record size in bytes */
  samples[numsamples++].size = (ushr) size;

  result = md_driver->sampleload(fp, size, reppos, repend, flags);
  return (result);
}
/*---------------------------------------------------------------------------*/
void dummyplay()
{
}

void (*md_player)() = dummyplay;
/*---------------------------------------------------------------------------*/
void md_exit()
{
  md_driver->exit();
}
/*---------------------------------------------------------------------------*/
void md_playstart()
{
  /* safety valve, prevents entering playstart twice */
  if (isplaying)
    {
      return;
    }
  md_driver->playstart();
  isplaying = 1;
}
/*---------------------------------------------------------------------------*/
void md_playstop()
{
  /* safety valve, prevents calling playStop when playstart hasn't been called: */
  if (isplaying)
    {
      isplaying = 0;
      md_driver->playstop();
    }
}
/*---------------------------------------------------------------------------*/
/* creates a linked list */
/* drv_sb -> NULL */
void md_registerdriver(driver * drv)
{
  if (firstdriver == NULL)
    {
      firstdriver = drv;
      drv->next = NULL;
    }
  else
    {
      drv->next = firstdriver;
      firstdriver = drv;
    }
}
/*---------------------------------------------------------------------------*/
void md_registerplayer(void (*player) (void))
{
  md_player = player;
}
/*---------------------------------------------------------------------------*/
void md_sampleunload(short handle)
{
  md_driver->sampleunload(handle);
}
/*---------------------------------------------------------------------------*/
void md_setbpm(uchr bpm)
{
  md_bpm = bpm;
}
/*---------------------------------------------------------------------------*/
void md_update()
{
  if (isplaying)
    {
      md_driver->update();
    }
}
/*---------------------------------------------------------------------------*/
void md_voiceplay(uchr voice, short handle, ulng start, ulng size, ulng reppos, ulng repend, ushr flags)
{
  md_driver->voiceplay(voice, handle, start, size, reppos, repend, flags);
}
/*---------------------------------------------------------------------------*/
void md_voicesetfrequency(uchr voice, ulng frq)
{
  md_driver->voicesetfrequency(voice, frq);
}
/*---------------------------------------------------------------------------*/
void md_voicesetpanning(uchr voice, ulng pan)
{
  md_driver->voicesetpanning(voice, pan);
}
/*---------------------------------------------------------------------------*/
void md_voicesetvolume(uchr voice, uchr vol)
{
  md_driver->voicesetvolume(voice, vol);
}
/*---------------------------------------------------------------------------*/
void sl_init(FILE* fp, ushr infmt, ushr outfmt)
{
  sl_old = 0;
  sl_fp = fp;
  sl_infmt = infmt;
  sl_outfmt = outfmt;
}
/*---------------------------------------------------------------------------*/
void sl_load(void *buffer, ulng length)
{
  char *bptr = buffer;
  short *wptr = buffer;
  ushr stodo;
  int t;

  /* compute number of samples to load */
  if (sl_outfmt & SF_16BITS)
    {
      length >>= 1;
    }
  while (length)
    {
      stodo = (length < 1024) ? length : 1024;
      if (sl_infmt & SF_16BITS)
	{
	  fread(sl_buffer, sizeof(short), stodo, sl_fp);
	  /* assume machine is little endian by default */
	  if (sl_infmt & SF_BIG_ENDIAN)
	    {
	      swab((char *) sl_buffer, (char *) sl_buffer, stodo << 1);
	    }
	}
      else
	{
	  char *s;
	  short *d;

	  fread(sl_buffer, sizeof(char), stodo, sl_fp);
	  s = (char *) sl_buffer;
	  d = sl_buffer;
	  s += stodo;
	  d += stodo;
	  for (t = 0; t < stodo; t++)
	    {
	      s--;
	      d--;
	      *d = (*s) << 8;
	    }
	}
      if (sl_infmt & SF_DELTA)
	{
	  for (t = 0; t < stodo; t++)
	    {
	      sl_buffer[t] += sl_old;
	      sl_old = sl_buffer[t];
	    }
	}
      if ((sl_infmt ^ sl_outfmt) & SF_SIGNED)
	{
	  for (t = 0; t < stodo; t++)
	    {
	      sl_buffer[t] ^= 0x8000;
	    }
	}
      if (sl_outfmt & SF_16BITS)
	{
	  for (t = 0; t < stodo; t++)
	    {
	      *(wptr++) = sl_buffer[t];
	    }
	}
      else
	{
	  for (t = 0; t < stodo; t++)
	    {
	      *(bptr++) = sl_buffer[t] >> 8;
	    }
	}
      length -= stodo;
    }
}
