/* mdma.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
/*---------------------------------------------------------------------------*/
/* variables */
static dma_entry mydma[MAX_DMA] =
{
  /* DMA channel 0 */
  {0x04, 0x00, DMA0_PAGE, DMA0_ADDR, DMA0_CNT,
   DMA1_SNGL, DMA1_MODE, DMA1_CLRFF, 0x48, 0x44},

  /* DMA channel 1 */
  {0x05, 0x01, DMA1_PAGE, DMA1_ADDR, DMA1_CNT,
   DMA1_SNGL, DMA1_MODE, DMA1_CLRFF, 0x49, 0x45},

  /* DMA channel 2 */
  {0x06, 0x02, DMA2_PAGE, DMA2_ADDR, DMA2_CNT,
   DMA1_SNGL, DMA1_MODE, DMA1_CLRFF, 0x4A, 0x46},

  /* DMA channel 3 */
  {0x07, 0x03, DMA3_PAGE, DMA3_ADDR, DMA3_CNT,
   DMA1_SNGL, DMA1_MODE, DMA1_CLRFF, 0x4B, 0x47},

  /* DMA channel 4 */
  {0x04, 0x00, DMA4_PAGE, DMA4_ADDR, DMA4_CNT,
   DMA2_SNGL, DMA2_MODE, DMA2_CLRFF, 0x48, 0x44},

  /* DMA channel 5 */
  {0x05, 0x01, DMA5_PAGE, DMA5_ADDR, DMA5_CNT,
   DMA2_SNGL, DMA2_MODE, DMA2_CLRFF, 0x49, 0x45},

  /* DMA channel 6 */
  {0x06, 0x02, DMA6_PAGE, DMA6_ADDR, DMA6_CNT,
   DMA2_SNGL, DMA2_MODE, DMA2_CLRFF, 0x4A, 0x46},

  /* DMA channel 7 */
  {0x07, 0x03, DMA7_PAGE, DMA7_ADDR, DMA7_CNT,
   DMA2_SNGL, DMA2_MODE, DMA2_CLRFF, 0x4B, 0x47},
};

static ushr dma_selector;
/*---------------------------------------------------------------------------*/
int mdma_start(int channel, void *pc_ptr, ushr size, int type)
{
  uchr cur_mode;
  ushr eaddr, epage, saddr, spage, tcount;
  ulng e_20bit, s_20bit;
  dma_entry *tdma;

  tdma = &mydma[channel]; /* point to this dma data */
  /* convert the pc address to a 20 bit physical address that the DMA controller needs */
  s_20bit = (((int) pc_ptr) - __djgpp_conventional_base);
  e_20bit = s_20bit + size - 1;
  spage = s_20bit >> 16;
  epage = e_20bit >> 16;
  if (spage != epage)
    {
      return 0;
    }
  if (channel >= 4)
    {
      /* if 16-bit xfer, then addr, count & size are divided by 2 */
      s_20bit = s_20bit >> 1;
      e_20bit = e_20bit >> 1;
      size = size >> 1;
    }
  saddr = s_20bit & 0xFFFF;
  tcount = size - 1;
  switch (type)
    {
    case READ_DMA:
      cur_mode = tdma->read;
      break;
    case WRITE_DMA:
      cur_mode = tdma->write;
      break;
    case INDEF_READ:
      cur_mode = tdma->read | 0x10; /* turn on auto init */
      break;
    case INDEF_WRITE:
      cur_mode = tdma->write | 0x10; /* turn on auto init */
      break;
    }
  ENTER_CRITICAL;
  outportb(tdma->single, tdma->dma_disable); /* disable channel */
  outportb(tdma->mode, cur_mode); /* set mode */
  outportb(tdma->clear_ff, 0); /* clear f/f */
  outportb(tdma->addr, saddr & 0xFF); /* LSB */
  outportb(tdma->addr, saddr >> 8); /* MSB */
  outportb(tdma->page, spage); /* page # */
  outportb(tdma->clear_ff, 0); /* clear f/f */
  outportb(tdma->count, tcount & 0x0FF); /* LSB count */
  outportb(tdma->count, tcount >> 8); /* MSB count */
  outportb(tdma->single, tdma->dma_enable); /* enable */
  LEAVE_CRITICAL;
  return 1;
}
/*---------------------------------------------------------------------------*/
ushr mdma_todo(int channel)
{
  ushr creg, val1, val2;

  dma_entry *tdma = &mydma[channel];
  creg = tdma->count;
  ENTER_CRITICAL;
  outportb(tdma->clear_ff, 0xFF);
redo:
  val1 = inportb(creg);
  val1 |= inportb(creg) << 8;
  val2 = inportb(creg);
  val2 |= inportb(creg) << 8;
  val1 -= val2;
  if ((short) val1 > 64)
    {
      goto redo;
    }
  if ((short) val1 < -64)
    {
      goto redo;
    }
  LEAVE_CRITICAL;
  if (channel > 3)
    {
      val2 <<= 1;
    }
  return val2;
}
/*---------------------------------------------------------------------------*/
/* Allocates a dma buffer of 'size' bytes. A quick port of the watcom version, */
/* returns NULL if failed. */
void *mdma_allocmem(ushr size)
{
  static union REGS r;
  ulng p;

  /* allocate TWICE the size of the requested dma buffer.. */
  /* this fixes the 'page-crossing' bug of previous versions */
  r.d.eax = 0x0100; /* DPMI allocate DOS memory */
  r.d.ebx = ((size * 2) + 15) >> 4; /* Number of paragraphs requested */
  int86(0x31, &r, &r);
  if (r.x.cflag) /* Failed */
    {
      return ((ulng) 0);
    }
  dma_selector = r.d.edx;
  /* convert the segment into a linear address */
  p = (__djgpp_conventional_base + ((r.d.eax & 0xFFFF) << 4));
  /* if the first half of the allocated memory crosses a page */
  /* boundary, return the second half which is then guaranteed to be page-continuous */
  if ((p >> 16) != ((p + size - 1) >> 16))
    {
      p += size;
    }
  return (void *)p;
}
/*---------------------------------------------------------------------------*/
void mdma_freemem(void *p)
{
  static union REGS r;

  r.d.eax = 0x0101; /* DPMI free DOS memory */
  r.d.edx = dma_selector; /* base selector */
  int86(0x31, &r, &r);
}
/*---------------------------------------------------------------------------*/
void mdma_stop(int channel)
{
  dma_entry *tdma;

  tdma = &mydma[channel]; /* point to this dma data */
  outportb(tdma->single, tdma->dma_disable); /* disable chan */
}
