/* load_xm.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
/*---------------------------------------------------------------------------*/
/* global variables : use */
/* loader variables */
extern unimod of;
extern FILE *modfp;
extern struct sample samples[MAX_INSTRUMENTS];
/*---------------------------------------------------------------------------*/
/* variables */
xmnote *xmpat;
static xmheader *mh;

loader load_xm =
{
  NULL,
  "XM",
  "v0.4", /* based on this version in MIKMOD */
  xm_init,
  xm_test,
  xm_load,
  xm_cleanup
};
/*---------------------------------------------------------------------------*/
int xm_init()
{
  mh = NULL;
  if (!(mh = callocm(1, sizeof(xmheader))))
    {
      return 0;
    }
  return 1;
}
/*---------------------------------------------------------------------------*/
int xm_load()
{
  int numtrk, p, t, u, v;
  long next;
  instrument *d;
  msample *q;

  /* try to read module header */
  fread(mh->id, 1, 17, modfp);
  fread(mh->songname, 1, 21, modfp);
  fread(mh->trackername, 1, 20, modfp);
  mh->version = fgetc_ushr_l(modfp);
  mh->headersize = fgetc_ulng_l(modfp);
  mh->songlength = fgetc_ushr_l(modfp);
  mh->restart = fgetc_ushr_l(modfp);
  mh->numchn = fgetc_ushr_l(modfp);
  mh->numpat = fgetc_ushr_l(modfp);
  mh->numins = fgetc_ushr_l(modfp);
  mh->flags = fgetc_ushr_l(modfp);
  mh->tempo = fgetc_ushr_l(modfp);
  mh->bpm = fgetc_ushr_l(modfp);
  fgetc_uchrs(mh->orders, 256, modfp);
  if (feof(modfp))
    {
      mod_error();
      printf("(xm_load)1 feof(modfp)\n");
      return 0;
    }
  /* set module variables */
  of.initspeed = mh->tempo;
  of.inittempo = mh->bpm;
  of.modtype = dupstr(mh->trackername, 20);
  of.numchn = mh->numchn;
  of.numpat = mh->numpat;
  of.numtrk = (ushr)of.numpat * of.numchn; /* get number of channels */
  of.songname = dupstr(mh->songname, 20); /* make a cstr of songname */
  of.numpos = mh->songlength; /* copy the songlength */
  of.reppos = mh->restart;
  of.numins = mh->numins;
  of.flags |= UF_XMPERIODS;
  if (mh->flags & 1) of.flags |= UF_LINEAR;
  memcpy(of.positions, mh->orders, 256);
  of.numpat = 0;
  for (t = 0; t < of.numpos; t++)
    {
      if (of.positions[t] > of.numpat)
	{
	  of.numpat = of.positions[t];
	}
    }
  of.numpat++;
  if (!alloctracks())
    {
      return 0;
    }
  if (!allocpatterns())
    {
      return 0;
    }
  numtrk = 0;
  for (t = 0; t < mh->numpat; t++)
    {
      xmpatheader ph;
      ph.size = fgetc_ulng_l(modfp);
      ph.packing = fgetc(modfp);
      ph.numrows = fgetc_ushr_l(modfp);
      ph.packsize = fgetc_ushr_l(modfp);
      of.pattrows[t] = ph.numrows;
      /* Gr8.. when packsize is 0, don't try to load a pattern.. it's empty. */
      /* This bug was discovered thanks to Khyron's module.. */
      if (!(xmpat = callocm(ph.numrows * of.numchn, sizeof(xmnote))))
	{
	  return 0;
	}
      if (ph.packsize > 0)
	{
	  for (u = 0; u < ph.numrows; u++)
	    {
	      for(v = 0; v < of.numchn; v++)
		{
		  xm_readnote(&xmpat[(v * ph.numrows) + u]);
		}
	    }
	}
      for (v = 0; v < of.numchn; v++)
	{
	  of.tracks[numtrk++] = xm_convert(&xmpat[v * ph.numrows], ph.numrows);
	}
      free(xmpat);
    }
  if (!allocinstruments())
    {
      return 0;
    }
  d = of.instruments;
  for (t = 0; t < of.numins; t++)
    {
      xminstheader ih;
      /* read instrument header */
      ih.size = fgetc_ulng_l(modfp);
      fread(ih.name, 1, 22, modfp);
      ih.type = fgetc(modfp);
      ih.numsmp = fgetc_ushr_l(modfp);
      ih.ssize = fgetc_ulng_l(modfp);
      d->insname = dupstr(ih.name, 22);
      d->numsmp = ih.numsmp;
      if (!allocsamples(d))
	{
	  return 0;
	}
      if (ih.numsmp > 0)
	{
	  xmpatchheader pth;
	  xmwavheader wh;
	  fgetc_uchrs(pth.what, 96, modfp);
	  fgetc_uchrs(pth.volenv, 48, modfp);
	  fgetc_uchrs(pth.panenv, 48, modfp);
	  pth.volpts = fgetc(modfp);
	  pth.panpts = fgetc(modfp);
	  pth.volsus = fgetc(modfp);
	  pth.volbeg = fgetc(modfp);
	  pth.volend = fgetc(modfp);
	  pth.pansus = fgetc(modfp);
	  pth.panbeg = fgetc(modfp);
	  pth.panend = fgetc(modfp);
	  pth.volflg = fgetc(modfp);
	  pth.panflg = fgetc(modfp);
	  pth.vibflg = fgetc(modfp);
	  pth.vibsweep = fgetc(modfp);
	  pth.vibdepth = fgetc(modfp);
	  pth.vibrate = fgetc(modfp);
	  pth.volfade = fgetc_ushr_l(modfp);
	  fgetc_ushr_ls(pth.reserved, 11, modfp);
	  memcpy(d->samplenumber, pth.what, 96);
	  d->volfade = pth.volfade;
	  memcpy(d->volenv, pth.volenv, 24);
	  d->volflg = pth.volflg;
	  d->volsus = pth.volsus;
	  d->volbeg = pth.volbeg;
	  d->volend = pth.volend;
	  d->volpts = pth.volpts;
	  /* scale volume envelope: */
	  for(p = 0; p < 12; p++)
	    {
	      d->volenv[p].val <<= 2;
	    }
	  memcpy(d->panenv, pth.panenv, 24);
	  d->panflg = pth.panflg;
	  d->pansus = pth.pansus;
	  d->panbeg = pth.panbeg;
	  d->panend = pth.panend;
	  d->panpts = pth.panpts;
	  /* scale panning envelope: */
	  for (p = 0; p < 12; p++)
	    {
	      d->panenv[p].val <<= 2;
	    }
	  next = 0;
	  for (u = 0; u < ih.numsmp; u++)
	    {
	      q = &d->samples[u];
	      wh.length = fgetc_ulng_l(modfp);
	      wh.loopstart = fgetc_ulng_l(modfp);
	      wh.looplength = fgetc_ulng_l(modfp);
	      wh.volume = fgetc(modfp);
	      wh.finetune = fgetc(modfp);
	      wh.type = fgetc(modfp);
	      if (wh.type == 4)
		{
		  samples[t].type = 1; /* 16-bits samples */
		}
	      else
		{
		  samples[t].type = 0; /* 8-bits sample */
		}
	      wh.panning = fgetc(modfp);
	      wh.relnote = fgetc(modfp);
	      wh.reserved = fgetc(modfp);
	      fread(wh.samplename, 1, 22, modfp);
	      q->samplename = dupstr(wh.samplename, 22);
	      q->length = wh.length;
	      q->loopstart = wh.loopstart;
	      q->loopend = wh.loopstart+wh.looplength;
	      q->volume = wh.volume;
	      q->c2spd = wh.finetune+128;
	      q->transpose = wh.relnote;
	      q->panning = wh.panning;
	      q->seekpos = next;
	      if (wh.type & 0x10)
		{
		  q->length >>= 1;
		  q->loopstart >>= 1;
		  q->loopend >>= 1;
		}
	      next += wh.length;
	      q->flags |= SF_OWNPAN;
	      if (wh.type & 0x3)
		{
		  q->flags |= SF_LOOP;
		}
	      if (wh.type & 0x2)
		{
		  q->flags |= SF_BIDI;
		}
	      if (wh.type & 0x10)
		{
		  q->flags |= SF_16BITS;
		}
	      q->flags |= SF_DELTA;
	      q->flags |= SF_SIGNED;
	    }
	  for (u = 0; u < ih.numsmp; u++)
	    {
	      d->samples[u].seekpos += ftell(modfp);
	    }
	  fseek(modfp, next, SEEK_CUR);
	}
      d++;
    }
  return 1;
}
/*---------------------------------------------------------------------------*/
int xm_test()
{
  char id[17];

  if (!fread(id, 17, 1, modfp))
    {
      return 0;
    }
  if (!memcmp(id, "Extended Module: ", 17))
    {
      return 1;
    }
  return 0;
}
/*---------------------------------------------------------------------------*/
uchr *xm_convert(xmnote *xmtrack, ushr rows)
{
  uchr dat, eff, ins, note, vol;
  int t;

  unireset();
  for (t = 0; t < rows; t++)
    {
      note = xmtrack->note;
      ins = xmtrack->ins;
      vol = xmtrack->vol;
      eff = xmtrack->eff;
      dat = xmtrack->dat;
      if (note != 0)
	{
	  uninote(note - 1);
	}
      if (ins != 0)
	{
	  uniinstrument(ins - 1);
	}
      switch (vol >> 4)
	{
	case 0x6: /* volslide down */
      if (vol & 0xF)
	{
	  uniwrite(UNI_XMEFFECTA);
	  uniwrite(vol & 0xF);
	}
      break;
	case 0x7: /* volslide up */
	  if (vol & 0xF)
	    {
	      uniwrite(UNI_XMEFFECTA);
	      uniwrite(vol << 4);
	    }
	  break;
	  /* volume-row fine volume slide is compatible with protracker */
	  /* EBx and EAx effects i.e. a zero nibble means DO NOT SLIDE, as */
	  /* opposed to 'take the last sliding value'. */
	case 0x8: /* finevol down */
	  unipteffect(0xE, 0xB0 | (vol & 0xF));
	  break;
	case 0x9: /* finevol up */
	  unipteffect(0xE, 0xA0 | (vol & 0xF));
	  break;
	case 0xA: /* set vibrato speed */
	  unipteffect(0x4, vol << 4);
	  break;
	case 0xB: /* vibrato */
	  unipteffect(0x4, vol & 0xF);
	  break;
	case 0xC: /* set panning */
	  unipteffect(0x8, vol << 4);
	  break;
	case 0xD: /* panning slide left */
	  /* only slide when data nibble not zero: */
	  if (vol & 0xF)
	    {
	      uniwrite(UNI_XMEFFECTP);
	      uniwrite(vol & 0xF);
	    }
	  break;
	case 0xE: /* panning slide right */
	  /* only slide when data nibble not zero: */
	  if (vol & 0xF)
	    {
	      uniwrite(UNI_XMEFFECTP);
	      uniwrite(vol << 4);
	    }
	  break;
	case 0xF: /* tone porta */
	  unipteffect(0x3, vol << 4);
	  break;
	default:
	  if (vol >= 0x10 && vol <= 0x50)
	    {
	      unipteffect(0xC, vol - 0x10);
	    }
	}
      switch (eff)
	{
	case 'G' - 55: /* G - set global volume */
	  break;
	case 'H' - 55: /* H - global volume slide */
	  break;
	case 'K' - 55: /* K - keyoff */
	  uninote(96);
	  break;
	case 'L' - 55: /* L - set envelope position */
	  break;
	case 'P' - 55: /* P - panning slide */
	  uniwrite(UNI_XMEFFECTP);
	  uniwrite(dat);
	  break;
	case 'R' - 55: /* R - multi retrig note */
	  uniwrite(UNI_S3MEFFECTQ);
	  uniwrite(dat);
	  break;
	case 'T' - 55:
	  unipteffect(0x6, dat);
	  break;
	case 'X' - 55:
	  if ((dat >> 4) == 1)
	    { /* X1 extra fine porta up */
	    }
	  else
	    { /* X2 extra fine porta down */
	    }
	  break;
	default:
	  if (eff == 0xA)
	    {
	      uniwrite(UNI_XMEFFECTA);
	      uniwrite(dat);
	    }
	  else if (eff <= 0xF)
	    {
	      unipteffect(eff, dat);
	    }
	  break;
	}
      uninewline();
      xmtrack++;
    }
  return unidup();
}
/*---------------------------------------------------------------------------*/
void xm_cleanup()
{
  if (mh != NULL)
    {
      free(mh);
    }
}
/*---------------------------------------------------------------------------*/
void xm_readnote(xmnote *n)
{
  uchr cmp;

  memset(n, 0, sizeof(xmnote));
  cmp = fgetc(modfp);
  if (cmp & 0x80)
    {
      if (cmp & 1)
	{
	  n->note = fgetc(modfp);
	}
      if (cmp & 2)
	{
	  n->ins = fgetc(modfp);
	}
      if (cmp & 4)
	{
	  n->vol = fgetc(modfp);
	}
      if (cmp & 8)
	{
	  n->eff = fgetc(modfp);
	}
      if (cmp & 16)
	{
	  n->dat = fgetc(modfp);
	}
    }
  else
    {
      n->note = cmp;
      n->ins = fgetc(modfp);
      n->vol = fgetc(modfp);
      n->eff = fgetc(modfp);
      n->dat = fgetc(modfp);
    }
}
