/* load_s3m.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
/*---------------------------------------------------------------------------*/
/* global variables : use */
/* loader variables */
extern unimod of;
extern FILE *modfp;
/*---------------------------------------------------------------------------*/
/* variables */
s3mnote *s3mbuf; /* pointer to a complete s3m pattern */
ushr *paraptr; /* parapointer array (see s3m docs) */
static s3mheader *mh;
uchr remap[32];
char s3m_version[] = "Screamtracker 3.xx";

loader load_s3m =
{
  NULL,
  "S3M",
  "v0.2", /* based on this version in MIKMOD */
  s3m_init,
  s3m_test,
  s3m_load,
  s3m_cleanup
};
/*---------------------------------------------------------------------------*/
int s3m_init()
{
  s3mbuf = NULL;
  paraptr = NULL;
  if (!(s3mbuf = mallocm(16 * 64 * sizeof(s3mnote))))
    {
      return 0;
    }
  if (!(mh = callocm(1, sizeof(s3mheader))))
    {
      return 0;
    }
  return 1;
}
/*---------------------------------------------------------------------------*/
int s3m_load()
{
  int t, track = 0, u;
  uchr isused[16], pan[32];
  instrument *d;
  msample *q;

  /* try to read module header */
  fread(mh->songname, 1, 28, modfp);
  mh->t1a = fgetc(modfp);
  mh->type = fgetc(modfp);
  fgetc_uchrs(mh->unused1, 2, modfp);
  mh->ordnum = fgetc_ushr_l(modfp);
  mh->insnum = fgetc_ushr_l(modfp);
  mh->patnum = fgetc_ushr_l(modfp);
  mh->flags = fgetc_ushr_l(modfp);
  mh->tracker = fgetc_ushr_l(modfp);
  mh->fileformat = fgetc_ushr_l(modfp);
  fread(mh->scrm, 1, 4, modfp);
  mh->mastervol = fgetc(modfp);
  mh->initspeed = fgetc(modfp);
  mh->inittempo = fgetc(modfp);
  mh->mastermult = fgetc(modfp);
  mh->ultraclick = fgetc(modfp);
  mh->pantable = fgetc(modfp);
  fgetc_uchrs(mh->unused2, 8, modfp);
  mh->special = fgetc_ushr_l(modfp);
  fgetc_uchrs(mh->channels, 32, modfp);
  if(feof(modfp))
    {
      mod_error();
      printf("(s3m_load)1 feof(modfp)\n");
      return 0;
    }
  /* set module variables */
  of.modtype = strdup(s3m_version);
  of.songname = dupstr(mh->songname, 28); /* make a cstr of songname */
  of.numpat = mh->patnum;
  of.numins = mh->insnum;
  of.initspeed = mh->initspeed;
  of.inittempo = mh->inittempo;
  /* count the number of channels used */
  of.numchn = 0;
  for (t = 0; t < 32; t++)
    {
      remap[t] = 0;
    }
  for (t = 0; t < 16; t++)
    {
      isused[t] = 0;
    }
  /* set a flag for each channel (1 out of of 16) thats being used: */
  for (t = 0; t < 32; t++)
    {
      if (mh->channels[t] < 16)
	{
	  isused[mh->channels[t]] = 1;
	}
    }
  /* give each of them a different number */
  for (t = 0; t < 16; t++)
    {
      if (isused[t])
	{
	  isused[t] = of.numchn;
	  of.numchn++;
	}
    }
  /* build the remap array */
  for (t = 0; t < 32; t++)
    {
      if (mh->channels[t] < 16)
	{
	  remap[t] = isused[mh->channels[t]];
	}
    }
  /* set panning positions */
  for (t = 0; t < 32; t++)
    {
      if(mh->channels[t] < 16)
	{
	  if(mh->channels[t] < 8)
	    {
	      of.panning[remap[t]] = 0x30;
	    }
	  else
	    {
	      of.panning[remap[t]] = 0xC0;
	    }
	}
    }
  of.numtrk = of.numpat * of.numchn;
  /* read the order data */
  fgetc_uchrs(of.positions, mh->ordnum, modfp);
  of.numpos = 0;
  for (t = 0; t < mh->ordnum; t++)
    {
      of.positions[of.numpos] = of.positions[t];
      if (of.positions[t] < 254)
	{
	  of.numpos++;
	}
    }
  if ((paraptr = mallocm((of.numins + of.numpat) * sizeof(ushr))) == NULL)
    {
      return 0;
    }
  /* read the instrument + pattern parapointers */
  fgetc_ushr_ls(paraptr, of.numins + of.numpat, modfp);
  /* printf("pantab %d\n", mh->pantable); */
  if (mh->pantable == 252)
    {
      /* read the panning table */
      fgetc_uchrs(pan, 32, modfp);
      /* set panning positions according to panning table (new for st3.2) */
      for (t = 0; t < 32; t++)
	{
	  if((pan[t] & 0x20) && mh->channels[t] < 16)
	    {
	      of.panning[remap[t]] = (pan[t] & 0xF) << 4;
	    }
	}
    }
  /* now is a good time to check if the header was too short :) */
  if (feof(modfp))
    {
      mod_error();
      printf("(s3m_load)2 feof(modfp)\n");
      return 0;
    }
  if (!allocinstruments())
    {
      return 0;
    }
  d = of.instruments;
  for (t = 0; t < of.numins; t++)
    {
      s3msample s;
      d->numsmp = 1;
      if (!allocsamples(d))
	{
	  return 0;
	}
      q = d->samples;
      /* seek to instrument position */
      fseek(modfp, ((long)paraptr[t]) << 4, SEEK_SET);
      /* and load sample info */
      s.type = fgetc(modfp);
      fread(s.filename, 1, 12, modfp);
      s.memsegh = fgetc(modfp);
      s.memsegl = fgetc_ushr_l(modfp);
      s.length = fgetc_ulng_l(modfp);
      s.loopbeg = fgetc_ulng_l(modfp);
      s.loopend = fgetc_ulng_l(modfp);
      s.volume = fgetc(modfp);
      s.dsk = fgetc(modfp);
      s.pack = fgetc(modfp);
      s.flags = fgetc(modfp);
      s.c2spd = fgetc_ulng_l(modfp);
      fgetc_uchrs(s.unused, 12, modfp);
      fread(s.sampname, 1, 28, modfp);
      fread(s.scrs, 1, 4, modfp);
      if (feof(modfp))
	{
	  mod_error();
	  printf("(s3m_load)3 feof(modfp)\n");
	  return 0;
	}
      d->insname = dupstr(s.sampname, 28);
      q->c2spd = s.c2spd;
      q->length = s.length;
      q->loopstart = s.loopbeg;
      q->loopend = s.loopend;
      q->volume = s.volume;
      q->seekpos = (((long)s.memsegh) << 16 | s.memsegl) << 4;
      q->flags = 0;
      if (s.flags & 1)
	{
	  q->flags |= SF_LOOP;
	}
      if (s.flags & 4)
	{
	  q->flags |= SF_16BITS;
	}
      if (mh->fileformat == 1)
	{
	  q->flags |= SF_SIGNED;
	}
      /* DON'T load sample if it doesn't have the SCRS tag */
      if (memcmp(s.scrs, "SCRS", 4) != 0)
	{
	  q->length = 0;
	}
      d++;
    }
  if (!alloctracks())
    {
      return 0;
    }
  if (!allocpatterns())
    {
      return 0;
    }
  for (t = 0; t < of.numpat; t++)
    {
      /* seek to pattern position ( + 2 skip pattern length ) */
      fseek(modfp, (((long)paraptr[of.numins + t]) << 4) + 2, SEEK_SET);
      if (!s3m_readpattern())
	{
	  return 0;
	}
      for (u = 0; u < of.numchn; u++)
	{
	  if (!(of.tracks[track++] = s3m_converttrack(&s3mbuf[u * 64])))
	    {
	      return 0;
	    }
	}
    }
  return 1;
}
/*---------------------------------------------------------------------------*/
int s3m_readpattern()
{
  int ch, flag, row = 0;
  s3mnote dummy, *n;

  /* clear pattern data */
  memset(s3mbuf, 255, 16 * 64 * sizeof(s3mnote));
  while (row < 64)
    {
      flag = fgetc(modfp);
      if (flag == EOF)
	{
	  mod_error();
	  printf("(s3m_readpattern) flag == EOF\n");
	  return 0;
	}
      if (flag)
	{
	  ch = flag & 31;
	  if (mh->channels[ch] < 16)
	    {
	      n = &s3mbuf[(64U * remap[ch]) + row];
	    }
	  else
	    {
	      n = &dummy;
	    }
	  if (flag & 32)
	    {
	      n->note = fgetc(modfp);
	      n->ins = fgetc(modfp);
	    }
	  if (flag & 64)
	    {
	      n->vol = fgetc(modfp);
	    }
	  if (flag & 128)
	    {
	      n->cmd = fgetc(modfp);
	      n->inf = fgetc(modfp);
	    }
	}
      else row++;
    }
  return 1;
}
/*---------------------------------------------------------------------------*/
int s3m_test()
{
  char id[4];

  fseek(modfp, 0x2C, SEEK_SET);
  if (!fread(id, 4, 1, modfp))
    {
      return 0;
    }
  if (!memcmp(id, "SCRM", 4))
    {
      return 1;
    }
  return 0;
}
/*---------------------------------------------------------------------------*/
uchr *s3m_converttrack(s3mnote *tr)
{
  int t;
  uchr cmd, hi, inf, ins, lo, note, vol;

  unireset();
  for (t = 0 ; t < 64; t++)
    {
      note = tr[t].note;
      ins = tr[t].ins;
      vol = tr[t].vol;
      cmd = tr[t].cmd;
      inf = tr[t].inf;
      lo = inf & 0xF;
      hi = inf >> 4;
      if (ins != 0 && ins != 255)
	{
	  uniinstrument(ins - 1);
	}
      if (note != 255)
	{
	  if (note == 254)
	    {
	      unipteffect(0xC, 0); /* <- note off command */
	    }
	  else
	    {
	      uninote(((note >> 4) * 12) + (note & 0xF)); /* <- normal note */
	    }
	}
      if (vol < 255)
	{
	  unipteffect(0xC, vol);
	}
      if (cmd != 255)
	{
	  switch(cmd)
	    {
	    case 1: /* Axx set speed to xx */
	      uniwrite(UNI_S3MEFFECTA);
	      uniwrite(inf);
	      break;
	    case 2: /* Bxx position jump */
	      unipteffect(0xB, inf);
	      break;
	    case 3: /* Cxx patternbreak to row xx */
	      unipteffect(0xD, inf);
	      break;
	    case 4: /* Dxy volumeslide */
	      uniwrite(UNI_S3MEFFECTD);
	      uniwrite(inf);
	      break;
	    case 5: /* Exy toneslide down */
	      uniwrite(UNI_S3MEFFECTE);
	      uniwrite(inf);
	      break;
	    case 6: /* Fxy toneslide up */
	      uniwrite(UNI_S3MEFFECTF);
	      uniwrite(inf);
	      break;
	    case 7: /* Gxx Tone portamento, speed xx */
	      unipteffect(0x3, inf);
	      break;
	    case 8: /* Hxy vibrato */
	      unipteffect(0x4, inf);
	      break;
	    case 9: /* Ixy tremor, ontime x, offtime y */
	      uniwrite(UNI_S3MEFFECTI);
	      uniwrite(inf);
	      break;
	    case 0xA: /* Jxy arpeggio */
	      unipteffect(0x0, inf);
	      break;
	    case 0xB: /* Kxy Dual command H00 & Dxy */
	      unipteffect(0x4, 0);
	      uniwrite(UNI_S3MEFFECTD);
	      uniwrite(inf);
	      break;
	    case 0xC: /* Lxy Dual command G00 & Dxy */
	      unipteffect(0x3, 0);
	      uniwrite(UNI_S3MEFFECTD);
	      uniwrite(inf);
	      break;
	    case 0xF: /* Oxx set sampleoffset xx00h */
	      unipteffect(0x9, inf);
	      break;
	    case 0x11: /* Qxy Retrig (+ volumeslide) */
	      uniwrite(UNI_S3MEFFECTQ);
	      uniwrite(inf);
	      break;
	    case 0x12: /* Rxy tremolo speed x, depth y */
	      unipteffect(0x6, inf);
	      break;
	    case 0x13: /* Sxx special commands */
	      switch (hi)
		{
		case 0: /* S0x set filter */
		  unipteffect(0xE, 0x00 | lo);
		  break;
		case 1: /* S1x set glissando control */
		  unipteffect(0xE, 0x30 | lo);
		  break;
		case 2: /* S2x set finetune */
		  unipteffect(0xE, 0x50 | lo);
		  break;
		case 3: /* S3x set vibrato waveform */
		  unipteffect(0xE, 0x40 | lo);
		  break;
		case 4: /* S4x set tremolo waveform */
		  unipteffect(0xE, 0x70 | lo);
		  break;
		case 8: /* S8x set panning position */
		  unipteffect(0xE, 0x80 | lo);
		  break;
		case 0xB: /* SBx pattern loop */
		  unipteffect(0xE, 0x60 | lo);
		  break;
		case 0xC: /* SCx notecut */
		  unipteffect(0xE, 0xC0 | lo);
		  break;
		case 0xD: /* SDx notedelay */
		  unipteffect(0xE, 0xD0 | lo);
		  break;
		case 0xE: /* SDx patterndelay */
		  unipteffect(0xE, 0xE0 | lo);
		  break;
		}
	      break;
	    case 0x14: /* Txx tempo */
	      if (inf > 0x20)
		{
		  uniwrite(UNI_S3MEFFECTT);
		  uniwrite(inf);
		}
	      break;
	    case 0x18: /* Xxx amiga command 8xx */
	      unipteffect(0x8, inf);
	      break;
	    }
	}
      uninewline();
    }
  return unidup();
}
/*---------------------------------------------------------------------------*/
void s3m_cleanup()
{
  if (s3mbuf != NULL)
    {
      free(s3mbuf);
    }
  if (paraptr != NULL)
    {
      free(paraptr);
    }
  if (mh != NULL)
    {
      free(mh);
    }
}
