/* load_mtm.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
/*---------------------------------------------------------------------------*/
/* global variables : use */
/* loader variables */
extern unimod of;
extern FILE *modfp;
extern ushr finetune[16];
/*---------------------------------------------------------------------------*/
/* variables */
static mtmheader *mh;
mtmnote *mtmtrk;
ushr pat[32];
char mtm_version[] = "MTM";

loader load_mtm =
{
  NULL,
  "MTM",
  "v0.1", /* based on this version in MIKMOD */
  mtm_init,
  mtm_test,
  mtm_load,
  mtm_cleanup
};
/*---------------------------------------------------------------------------*/
int mtm_init()
{
  mtmtrk = NULL;
  mh = NULL;

  if (!(mtmtrk = callocm(64, sizeof(mtmnote))))
    {
      return 0;
    }
  if (!(mh = callocm(1, sizeof(mtmheader))))
    {
      return 0;
    }
  return 1;
}
/*---------------------------------------------------------------------------*/
int mtm_load()
{
  int t, u;
  instrument *d;
  msample *q;
  mtmsample s;

  /* try to read module header */
  fread(mh->id, 1, 3, modfp);
  mh->version = fgetc(modfp);
  fread(mh->songname, 1, 20, modfp);
  mh->numtracks = fgetc_ushr_l(modfp);
  mh->lastpattern = fgetc(modfp);
  mh->lastorder = fgetc(modfp);
  mh->commentsize = fgetc_ushr_l(modfp);
  mh->numsamples = fgetc(modfp);
  mh->attribute = fgetc(modfp);
  mh->beatspertrack = fgetc(modfp);
  mh->numchannels = fgetc(modfp);
  fgetc_uchrs(mh->panpos, 32, modfp);
  if (feof(modfp))
    {
      mod_error();
      printf("(mtm_load)1 feof(modfp)\n");
      return 0;
    }
  /* set module variables */
  of.initspeed = 6;
  of.inittempo = 125;
  of.modtype = strdup(mtm_version);
  of.numchn = mh->numchannels;
  of.numtrk = mh->numtracks + 1; /* get number of channels */
  of.songname = dupstr(mh->songname, 20); /* make a cstr of songname */
  of.numpos = mh->lastorder + 1; /* copy the songlength */
  of.numpat = mh->lastpattern + 1;
  for (t = 0; t < 32; t++)
    {
      of.panning[t] = mh->panpos[t] << 4;
    }
  of.numins = mh->numsamples;
  if (!allocinstruments())
    {
      return 0;
    }
  d = of.instruments;
  for (t = 0; t < of.numins; t++)
    {
      d->numsmp = 1;
      if (!allocsamples(d))
	{
	  return 0;
	}
      q = d->samples;
      /* try to read sample info */
      fread(s.samplename, 1, 22, modfp);
      s.length = fgetc_ulng_l(modfp);
      s.reppos = fgetc_ulng_l(modfp);
      s.repend = fgetc_ulng_l(modfp);
      s.finetune = fgetc(modfp);
      s.volume = fgetc(modfp);
      s.attribute = fgetc(modfp);
      if (feof(modfp))
	{
	  mod_error();
	  printf("(mtm_load)2 feof(modfp)\n");
	  return 0;
	}
      d->insname = dupstr(s.samplename, 22);
      q->seekpos = 0;
      q->c2spd = finetune[s.finetune];
      q->length = s.length;
      q->loopstart = s.reppos;
      q->loopend = s.repend;
      q->volume = s.volume;
      q->flags = 0;
      if (s.repend - s.reppos > 2)
	{
	  q->flags |= SF_LOOP; /* <- 1.00 bugfix */
	}
      if (s.attribute & 1)
	{
	  /* if the sample is 16-bits, convert the length and replen byte-values */
	  /* into sample-values */
	  q->flags |= SF_16BITS;
	  q->length >>= 1;
	  q->loopstart >>= 1;
	  q->loopend >>= 1;
	}
      d++;
    }
  fgetc_uchrs(of.positions, 128, modfp);
  if (feof(modfp))
    {
      mod_error();
      printf("(mtm_load)3 feof(modfp)\n");
      return 0;
    }
  if (!alloctracks())
    {
      return 0;
    }
  if (!allocpatterns())
    {
      return 0;
    }
  of.tracks[0] = mtm_convert();	/* track 0 is empty */
  for (t = 1; t < of.numtrk; t++)
    {
      int s;
      for (s = 0; s < 64; s++)
	{
	  mtmtrk[s].a = fgetc(modfp);
	  mtmtrk[s].b = fgetc(modfp);
	  mtmtrk[s].c = fgetc(modfp);
	}
      if (feof(modfp))
	{
	  mod_error();
	  printf("(mtm_load)4 feof(modfp)\n");
	  return 0;
	}
      if (!(of.tracks[t] = mtm_convert()))
	{
	  return 0;
	}
    }
  for (t = 0; t < of.numpat; t++)
    {
      fgetc_ushr_ls(pat, 32, modfp);
      for (u = 0; u < of.numchn; u++)
	{
	  of.patterns[((long) t * of.numchn) + u] = pat[u];
	}
    }
  /* read comment field */
  if (!readcomment(mh->commentsize))
    {
      return 0;
    }
  return 1;
}
/*---------------------------------------------------------------------------*/
int mtm_test()
{
  char id[3];

  if (!fread(id, 3, 1, modfp))
    {
      return 0;
    }
  if (!memcmp(id, "MTM", 3))
    {
      return 1;
    }
  return 0;
}
/*---------------------------------------------------------------------------*/
uchr* mtm_convert()
{
  uchr a, b, c, dat, eff, inst, note;
  int t;

  unireset();
  for (t = 0; t < 64; t++)
    {
      a = mtmtrk[t].a;
      b = mtmtrk[t].b;
      c = mtmtrk[t].c;
      inst = ((a & 0x3) << 4) | (b >> 4);
      note = a >> 2;
      eff = b & 0xF;
      dat = c;
      if (inst != 0)
	{
	  uniinstrument(inst - 1);
	}
      if (note != 0)
	{
	  uninote(note + 24);
	}
      /* mtm bug bugfix : when the effect is volslide, slide-up _always_ overrides slide-dn */
      if (eff == 0xA && dat & 0xF0)
	{
	  dat &= 0xF0;
	}
      unipteffect(eff, dat);
      uninewline();
    }
  return unidup();
}
/*---------------------------------------------------------------------------*/
void mtm_cleanup()
{
  if (mtmtrk != NULL)
    {
      free(mtmtrk);
    }
  if (mh != NULL)
    {
      free(mh);
    }
}
