/* load_mod.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
/*---------------------------------------------------------------------------*/
/* global variables : use */
/* loader variables */
extern unimod of;
extern FILE *modfp;
extern ushr finetune[16];
/*---------------------------------------------------------------------------*/
/* variables */
char fasttracker[] = "Fasttracker";
char ins15tracker[] = "15-instrument";
char oktalyzer[] = "Oktalyzer";
char protracker[] = "Protracker";
char startracker[] = "Startracker";
char taketracker[] = "TakeTracker";

modtype modtypes[] =
{
  "M.K.", 4, protracker, /* protracker 4 channel */
  "M!K!", 4, protracker, /* protracker 4 channel */
  "FLT4", 4, startracker, /* startracker 4 channel */
  "4CHN", 4, fasttracker, /* fasttracker 4 channel */
  "6CHN", 6, fasttracker, /* fasttracker 6 channel */
  "8CHN", 8, fasttracker, /* fasttracker 8 channel */
  "CD81", 8, oktalyzer,	/* atari oktalyzer 8 channel */
  "OKTA", 8, oktalyzer,	/* atari oktalyzer 8 channel */
  "16CN", 16, taketracker, /* taketracker 16 channel */
  "32CN", 32, taketracker, /* taketracker 32 channel */
  "    ", 4, ins15tracker /* 15-instrument 4 channel */
};

ushr npertab[60] =
{
  /* -> Tuning 0 */
  1712, 1616, 1524, 1440, 1356, 1280, 1208, 1140, 1076, 1016, 960, 906,
  856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480, 453,
  428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, 226,
  214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, 113,
  107, 101, 95, 90, 85, 80, 75, 71, 67, 63, 60, 56
};

static moduleheader *mh; /* raw as-is module header */
static modnote *patbuf;

loader load_mod =
{
  NULL,
  "MOD",
  "v0.11", /* based on this version in MIKMOD */
  mod_init,
  mod_test,
  mod_load,
  mod_cleanup
};
/*---------------------------------------------------------------------------*/
/* loads all patterns of a modfile and converts them into the 3 byte format */
int ml_loadpatterns()
{
  int t, s, tracks = 0;

  if (!allocpatterns())
    {
      return 0;
    }
  if (!alloctracks())
    {
      return 0;
    }
  /* allocate temporary buffer for loading and converting the patterns */
  if (!(patbuf = callocm(64U * of.numchn, sizeof(modnote))))
    {
      return 0;
    }
  for (t = 0; t < of.numpat; t++)
    {
      /* load the pattern into the temp buffer and convert it */
      for (s = 0; s < (64U * of.numchn); s++)
	{
	  patbuf[s].a = fgetc(modfp);
	  patbuf[s].b = fgetc(modfp);
	  patbuf[s].c = fgetc(modfp);
	  patbuf[s].d = fgetc(modfp);
	}
      for (s = 0; s < of.numchn; s++)
	{
	  if (!(of.tracks[tracks++] = converttrack(patbuf + s)))
	    {
	      return 0;
	    }
	}
    }
  return 1;
}
/*---------------------------------------------------------------------------*/
int mod_init()
{
  patbuf = NULL;
  if (!(mh = callocm(1, sizeof(moduleheader))))
    {
      return 0;
    }
  return 1;
}
/*---------------------------------------------------------------------------*/
int mod_load()
{
  int t, modtype;
  instrument *d; /* new sampleinfo structure */
  msample *q;
  msampinfo *s; /* old module sampleinfo */

  /* try to read module header */
  fread(mh->songname, 1, 20, modfp);
  for (t = 0; t < 31; t++)
    {
      s = &mh->samples[t];
      fread(s->samplename, 1, 22, modfp);
      s->length = fgetc_ushr_m(modfp);
      s->finetune = fgetc(modfp);
      s->volume = fgetc(modfp);
      s->reppos = fgetc_ushr_m(modfp);
      s->replen = fgetc_ushr_m(modfp);
    }
  mh->songlength = fgetc(modfp);
  mh->magic1 = fgetc(modfp);
  fgetc_uchrs(mh->positions, 128, modfp);
  fgetc_uchrs(mh->magic2, 4, modfp);
  if (feof(modfp))
    {
      mod_error();
      printf("(mod_load) feof(modfp)\n");
      return 0;
    }
  /* find out which ID string */
  for (modtype = 0; modtype < 10; modtype++)
    {
      if (!memcmp(mh->magic2, modtypes[modtype].id, 4))
	{
	  break;
	}
    }
  if (modtype == 10) /* unknown modtype */
    {
      mod_error();
      printf("(mod_load) modtype == 10\n");
      return 0;
    }
  /* set module variables */
  of.initspeed = 6;
  of.inittempo = 125;
  of.numchn = modtypes[modtype].channels; /* get number of channels */
  of.modtype = strdup(modtypes[modtype].name); /* get ascii type of mod */
  of.songname = dupstr(mh->songname, 20); /* make a cstr of songname */
  of.numpos = mh->songlength;	/* copy the songlength */
  memcpy(of.positions, mh->positions, 128); /* copy the position array */
  /* count the number of patterns */
  of.numpat = 0;
  for (t = 0; t < 128; t++)
    { /* <-- BUGFIX... have to check ALL positions */
      if (of.positions[t] > of.numpat)
	{
	  of.numpat = of.positions[t];
	}
    }
  of.numpat++;
  of.numtrk = of.numpat * of.numchn;
  /* finally, init the sampleinfo structures */
  of.numins = 31;
  if (!allocinstruments())
    {
      printf("(mod_load) !allocinstruments()\n");
      return 0;
    }
  s = mh->samples; /* init source pointer */
  d = of.instruments; /* init dest pointer */
  for (t = 0; t < of.numins; t++)
    {
      d->numsmp = 1;
      if (!allocsamples(d))
	{
	  printf("(mod_load) !allocsamples(d)\n");
	  return 0;
	}
      q = d->samples;
      /* convert the samplename */
      d->insname = dupstr(s->samplename, 22);
      /* init the sampleinfo variables and convert the size pointers to longword format */
      q->c2spd = finetune[s->finetune & 0xF];
      q->volume = s->volume;
      q->loopstart = (ulng) s->reppos << 1;
      q->loopend = q->loopstart + ((ulng) s->replen << 1);
      q->length = (ulng) s->length << 1;
      q->seekpos = 0;
      q->flags = SF_SIGNED;
      if (s->replen > 1)
	{
	  q->flags |= SF_LOOP;
	}
      /* fix replen if repend > length */
      if (q->loopend > q->length)
	{
	  q->loopend = q->length;
	}
      s++; /* point to next source sampleinfo */
      d++; /* point to next destiny sampleinfo */
    }
  if (!ml_loadpatterns())
    {
      printf("(mod_load) !ml_loadpatterns()\n");
      return 0;
    }
  return 1;
}
/*---------------------------------------------------------------------------*/
int mod_test()
{
  int t;
  char id[4];

  fseek(modfp, MODULEHEADERSIZE - 4, SEEK_SET);
  if (!fread(id, 4, 1, modfp))
    {
      printf("(mod_test) !fread(id, 4, 1, modfp)\n");
      return 0;
    }
  /* find out which ID string */
  for (t = 0; t < 10; t++)
    {
      if (!memcmp(id, modtypes[t].id, 4))
	{
	  return 1;
	}
    }
  /* this is not a real bug */
  printf("(mod_test) failed\n");
  printf("some nasty people overwrite location 1080d\n");
  printf("I don't care :-)\n");
  return 1;
}
/*---------------------------------------------------------------------------*/
uchr* converttrack(modnote * n)
{
  int t;

  unireset();
  for (t = 0; t < 64; t++)
    {
      convertnote(n);
      uninewline();
      n += of.numchn;
    }
  return unidup();
}
/*---------------------------------------------------------------------------*/
/* extract the various information */
/* from the 4 bytes that make up a single note */
void convertnote(modnote * n)
{
  uchr effdat, effect, instrument, note;
  ushr period;

  instrument = (n->a & 0x10) | (n->c >> 4);
  period = (((ushr) n->a & 0xF) << 8) + n->b;
  effect = n->c & 0xF;
  effdat = n->d;
  /* convert the period to a note number */
  note = 0;
  if (period != 0)
    {
      for (note = 0; note < 60; note++)
	{
	  if (period >= npertab[note])
	    {
	      break;
	    }
	}
      note++;
      if (note == 61)
	{
	  note = 0;
	}
    }
  if (instrument != 0)
    {
      uniinstrument(instrument - 1);
    }
  if (note != 0)
    {
      uninote(note + 23);
    }
  unipteffect(effect, effdat);
}
/*---------------------------------------------------------------------------*/
void mod_cleanup()
{
  if (mh != NULL)
    {
      free(mh);
    }
  if (patbuf != NULL)
    {
      free(patbuf);
    }
}
