/* keyboard.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
/*---------------------------------------------------------------------------*/
/* global variables : declaration */
int lastkey;
int esc_hit = 0;
tkeyparse **ptkeyparsetbl = NULL; /* pointer to current key parse table */
/*---------------------------------------------------------------------------*/
void key_scan()
{
  if (kbhit())
    {
      key_parse(lastkey = key_int());
    }
}
/*---------------------------------------------------------------------------*/
/* translates a key press event to an integer value */
/* returns regular keys in range 0..127 and extended keys in range 128..255 */
/* returns -1 on error */
int key_int()
{
  int i;

  i = getch();
  if (i == 0)
    {
      i = getch();
      i += 128;
    }
  return i;
}
/*---------------------------------------------------------------------------*/
void key_parse(int akey)
{
  int i = 0;
  tkeyparse* ptk;
  void (*akey_handler)() = NULL;

  while (ptk = ptkeyparsetbl[i++])
    {
      if ((ptk->key == lastkey) || (ptk->key == -1))
	/* key found or chain through */
	{
	  akey_handler = ptk->key_handler;
	  break;
	}
    }
  if (akey_handler)
    {
      (*akey_handler)();
    }
}
