/* hear.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */

/* depends for some routines on the settings in the [sound]-section of the config-file */
/* only mono wav-files are supported */
/* the mod-player needs the BLASTER-environment variable set */
/* oh yeah, this is only tested with 100% SoundBlaster compatibles */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
#include <allegro.h>
/*---------------------------------------------------------------------------*/
/* global variables : use */
/* declare external loaders */
extern loader load_mod;
extern loader load_mtm;
extern loader load_s3m;
extern loader load_xm;
/* driver variables */
extern ushr md_device;
extern ushr md_mixfreq;
extern ushr md_dmabufsize;
extern ushr md_mode;
extern uchr md_numchn;
/* external driver */
extern driver drv_sb; /* soundblaster DSP driver */

extern uchr mp_bpm; /* beats-per-minute speed */
extern int mp_loop;
extern uchr mp_volume;
/*---------------------------------------------------------------------------*/
/* variables */
int _crt0_startup_flags = _CRT0_FLAG_NEARPTR;
uchr confname[256], intrname[256], loginname[256];
/*---------------------------------------------------------------------------*/
void main(int argc, char *argv[])
{
  char d[MAXDRIVE], p[MAXDIR], f[MAXFILE], e[MAXEXT], *s;
  int choice = 2; /* choice default to RAW/SAM */

  if (argc != 2)
    {
      printf("\nHEAR v0.70 (copywrong) 1997-1998 by Edward Boone\n");
      printf("usage : hear filename.[MID|MOD|MTM|S3M|VOC|WAV|XM]\n");
      exit(1);
    }
  s = getenv("mi_login");
  if (!s) /* mi_login is not known if you run this program as a standalone program */
    {
      strcpy(confname, DEFNAME);
      strcpy(intrname, INTRNAME);
    }
  else
    {
      strcpy(loginname, s);
      sprintf(confname, "%smich%s.txt", EXEPATH, loginname);
      sprintf(intrname, "%sintr%s.txt", UTILPATH, loginname);
    }
  fnsplit(argv[1], d, p, f, e);
  strlwr(e);
  if (!strcmp(e, ".mid")) choice = 0;
  else if (!strcmp(e, ".mod")) choice = 1;
  else if (!strcmp(e, ".mtm")) choice = 1;
  else if (!strcmp(e, ".s3m")) choice = 1;
  else if (!strcmp(e, ".voc")) choice = 2;
  else if (!strcmp(e, ".wav")) choice = 2;
  else if (!strcmp(e, ".xm")) choice = 1;
  switch(choice)
    {
    case 0:
      {
	hear_mid(argv);
	break;
      }
    case 1:
      {
	hear_mod(argv);
	break;
      }
    case 2:
      {
	hear_wav(argv);
	break;
      }
    }
}
/*---------------------------------------------------------------------------*/
void hear_mid(char *s[])
{
  MIDI *amid;

  allegro_init();
  install_keyboard();
  install_timer();
  amid = load_midi(s[1]);
  detect_midi_driver(MIDI_AUTODETECT);
  install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
  set_volume(255, 255);
  play_midi(amid, TRUE);
  if (readkey())
    {
      destroy_midi(amid);
    }
}
/*---------------------------------------------------------------------------*/
void hear_mod(char *s[])
{
  unimod *mf;
  int channels_extra;
  int quit;
  int t;

  md_device = 0; /* device == autodetect */
  md_dmabufsize = 8000; /* dma buffer size */
  md_mixfreq = 22000; /* mixing frequency */
  md_mode = DMODE_16BITS | DMODE_STEREO | DMODE_INTERP; /* mixing mode */
  mp_loop = 0; /* don't loop */
  mp_volume = 100; /* maximal volume */

  ml_registerloader(&load_mod);
  ml_registerloader(&load_mtm);
  ml_registerloader(&load_s3m);
  ml_registerloader(&load_xm);
  md_registerdriver(&drv_sb);
  md_registerplayer(tickhandler); /* md_player = tickhandler */

  /* initialize soundcard */
  if (!md_init())
    {
      mod_error();
      printf("(hear_mod) !md_init()\n");
      exit(1);
    }

  /* load the module */
  mf = ml_loadfn(s[1]);
  if (mf == NULL)
    {
      mod_error();
      printf("(hear_mod) mf == NULL\n");
      exit(1);
    }

  /* initialize modplay to play the module */
  mp_init(mf);
  channels_extra = 1;
  md_numchn = mf->numchn + channels_extra;

  /* play */
  md_playstart();
  while (!mp_ready())
    {
      char c;
      c = kbhit() ? getch() : 0;

      if (c == '+')
	mp_nextposition();
      else if (c == '-')
	mp_prevposition();
      else if (c == 0x1B) /* <Esc> */
	{
	  quit = 1;
	  break;
	}
      md_update();
      delay(10);
      fflush(stdout);
    }
  md_playstop();
  ml_free(mf);
  md_exit();
}
/*---------------------------------------------------------------------------*/
void hear_wav(char *s[])
{
  int pan = 128, pitch = 1000;
  SAMPLE *asam;

  allegro_init();
  install_keyboard();
  install_timer();
  if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0)
    {
      printf("error:\n");
      printf("(hear_wav) install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0\n");
      exit(1);
    }
  asam = load_sample(s[1]);
  if (asam == NULL)
    {
      printf("error:\n");
      printf("(hear_wav) asam == NULL\n");
      exit(1);
    }
  play_sample(asam, 255, pan, pitch, TRUE);
  do
    {
      if ((key[KEY_LEFT]) && (pan > 0))
	pan--;
      else if ((key[KEY_RIGHT]) && (pan < 255))
	pan++;
      if ((key[KEY_UP]) && (pitch < 16384))
	pitch = ((pitch * 513) / 512) + 1;
      else if ((key[KEY_DOWN]) && (pitch > 64))
	pitch = ((pitch * 511) / 512) - 1;
      adjust_sample(asam, 255, pan, pitch, TRUE);
      rest(2);
    }
  while ((!key[KEY_ESC]) && (!key[KEY_SPACE]));
  destroy_sample(asam);
}
/*---------------------------------------------------------------------------*/
void tickhandler()
{
  mp_handletick(); /* play 1 tick of the module */
  md_setbpm(mp_bpm);
}
