/* general.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
/*---------------------------------------------------------------------------*/
/* read char from file */
char fgetc_char(FILE *fp)
{
  return(fgetc(fp));
}
/*---------------------------------------------------------------------------*/
/* read uchr from file */
uchr fgetc_uchr(FILE *fp)
{
  return(fgetc(fp));
}
/*---------------------------------------------------------------------------*/
/* read short from file, LSB first */
short fgetc_short_l(FILE *fp)
{
  return ((short) fgetc_ushr_l(fp));
}
/*---------------------------------------------------------------------------*/
/* read short from file, MSB first */
short fgetc_short_m(FILE *fp)
{
  return ((short) fgetc_ushr_m(fp));
}
/*---------------------------------------------------------------------------*/
/* read ushr from file, LSB first */
ushr fgetc_ushr_l(FILE *fp)
{
  ushr result = fgetc(fp);
  result |= ((ushr) fgetc(fp)) << 8;
  return result;
}
/*---------------------------------------------------------------------------*/
/* read ushr from file, MSB first */
ushr fgetc_ushr_m(FILE *fp)
{
  ushr result = ((ushr) fgetc(fp)) << 8;
  result |= fgetc(fp);
  return result;
}
/*---------------------------------------------------------------------------*/
/* read int from file, LSB first */
int fgetc_int_l(FILE *fp)
{
  return ((int) fgetc_uint_l(fp));
}
/*---------------------------------------------------------------------------*/
/* read int from file, MSB first */
int fgetc_int_m(FILE *fp)
{
  return ((int) fgetc_uint_m(fp));
}
/*---------------------------------------------------------------------------*/
/* read uint from file, LSB first */
uint fgetc_uint_l(FILE *fp)
{
  uint result = fgetc(fp);
  result |= ((uint) fgetc(fp)) << 8;
  result |= ((uint) fgetc(fp)) << 16;
  result |= ((uint) fgetc(fp)) << 24;
  return result;
}
/*---------------------------------------------------------------------------*/
/* read uint from file, MSB first */
uint fgetc_uint_m(FILE *fp)
{
  uint result = ((uint) fgetc(fp)) << 24;
  result |= ((uint) fgetc(fp)) << 16;
  result |= ((uint) fgetc(fp)) << 8;
  result |= fgetc(fp);
  return result;
}
/*---------------------------------------------------------------------------*/
/* read long from file, LSB first */
long fgetc_long_l(FILE *fp)
{
  return((long) fgetc_ulng_l(fp));
}
/*---------------------------------------------------------------------------*/
/* read long from file, MSB first */
long fgetc_long_m(FILE *fp)
{
  return((long) fgetc_ulng_m(fp));
}
/*---------------------------------------------------------------------------*/
/* read ulng from file, LSB first */
ulng fgetc_ulng_l(FILE *fp)
{
  ulng result = fgetc_ushr_l(fp);
  result |= ((ulng) fgetc_ushr_l(fp)) << 16;
  return result;
}
/*---------------------------------------------------------------------------*/
/* read ulng from file, MSB first */
ulng fgetc_ulng_m(FILE *fp)
{
  ulng result = ((ulng) fgetc_ushr_m(fp)) << 16;
  result |= fgetc_ushr_m(fp);
  return result;
}
/*---------------------------------------------------------------------------*/
/* write char to file */
void fputc_char(char data, FILE *fp)
{
  fputc(data, fp);
}
/*---------------------------------------------------------------------------*/
/* write uchr to file */
void fputc_uchr(uchr data, FILE *fp)
{
  fputc(data, fp);
}
/*---------------------------------------------------------------------------*/
/* write short to file, LSB first */
void fputc_short_l(short data, FILE *fp)
{
  fputc_ushr_l((ushr)data, fp);
}
/*---------------------------------------------------------------------------*/
/* write short to file, MSB first */
void fputc_short_m(short data, FILE *fp)
{
  fputc_ushr_m((ushr) data, fp);
}
/*---------------------------------------------------------------------------*/
/* write ushr to file, LSB first */
void fputc_ushr_l(ushr data, FILE *fp)
{
  fputc(data & 0xFF, fp);
  fputc(data >> 8, fp);
}
/*---------------------------------------------------------------------------*/
/* write ushr to file, MSB first */
void fputc_ushr_m(ushr data, FILE *fp)
{
  fputc(data >> 8, fp);
  fputc(data & 0xFF, fp);
}
/*---------------------------------------------------------------------------*/
/* write int to file, LSB first */
void fputc_int_l(int data, FILE *fp)
{
  fputc_uint_l((uint) data, fp);
}
/*---------------------------------------------------------------------------*/
/* write int to file, MSB first */
void fputc_int_m(int data, FILE *fp)
{
  fputc_uint_m((uint) data, fp);
}
/*---------------------------------------------------------------------------*/
/* write uint to file, LSB first */
void fputc_uint_l(uint data, FILE *fp)
{
  fputc(data & 0xFF, fp);
  fputc(((uint) data) >> 8, fp);
  fputc(((uint) data) >> 16, fp);
  fputc(((uint) data) >> 24, fp);
}
/*---------------------------------------------------------------------------*/
/* write uint to file, MSB first */
void fputc_uint_m(uint data, FILE *fp)
{
  fputc(((uint) data) >> 24, fp);
  fputc(((uint) data) >> 16, fp);
  fputc(((uint) data) >> 8, fp);
  fputc(data & 0xFF, fp);
}
/*---------------------------------------------------------------------------*/
/* write long to file, LSB first */
void fputc_long_l(long data, FILE *fp)
{
  fputc_ulng_l((ulng)data, fp);
}
/*---------------------------------------------------------------------------*/
/* write long to file, MSB first */
void fputc_long_m(long data, FILE *fp)
{
  fputc_ulng_m((ulng)data, fp);
}
/*---------------------------------------------------------------------------*/
/* write ulng to file, LSB first */
void fputc_ulng_l(ulng data, FILE *fp)
{
  fputc_ushr_l(data & 0xFFFF, fp);
  fputc_ushr_l(data >> 16, fp);
}
/*---------------------------------------------------------------------------*/
/* write ulng to file, MSB first */
void fputc_ulng_m(ulng data, FILE *fp)
{
  fputc_ushr_m(data >> 16, fp);
  fputc_ushr_m(data & 0xFFFF, fp);
}
/*---------------------------------------------------------------------------*/
#define DEFINE_MULTIPLE_READ_FUNCTION(type_name, type) \
int fgetc_##type_name##s(type *buffer, int number, FILE *fp) \
{ \
  while (number > 0) \
    { \
      *(buffer++) = fgetc_##type_name(fp); \
      number--; \
    } \
  return !feof(fp); \
}
/*---------------------------------------------------------------------------*/
#define DEFINE_MULTIPLE_WRITE_FUNCTION(type_name, type) \
void fputc_##type_name##s(type *buffer, int number, FILE *fp) \
{ \
    while (number > 0) \
    { \
      fputc_##type_name(*(buffer++), fp); \
      number--; \
    } \
}
/*---------------------------------------------------------------------------*/
DEFINE_MULTIPLE_READ_FUNCTION(char, char)
DEFINE_MULTIPLE_READ_FUNCTION(uchr, uchr)

DEFINE_MULTIPLE_READ_FUNCTION(short_l, short)
DEFINE_MULTIPLE_READ_FUNCTION(short_m, short)
DEFINE_MULTIPLE_READ_FUNCTION(ushr_l, ushr)
DEFINE_MULTIPLE_READ_FUNCTION(ushr_m, ushr)

DEFINE_MULTIPLE_READ_FUNCTION(long_l, long)
DEFINE_MULTIPLE_READ_FUNCTION(long_m, long)
DEFINE_MULTIPLE_READ_FUNCTION(ulng_l, ulng)
DEFINE_MULTIPLE_READ_FUNCTION(ulng_m, ulng)
/*---------------------------------------------------------------------------*/
DEFINE_MULTIPLE_WRITE_FUNCTION(char, char)
DEFINE_MULTIPLE_WRITE_FUNCTION(uchr, uchr)

DEFINE_MULTIPLE_WRITE_FUNCTION(short_l, short)
DEFINE_MULTIPLE_WRITE_FUNCTION(short_m, short)
DEFINE_MULTIPLE_WRITE_FUNCTION(ushr_l, ushr)
DEFINE_MULTIPLE_WRITE_FUNCTION(ushr_m, ushr)

DEFINE_MULTIPLE_WRITE_FUNCTION(long_l, long)
DEFINE_MULTIPLE_WRITE_FUNCTION(long_m, long)
DEFINE_MULTIPLE_WRITE_FUNCTION(ulng_l, ulng)
DEFINE_MULTIPLE_WRITE_FUNCTION(ulng_m, ulng)
/*---------------------------------------------------------------------------*/
/* di = decrement/increment flag */
/* sl = saturate/loop flag */
void parafloat(float *v, float min, float max, float step, int di, int sl)
{
  if (di == 0) /* decrement */
    {
      if ((*v - step) >= min)
	{
	  *v -= step;
	}
      else
	{
	  if (sl == 0) /* saturate */
	    {
	      *v = min;
	    }
	  else if (sl == 1) /* loop */
	    {
	      *v = max;
	    }
	}
    }
  else if (di == 1) /* increment */
    {
      if ((*v + step) <= max)
	{
	  *v += step;
	}
      else
	{
	  if (sl == 0) /* saturate */
	    {
	      *v = max;
	    }
	  else if (sl == 1) /* loop */
	    {
	      *v = min;
	    }
	}
    }
}
/*---------------------------------------------------------------------------*/
/* di = decrement/increment flag */
/* sl = saturate/loop flag */
void paraint(int *v, int min, int max, int step, int di, int sl)
{
  if (di == 0) /* decrement */
    {
      if ((*v - step) >= min)
	{
	  *v -= step;
	}
      else
	{
	  if (sl == 0) /* saturate */
	    {
	      *v = min;
	    }
	  else if (sl == 1) /* loop */
	    {
	      *v = max;
	    }
	}
    }
  else if (di == 1) /* increment */
    {
      if ((*v + step) <= max)
	{
	  *v += step;
	}
      else
	{
	  if (sl == 0) /* saturate */
	    {
	      *v = max;
	    }
	  else if (sl == 1) /* loop */
	    {
	      *v = min;
	    }
	}
    }
}
/*---------------------------------------------------------------------------*/
/* di = decrement/increment flag */
/* sl = saturate/loop flag */
void paralong(long *v, long min, long max, long step, int di, int sl)
{
  if (di == 0) /* decrement */
    {
      if ((*v - step) >= min)
	{
	  *v -= step;
	}
      else
	{
	  if (sl == 0) /* saturate */
	    {
	      *v = min;
	    }
	  else if (sl == 1) /* loop */
	    {
	      *v = max;
	    }
	}
    }
  else if (di == 1) /* increment */
    {
      if ((*v + step) <= max)
	{
	  *v += step;
	}
      else
	{
	  if (sl == 0) /* saturate */
	    {
	      *v = max;
	    }
	  else if (sl == 1) /* loop */
	    {
	      *v = min;
	    }
	}
    }
}
/*---------------------------------------------------------------------------*/
/* returns a pseudo-random number between 0 and amax */
int random0tm(int amax)
{
  long long int li = rand();

  li *= amax;
  return (int)(li / RAND_MAX); /* 2147483647 */
}
/*---------------------------------------------------------------------------*/
/* same as calloc, but displays an appropriate message when it failed */
void *callocm(size_t nitems, size_t size)
{
  void *d;

  d = calloc(nitems, size);
  if (d == NULL)
    {
      printf("error:\n");
      printf("(callocm) d == NULL\n");
    }
  return d;
}
/*---------------------------------------------------------------------------*/
/* same as malloc, but displays an appropriate message when it failed */
void *mallocm(size_t size)
{
  void *d;

  d = malloc(size);
  if (d == NULL)
    {
      printf("error:\n");
      printf("(mallocm) d == NULL\n");
    }
  return d;
}
/*---------------------------------------------------------------------------*/
/* sets filepointer after search */
/* the file must first be opened and eventually rewinded before calling this */
/* if newline is 1, the filepointer is set to the beginning of the next line */
void setfilept(FILE *afp, char *search, int newline)
{
  uchr b;
  char s[256];

  b = 0;
  while (!feof(afp) && b == 0)
    {
      fscanf(afp, "%s", s);
      if (!strcmp(s, search))
	{
	  b = 1;
	}
    }
  if (newline)
    {
      fgets(s, 256, afp); /* go to the next line */
    }
}
