/* fades.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "effects.h"
/*---------------------------------------------------------------------------*/
/* #define */
#define FADES_DELAY_MIN 1
#define FADES_DELAY_MAX 64
#define FADES_DELAY_STEP 1
/*---------------------------------------------------------------------------*/
/* type */
typedef struct fades_pal
{
  PALETTE p;
  char s[256];
} fades_pal;
/*---------------------------------------------------------------------------*/
/* variables */
long fades_delay;
int fades_from;
int fades_to;
int fades_debug;
char fades_name[255];
fades_pal pallst[1000];

static tkeyparse
  see_f4_0 = {K_0, keysee_f4_0}, /* fades.c specific */
  see_f4_1 = {K_1, keysee_f4_1},
  see_f4_2 = {K_2, keysee_f4_2},
  see_f4_3 = {K_3, keysee_f4_3},
  see_f4_4 = {K_4, keysee_f4_4},
  see_f4_5 = {K_5, keysee_f4_5},
  see_f4_6 = {K_6, keysee_f4_6},
  see_f4_7 = {K_7, keysee_f4_7},
  see_f4_8 = {K_8, keysee_f4_8},
  see_f4_9 = {K_9, keysee_f4_9},
  see_f4_d = {K_d, keysee_f4_d},
  see_f4_D = {K_D, keysee_f4_D}
;

tkeyparse* tkeyparsetbl_fades[] =
{
  TKEYPARSETBL_SEE, /* see.c specific */
  &see_f4_0, /* fades.c specific */
  &see_f4_1,
  &see_f4_2,
  &see_f4_3,
  &see_f4_4,
  &see_f4_5,
  &see_f4_6,
  &see_f4_7,
  &see_f4_8,
  &see_f4_9,
  &see_f4_d,
  &see_f4_D,
  NULL
};
/*---------------------------------------------------------------------------*/
void fades()
{
  int dummy, i, j, k, p;
  char *s;
  FILE *fp, *fpl;

  i = 0;
  j = 0;
  fpl = fopen(fades_name, "rt");
  while (!feof(fpl))
    {
      if (!fscanf(fpl, "%s", s))
	{
	  break;
	}
      else
	{
	  if (strcmp(s, "pal"))
	    {
	      fp = fopen(s, "rt");
	      if (!fp)
		{
		  break;
		}
	      else
		{
		  strcpy(pallst[j].s, s);
		  i = 0;
		  do
		    {
		      fscanf(fp, "%i", &p);
		      pallst[j].p[i].r = p/4;
		      fscanf(fp, "%i", &p);
		      pallst[j].p[i].g = p/4;
		      fscanf(fp, "%i", &p);
		      pallst[j].p[i].b = p/4;
		      i++;
		    }
		  while (i < 256);
		  fclose(fp);
		}
	    }
	  else /* pal */
	    {
	      strcpy(pallst[j].s, "pal");
	      i = 0; /* pallst[j].p = pal */
	      do
		{
		  pallst[j].p[i].r = pal[i].r;
		  pallst[j].p[i].g = pal[i].g;
		  pallst[j].p[i].b = pal[i].b;
		  i++;
		}
	      while (i < 256);
	    }
	  j++;
	}
    }
  fclose(fpl);

  lastkey = K_d;
  do
    {
      for (i = 0; i < j; i++)
	{
	  if (i + 1 < j)
	    {
	      fade_from_range(pallst[i].p, pallst[i+1].p, fades_delay, fades_from, fades_to);
	      if (fades_debug == 1)
		{
		  textprintf_centre(screen, font, SCREEN_W/2, SCREEN_H/2, 255, "%s", pallst[i+1].s);
		  for (k = 0; k < 32768; k++)
		    {
		      dummy = 1 * 2 * 3 * 4 * 5 * 10; /* consume some time */
		      dummy = 1 * 2 * 3 * 4 * 5 * 10; /* consume some time */
		      dummy = 1 * 2 * 3 * 4 * 5 * 10; /* consume some time */
		      key_scan();
		      if (lastkey != K_d)
			{
			  keysee_insert();
			  break;
			}
		    }
		}
	    }
	  else
	    {
	      fade_from_range(pallst[i].p, pallst[0].p, fades_delay, fades_from, fades_to);
	      if (fades_debug == 1)
		{
		  textprintf_centre(screen, font, SCREEN_W/2, SCREEN_H/2, 255, "%s", pallst[0].s);

		  for (k = 0; k < 32768; k++)
		    {
		      dummy = 1 * 2 * 3 * 4 * 5 * 10; /* consume some time */
		      dummy = 1 * 2 * 3 * 4 * 5 * 10; /* consume some time */
		      dummy = 1 * 2 * 3 * 4 * 5 * 10; /* consume some time */
		      key_scan();
		      if (lastkey != K_d)
			{
			  keysee_insert();
			  break;
			}
		    }
		}
	    }
	  ptkeyparsetbl = tkeyparsetbl_fades;
	  key_scan();
	  if (lastkey != K_d)
	    {
	      break;
	    }
	}
    }
  while ((lastkey == K_d) || (lastkey == K_D));
  if (lastkey == K_ESC)
    {
      esc_hit = 1;
    }
}
/*---------------------------------------------------------------------------*/
void keysee_f4_0()
{
  keysee_f4_gen("f4_0");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_1()
{
  keysee_f4_gen("f4_1");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_2()
{
  keysee_f4_gen("f4_2");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_3()
{
  keysee_f4_gen("f4_3");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_4()
{
  keysee_f4_gen("f4_4");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_5()
{
  keysee_f4_gen("f4_5");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_6()
{
  keysee_f4_gen("f4_6");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_7()
{
  keysee_f4_gen("f4_7");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_8()
{
  keysee_f4_gen("f4_8");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_9()
{
  keysee_f4_gen("f4_9");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_D() /* bigger values for delay means faster in this case */
{
  paralong(&fades_delay, FADES_DELAY_MIN, FADES_DELAY_MAX, FADES_DELAY_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f4_d() /* smaller values for delay means slower in this case */
{
  paralong(&fades_delay, FADES_DELAY_MIN, FADES_DELAY_MAX, FADES_DELAY_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f4_gen(char s[256])
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", s, &pi);
  fades_delay = atoi(tps[1]);
  fades_from = atoi(tps[2]);
  fades_to = atoi(tps[3]);
  fades_debug = atoi(tps[4]);
  strcpy(fades_name, tps[5]);
  fades();
}
