/* drv_sb.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
/*---------------------------------------------------------------------------*/
/* global variables : use */
/* driver variables */
extern ushr md_mixfreq;
extern ushr md_dmabufsize;
extern ushr md_mode;
/*---------------------------------------------------------------------------*/
/* variables */
ushr sb_port; /* sb base port */
char *sb_dmabuf;
uchr SB_TIMECONSTANT, PIC1MSK, PIC2MSK;
ushr sb_int; /* interrupt vector that belongs to sb_irq */
ushr sb_ver; /* DSP version number */
uchr sb_irq; /* sb irq */
uchr sb_lodma; /* 8 bit dma channel (1.0 / 2.0 / pro) */
uchr sb_hidma; /* 16 bit dma channel (16 / 16asp) */
uchr sb_dma; /* current dma channel */
pvi oldhandler;
ushr last = 0;
ushr curr = 0;

driver drv_sb =
{
  NULL,
  "SB 1.0 / 2.0 / Pro / 16 + compatibles",
  "v2.1",
  sb_isthere,
  vc_sampleload,
  vc_sampleunload,
  sb_init,
  sb_exit,
  sb_playstart,
  sb_playstop,
  sb_update,
  vc_voicesetvolume,
  vc_voicesetfrequency,
  vc_voicesetpanning,
  vc_voiceplay
};
/*---------------------------------------------------------------------------*/
int sb_init()
{
  ulng t;

  if (!sb_isthere())
    {
      mod_error();
      printf("(sb_init) !sb_isthere()\n");
      exit(1);
    }
  if (sb_ver >= 0x400 && sb_hidma == 0xFF)
    {
      mod_error();
      printf("(sb_init) sb_ver >= 0x400 && sb_hidma == 0xFF\n");
      exit(1);
    }
  if (sb_ver < 0x400 && md_mode & DMODE_16BITS)
    {
      /* DSP versions below 4.00 can't do 16 bit sound */
      /* toggle to 8 bit sound */
      md_mode &= ~DMODE_16BITS;
    }
  if (sb_ver < 0x300 && md_mode & DMODE_STEREO)
    {
      /* DSP versions below 3.00 can't do stereo sound */
      /* toggle to mono */
      md_mode &= ~DMODE_STEREO;
    }
  /* use low dma channel for 8 bit, high dma for 16 bit */
  sb_dma = (md_mode & DMODE_16BITS) ? sb_hidma : sb_lodma;
  if (sb_ver < 0x400)
    {
      t = md_mixfreq;
      if (md_mode & DMODE_STEREO)
	{
	  t <<= 1;
	}
      SB_TIMECONSTANT = 256 - (1000000L / t);
      if (sb_ver < 0x201)
	{
	  if (SB_TIMECONSTANT > 210)
	    {
	      SB_TIMECONSTANT = 210;
	    }
	}
      else
	{
	  if (SB_TIMECONSTANT > 233)
	    {
	      SB_TIMECONSTANT = 233;
	    }
	}
      md_mixfreq = 1000000L / (256 - SB_TIMECONSTANT);
      if (md_mode & DMODE_STEREO)
	{
	  md_mixfreq >>= 1;
	}
    }
  if (!vc_init()) /* can't go wrong, returns always one */
    {
      mod_error();
      printf("(sb_init) !vc_init()\n");
      exit(1);
    }
  sb_dmabuf = mdma_allocmem(md_dmabufsize);
  if (sb_dmabuf == NULL)
    {
      mod_error();
      printf("(sb_init) sb_dmabuf == NULL\n");
      exit(1);
    }
  oldhandler = mirq_djsethandlerfunc(sb_irq, newhandler, ((int) eonewhandler) - ((int) newhandler));
  return 1;
}
/*---------------------------------------------------------------------------*/
int sb_isthere()
{
  char *envptr, c;
  static char *endptr;

  sb_port = 0xFFFF;
  sb_irq = 0xFF;
  sb_lodma = 0xFF;
  sb_hidma = 0xFF;

  if ((envptr = getenv("BLASTER")) == NULL)
    {
      mod_error();
      printf("(sb_isthere) (envptr = getenv(\"BLASTER\")) == NULL\n");
      exit(1);
    }
  while (1)
  {
    /* skip whitespace */
    do
      {
	c = *(envptr++);
      }
    while (c == ' ' || c == '\t');
    /* reached end of string == all blank ? -> exit */
    if (c == 0)
      {
	break;
      }
    switch (c)
      {
      case 'a':
      case 'A':
	sb_port = strtol(envptr, &endptr, 16);
	break;
      case 'i':
      case 'I':
	sb_irq = strtol(envptr, &endptr, 10);
	break;
      case 'd':
      case 'D':
	sb_lodma = strtol(envptr, &endptr, 10);
	break;
      case 'h':
      case 'H':
	sb_hidma = strtol(envptr, &endptr, 10);
	break;
      default:
	strtol(envptr, &endptr, 16);
	break;
      }
    envptr = endptr;
  }
  if (sb_port == 0xFFFF || sb_irq == 0xFF || sb_lodma == 0xFF)
    {
      mod_error();
      printf("(sb_isthere) sb_port == 0xFFFF || sb_irq == 0xFF || sb_lodma == 0xFF\n");
      exit(1);
    }
  /* determine interrupt vector */
  sb_int = (sb_irq > 7) ? sb_irq + 104 : sb_irq + 8;
  if (!sb_ping())
    {
      mod_error();
      printf("(sb_isthere) !sb_ping\n");
      exit(1);
    }
  /* get DSP version */
  if ((sb_ver = sb_getdspversion()) == 0xFFFF)
    {
      mod_error();
      printf("(sb_isthere) (sb_ver = sb_getdspversion()) == 0xFFFF\n");
      exit(1);
    }
  return 1; /* SB found */
}
/*---------------------------------------------------------------------------*/
/* checks if a SB is present at the current baseport by resetting the DSP and checking if it */
/* returned the value 0xAA */
/* returns 1 => SB is present, 0 => no SB detected */
int sb_ping()
{
  sb_resetdsp();
  return (sb_readdsp() == 0xAA);
}
/*---------------------------------------------------------------------------*/
/* waits until the DSP is ready to read from, returns 0 on timeout */
int sb_waitdspread()
{
  ushr timeout = 32767;

  while (timeout--)
    {
      if (inportb(DSP_DATA_AVAIL) & 0x80)
	{
	  return 1;
	}
    }
  return 0;
}
/*---------------------------------------------------------------------------*/
/* waits until the DSP is ready to be written to, returns 0 on timeout */
int sb_waitdspwrite()
{
  ushr timeout = 32767;

  while (timeout--)
    {
      if (!(inportb(DSP_WRITE_STATUS) & 0x80))
	{
	  return 1;
	}
    }
  return 0;
}
/*---------------------------------------------------------------------------*/
/* writes byte 'data' to the DSP, returns 0 on timeout */
int sb_writedsp(uchr data)
{
  if (!sb_waitdspwrite())
    {
      return 0;
    }
  outportb(DSP_WRITE_DATA, data);
  return 1;
}
/*---------------------------------------------------------------------------*/
/* gets SB-DSP version, returns 0xFFFF if DSP didn't respond */
ushr sb_getdspversion()
{
  ushr hi, lo;

  if (!sb_writedsp(0xE1))
    {
      return 0xFFFF;
    }
  hi = sb_readdsp();
  lo = sb_readdsp();
  return ((hi << 8) | lo);
}
/*---------------------------------------------------------------------------*/
/* reads a byte from the DSP, returns 0xFFFF on timeout */
ushr sb_readdsp()
{
  if (!sb_waitdspread())
    {
      return 0xFFFF;
    }
  return (inportb(DSP_READ_DATA));
}
/*---------------------------------------------------------------------------*/
void newhandler()
{
  if (sb_ver < 0x200)
  {
    sb_writedsp(0x14);
    sb_writedsp(0xFF);
    sb_writedsp(0xFE);
  }
  if (md_mode & DMODE_16BITS)
    {
      inportb(sb_port + 0xF);
    }
  else
    {
      inportb(DSP_DATA_AVAIL);
    }
  mirq_eoi(sb_irq);
}
/* this function must come directly after newhandler() */
/* used in sb_init() to calculate the length of newhandler() */
void eonewhandler()
{
}
/*---------------------------------------------------------------------------*/
void sb_exit()
{
  mirq_djsethandleraddr(sb_irq, oldhandler);
  mdma_freemem(sb_dmabuf);
}
/*---------------------------------------------------------------------------*/
/* disables stereo output for DSP versions 3.00 >= ver < 4.00 */
void sb_mixermono()
{
  outportb(MIXER_ADDRESS, 0xE);
  outportb(MIXER_DATA, inportb(MIXER_DATA) & 0xFD);
}
/*---------------------------------------------------------------------------*/
/* enables stereo output for DSP versions 3.00 >= ver < 4.00 */
void sb_mixerstereo()
{
  outportb(MIXER_ADDRESS, 0xE);
  outportb(MIXER_DATA, inportb(MIXER_DATA) | 2);
}
/*---------------------------------------------------------------------------*/
/* resets the DSP */
void sb_resetdsp()
{
  int t;

  /* reset the DSP by sending 1, (delay), then 0 */
  outportb(DSP_RESET, 1);
  for (t = 0; t < 8; t++)
    {
      inportb(DSP_RESET);
    }
  outportb(DSP_RESET, 0);
}
/*---------------------------------------------------------------------------*/
/* disables DAC speaker output */
void sb_speakeroff()
{
  sb_writedsp(0xD3);
}
/*---------------------------------------------------------------------------*/
/* enables DAC speaker output */
void sb_speakeron()
{
  sb_writedsp(0xD1);
}
/*---------------------------------------------------------------------------*/
void sb_update()
{
  ushr todo;

  curr = (md_dmabufsize - mdma_todo(sb_dma)) & 0xFFFC;

  if (curr > last)
    {
      todo = curr - last;
      last += vc_writebytes(&sb_dmabuf[last], todo);
      if (last >= md_dmabufsize)
	{
	  last = 0;
	}
    }
  else
    {
      todo = md_dmabufsize - last;
      vc_writebytes(&sb_dmabuf[last], todo);
      last = vc_writebytes(sb_dmabuf, curr);
    }
}
/*---------------------------------------------------------------------------*/
void sb_playstart()
{
  vc_playstart();
  mirq_onoff(sb_irq, 1);
  if (sb_ver >= 0x300 && sb_ver < 0x400)
    {
      if (md_mode & DMODE_STEREO)
	{
	  sb_mixerstereo();
	}
      else
	{
	  sb_mixermono();
	}
    }
  /* clear the dma buffer to zero (16 bits signed ) or 0x80 (8 bits unsigned) */
  if (md_mode & DMODE_16BITS)
    {
      memset(sb_dmabuf, 0, md_dmabufsize);
    }
  else
    {
      memset(sb_dmabuf, 0x80, md_dmabufsize);
    }
  if (!mdma_start(sb_dma, sb_dmabuf, md_dmabufsize, INDEF_WRITE))
  {
    return;
  }
  if (sb_ver < 0x400)
  {
    sb_speakeron();
    sb_writedsp(0x40);
    sb_writedsp(SB_TIMECONSTANT);
    if (sb_ver < 0x200)
      {
	sb_writedsp(0x14);
	sb_writedsp(0xFF);
	sb_writedsp(0xFE);
      }
    else if (sb_ver == 0x200)
      {
	sb_writedsp(0x48);
	sb_writedsp(0xFF);
	sb_writedsp(0xFE);
	sb_writedsp(0x1C);
      }
    else
      {
	sb_writedsp(0x48);
	sb_writedsp(0xFF);
	sb_writedsp(0xFE);
	sb_writedsp(0x90);
      }
  }
  else
    {
      sb_writedsp(0x41);
      sb_writedsp(md_mixfreq >> 8);
      sb_writedsp(md_mixfreq & 0xFF);
      if (md_mode & DMODE_16BITS)
	{
	  sb_writedsp(0xB6);
	  sb_writedsp((md_mode & DMODE_STEREO) ? 0x30 : 0x10);
	}
      else
	{
	  sb_writedsp(0xC6);
	  sb_writedsp((md_mode & DMODE_STEREO) ? 0x20 : 0x00);
	}
      sb_writedsp(0xFF);
      sb_writedsp(0xEF);
    }
}
/*---------------------------------------------------------------------------*/
void sb_playstop()
{
  sb_speakeroff();
  sb_resetdsp();
  sb_resetdsp();
  mdma_stop(sb_dma);
  mirq_onoff(sb_irq, 0);
}
