/* distort.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "effects.h"
/*---------------------------------------------------------------------------*/
/* #define */
#define DISTORT_AMPS_MIN (itofix(0))
#define DISTORT_AMPS_MAX (itofix(100))
#define DISTORT_AMPS_STEP (itofix(1))

#define DISTORT_COMP_MIN (ftofix(0.00))
#define DISTORT_COMP_MAX (ftofix(1.00))
#define DISTORT_COMP_STEP (ftofix(0.01))

#define DISTORT_DELAY_MIN 0
#define DISTORT_DELAY_MAX 3000
#define DISTORT_DELAY_STEP 100

#define DISTORT_MASKED_MIN 0
#define DISTORT_MASKED_MAX 1
#define DISTORT_MASKED_STEP 1

#define DISTORT_WAVES_MIN 0
#define DISTORT_WAVES_MAX 100
#define DISTORT_WAVES_STEP 1

#define DISTORT_X_MIN 0
#define DISTORT_X_MAX SCREEN_W
#define DISTORT_X_STEP (SCREEN_W/10)

#define DISTORT_Y_MIN 0
#define DISTORT_Y_MAX SCREEN_H
#define DISTORT_Y_STEP (SCREEN_H/10)
/*---------------------------------------------------------------------------*/
/* variables */
fixed distort_amps;
fixed distort_comp;
long distort_delay;
int distort_masked;
int distort_waves;
int distort_x;
int distort_y;

static tkeyparse
  see_f3_0 = {K_0, keysee_f3_0}, /* distort.c specific */
  see_f3_1 = {K_1, keysee_f3_1},
  see_f3_2 = {K_2, keysee_f3_2},
  see_f3_3 = {K_3, keysee_f3_3},
  see_f3_4 = {K_4, keysee_f3_4},
  see_f3_5 = {K_5, keysee_f3_5},
  see_f3_6 = {K_6, keysee_f3_6},
  see_f3_7 = {K_7, keysee_f3_7},
  see_f3_8 = {K_8, keysee_f3_8},
  see_f3_9 = {K_9, keysee_f3_9},
  see_f3_a = {K_a, keysee_f3_a},
  see_f3_A = {K_A, keysee_f3_A},
  see_f3_c = {K_c, keysee_f3_c},
  see_f3_C = {K_C, keysee_f3_C},
  see_f3_d = {K_d, keysee_f3_d},
  see_f3_D = {K_D, keysee_f3_D},
  see_f3_m = {K_m, keysee_f3_m},
  see_f3_M = {K_M, keysee_f3_M},
  see_f3_w = {K_w, keysee_f3_w},
  see_f3_W = {K_W, keysee_f3_W},
  see_f3_x = {K_x, keysee_f3_x},
  see_f3_X = {K_X, keysee_f3_X},
  see_f3_y = {K_y, keysee_f3_y},
  see_f3_Y = {K_Y, keysee_f3_Y}
;

tkeyparse* tkeyparsetbl_distort[] =
{
  TKEYPARSETBL_SEE, /* see.c specific */
  &see_f3_0, /* distort.c specific */
  &see_f3_1,
  &see_f3_2,
  &see_f3_3,
  &see_f3_4,
  &see_f3_5,
  &see_f3_6,
  &see_f3_7,
  &see_f3_8,
  &see_f3_9,
  &see_f3_a,
  &see_f3_A,
  &see_f3_c,
  &see_f3_C,
  &see_f3_d,
  &see_f3_D,
  &see_f3_m,
  &see_f3_M,
  &see_f3_w,
  &see_f3_W,
  &see_f3_x,
  &see_f3_X,
  &see_f3_y,
  &see_f3_Y,
  NULL
};
/*---------------------------------------------------------------------------*/
/* prototypes */
void applysine(BITMAP *outbitmap, fixed ashift);
/*---------------------------------------------------------------------------*/
void applysine(BITMAP *outbitmap, fixed ashift)
{
  int xpos, ypos, newy, desty, outy;
  uchr	apoint, *liney;
  fixed angle;
  const fixed anglefact = 2670177L; /* = 256 / (PI * 2) */

  desty = pbmp->h - fixtoi(distort_amps); /* 190 */
  outy = fixtoi(distort_amps) * 2; /* 20 */
  for (ypos = fixtoi(distort_amps); ypos < desty; ypos++) /* 10, 190 */
    {
      liney = pbmp->line[ypos];
      outy++; /* 21 */
      for (xpos = pbmp->w; xpos--;) /* 320 */
	{
	  apoint = liney[xpos];
	  if ((apoint) || (!distort_masked))
	    {
	      /* 320 * 0.05 + 25, 256/(2*PI) = 41, 40.74367 */
	      angle = fmul(xpos * distort_comp + ashift, anglefact); /* 1670.49028 */
	      /* 10, -0.77152 = -7.71567 */
	      newy = fixtoi(fmul(distort_amps, fsin(angle))) + outy;
	      outbitmap->line[newy][xpos] = apoint;
	    }
	}
    }
}
/*---------------------------------------------------------------------------*/
void distort()
{
  int h, h2, i, w;
  BITMAP *pbmpwarp, *pbmpoldscr;

  lastkey = K_d;

  w = pbmp->w; /* 320 */
  h = pbmp->h; /* 200 */
  h2 = h + 2 * fixtoi(distort_amps); /* 220 */
  pbmpwarp = create_bitmap(w, h2); /* 320, 220 */
  if (distort_masked)
    {
      pbmpoldscr = create_bitmap(w, h2); /* 320, 220 */
      blit(screen, pbmpoldscr, distort_x, distort_y, 0, 0, w, h2); /* 320, 220, clip */
    }
  i = distort_waves; /* 25 */
  do
    {
      if (distort_masked)
	{
	  blit(pbmpoldscr, pbmpwarp, 0, 0, 0, 0, w, h2); /* 320, 220 */
	}
      else
	{
	  clear(pbmpwarp);
	}
      applysine(pbmpwarp, itofix(i)); /* 25 */
      blit(pbmpwarp, screen, 0, 0, distort_x, distort_y, w, h2); /* 320, 220, clip */
      rest(distort_delay);
      i--;
      if (i <= 0)
	{
	  i = distort_waves;
	}
      ptkeyparsetbl = tkeyparsetbl_distort;
      key_scan();

    }
  while ((lastkey == K_a) || (lastkey == K_A) ||
	 (lastkey == K_c) || (lastkey == K_C) ||
	 (lastkey == K_d) || (lastkey == K_D) ||
	 (lastkey == K_m) || (lastkey == K_M) ||
	 (lastkey == K_w) || (lastkey == K_W) ||
	 (lastkey == K_x) || (lastkey == K_X) ||
	 (lastkey == K_y) || (lastkey == K_Y));

  if (distort_masked)
    {
      destroy_bitmap(pbmpoldscr);
    }
  destroy_bitmap(pbmpwarp);

  if (lastkey == K_ESC)
    {
      esc_hit = 1;
    }
}
/*---------------------------------------------------------------------------*/
void keysee_f3_0()
{
  keysee_f3_gen("f3_0");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_1()
{
  keysee_f3_gen("f3_1");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_2()
{
  keysee_f3_gen("f3_2");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_3()
{
  keysee_f3_gen("f3_3");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_4()
{
  keysee_f3_gen("f3_4");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_5()
{
  keysee_f3_gen("f3_5");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_6()
{
  keysee_f3_gen("f3_6");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_7()
{
  keysee_f3_gen("f3_7");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_8()
{
  keysee_f3_gen("f3_8");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_9()
{
  keysee_f3_gen("f3_9");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_A()
{
  parafixed(&distort_amps, DISTORT_AMPS_MIN, DISTORT_AMPS_MAX, DISTORT_AMPS_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_C()
{
  parafixed(&distort_comp, DISTORT_COMP_MIN, DISTORT_COMP_MAX, DISTORT_COMP_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_D()
{
  paralong(&distort_delay, DISTORT_DELAY_MIN, DISTORT_DELAY_MAX, DISTORT_DELAY_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_M()
{
  paraint(&distort_masked, DISTORT_MASKED_MIN, DISTORT_MASKED_MAX, DISTORT_MASKED_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_W()
{
  paraint(&distort_waves, DISTORT_WAVES_MIN, DISTORT_WAVES_MAX, DISTORT_WAVES_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_X()
{
  paraint(&distort_x, DISTORT_X_MIN, DISTORT_X_MAX, DISTORT_X_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_Y()
{
  paraint(&distort_y, DISTORT_Y_MIN, DISTORT_Y_MAX, DISTORT_Y_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_a()
{
  parafixed(&distort_amps, DISTORT_AMPS_MIN, DISTORT_AMPS_MAX, DISTORT_AMPS_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_c()
{
  parafixed(&distort_comp, DISTORT_COMP_MIN, DISTORT_COMP_MAX, DISTORT_COMP_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_d()
{
  paralong(&distort_delay, DISTORT_DELAY_MIN, DISTORT_DELAY_MAX, DISTORT_DELAY_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_gen(char s[256])
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", s, &pi);
  distort_amps = itofix(atoi(tps[1]));
  distort_comp = ftofix(atof(tps[2]));
  distort_delay = atoi(tps[3]);
  distort_masked = atoi(tps[4]);
  distort_waves = atoi(tps[5]);
  distort_x = atoi(tps[6]);
  distort_y = atoi(tps[7]);
  distort();
}
/*---------------------------------------------------------------------------*/
void keysee_f3_m()
{
  paraint(&distort_masked, DISTORT_MASKED_MIN, DISTORT_MASKED_MAX, DISTORT_MASKED_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_w()
{
  paraint(&distort_waves, DISTORT_WAVES_MIN, DISTORT_WAVES_MAX, DISTORT_WAVES_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_x()
{
  paraint(&distort_x, DISTORT_X_MIN, DISTORT_X_MAX, DISTORT_X_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_y()
{
  paraint(&distort_y, DISTORT_Y_MIN, DISTORT_Y_MAX, DISTORT_Y_STEP, 0, 0);
}
