/* colorcy.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "effects.h"
/*---------------------------------------------------------------------------*/
#define COLORCY_DELAY_MIN 0
#define COLORCY_DELAY_MAX 3000
#define COLORCY_DELAY_STEP 100

#define COLORCY_END_MIN 1
#define COLORCY_END_MAX 255
#define COLORCY_END_STEP 1

#define COLORCY_START_MIN 0
#define COLORCY_START_MAX 254
#define COLORCY_START_STEP 1

#define COLORCY_STEP_MIN 1
#define COLORCY_STEP_MAX 127
#define COLORCY_STEP_STEP 1
/*---------------------------------------------------------------------------*/
/* variables */
long colorcy_delay;
int colorcy_end, colorcy_start, colorcy_step;

static tkeyparse
  see_f2_0 = {K_0, keysee_f2_0}, /* colorcy.c specific */
  see_f2_1 = {K_1, keysee_f2_1},
  see_f2_2 = {K_2, keysee_f2_2},
  see_f2_3 = {K_3, keysee_f2_3},
  see_f2_4 = {K_4, keysee_f2_4},
  see_f2_5 = {K_5, keysee_f2_5},
  see_f2_6 = {K_6, keysee_f2_6},
  see_f2_7 = {K_7, keysee_f2_7},
  see_f2_8 = {K_8, keysee_f2_8},
  see_f2_9 = {K_9, keysee_f2_9},
  see_f2_d = {K_d, keysee_f2_d},
  see_f2_D = {K_D, keysee_f2_D},
  see_f2_e = {K_e, keysee_f2_e},
  see_f2_E = {K_E, keysee_f2_E},
  see_f2_s = {K_s, keysee_f2_s},
  see_f2_S = {K_S, keysee_f2_S},
  see_f2_t = {K_t, keysee_f2_t},
  see_f2_T = {K_T, keysee_f2_T}
;

tkeyparse* tkeyparsetbl_colorcy[] =
{
  TKEYPARSETBL_SEE, /* see.c specific */
  &see_f2_0, /* colorcy.c specific */
  &see_f2_1,
  &see_f2_2,
  &see_f2_3,
  &see_f2_4,
  &see_f2_5,
  &see_f2_6,
  &see_f2_7,
  &see_f2_8,
  &see_f2_9,
  &see_f2_d,
  &see_f2_D,
  &see_f2_e,
  &see_f2_E,
  &see_f2_s,
  &see_f2_S,
  &see_f2_t,
  &see_f2_T,
  NULL
};
/*---------------------------------------------------------------------------*/
void colorcy()
{
  int i = 0;
  RGB temp;

  lastkey = K_d;
  do
    {
      temp = pal[colorcy_start];
      for (i = colorcy_start; i <= (colorcy_end - colorcy_step); i += colorcy_step)
	{
	  pal[i] = pal[i+colorcy_step];
	}
      pal[i] = temp;
      set_palette(pal);
      ptkeyparsetbl = tkeyparsetbl_colorcy;
      key_scan();
      rest(colorcy_delay);
    }
  while ((lastkey == K_d) || (lastkey == K_D) ||
	 (lastkey == K_e) || (lastkey == K_E) ||
	 (lastkey == K_s) || (lastkey == K_S) ||
	 (lastkey == K_t) || (lastkey == K_T));
  if (lastkey == K_ESC)
    {
      esc_hit = 1;
    }
}
/*---------------------------------------------------------------------------*/
void keysee_f2_0()
{
  keysee_f2_gen("f2_0");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_1()
{
  keysee_f2_gen("f2_1");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_2()
{
  keysee_f2_gen("f2_2");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_3()
{
  keysee_f2_gen("f2_3");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_4()
{
  keysee_f2_gen("f2_4");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_5()
{
  keysee_f2_gen("f2_5");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_6()
{
  keysee_f2_gen("f2_6");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_7()
{
  keysee_f2_gen("f2_7");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_8()
{
  keysee_f2_gen("f2_8");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_9()
{
  keysee_f2_gen("f2_9");
}
/*---------------------------------------------------------------------------*/
void keysee_f2_D()
{
  paralong(&colorcy_delay, COLORCY_DELAY_MIN, COLORCY_DELAY_MAX, COLORCY_DELAY_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f2_E()
{
  paraint(&colorcy_end, COLORCY_END_MIN, COLORCY_END_MAX, COLORCY_END_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f2_S()
{
  paraint(&colorcy_start, COLORCY_START_MIN, COLORCY_START_MAX, COLORCY_START_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f2_T()
{
  paraint(&colorcy_step, COLORCY_STEP_MIN, COLORCY_STEP_MAX, COLORCY_STEP_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f2_d()
{
  paralong(&colorcy_delay, COLORCY_DELAY_MIN, COLORCY_DELAY_MAX, COLORCY_DELAY_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f2_e()
{
  paraint(&colorcy_end, COLORCY_END_MIN, COLORCY_END_MAX, COLORCY_END_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f2_gen(char s[256])
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", s, &pi);
  colorcy_delay = atoi(tps[1]);
  colorcy_end = atoi(tps[2]);
  colorcy_start = atoi(tps[3]);
  colorcy_step = atoi(tps[4]);
  colorcy();
}
/*---------------------------------------------------------------------------*/
void keysee_f2_s()
{
  paraint(&colorcy_start, COLORCY_START_MIN, COLORCY_START_MAX, COLORCY_START_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f2_t()
{
  paraint(&colorcy_step, COLORCY_STEP_MIN, COLORCY_STEP_MAX, COLORCY_STEP_STEP, 0, 0);
}
