/* bump.c v0.70 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "effects.h"
/*---------------------------------------------------------------------------*/
/* #define */
#define BUMP_DELAY_MIN 0
#define BUMP_DELAY_MAX 3000
#define BUMP_DELAY_STEP 100

#define BUMP_SORT_MIN 1
#define BUMP_SORT_MAX 6
#define BUMP_SORT_STEP 1

#define BUMP_X_MIN 0
#define BUMP_X_MAX SCREEN_W
#define BUMP_X_STEP 1

#define BUMP_Y_MIN 0
#define BUMP_Y_MAX SCREEN_H
#define BUMP_Y_STEP 1
/*---------------------------------------------------------------------------*/
/* variables */
int x, y, dx, dy;
uchr hmap[64000];
uchr litemap[256 * 256];
uchr dbuffer[64000];

long bump_delay;
int bump_sort;
int bump_x;
int bump_y;

static tkeyparse
  see_f1_0 = {K_0, keysee_f1_0}, /* bump.c specific */
  see_f1_1 = {K_1, keysee_f1_1},
  see_f1_2 = {K_2, keysee_f1_2},
  see_f1_3 = {K_3, keysee_f1_3},
  see_f1_4 = {K_4, keysee_f1_4},
  see_f1_5 = {K_5, keysee_f1_5},
  see_f1_6 = {K_6, keysee_f1_6},
  see_f1_7 = {K_7, keysee_f1_7},
  see_f1_8 = {K_8, keysee_f1_8},
  see_f1_9 = {K_9, keysee_f1_9},
  see_f1_d = {K_d, keysee_f1_d},
  see_f1_D = {K_D, keysee_f1_D},
  see_f1_s = {K_s, keysee_f1_s},
  see_f1_S = {K_S, keysee_f1_S},
  see_f1_x = {K_x, keysee_f1_x},
  see_f1_X = {K_X, keysee_f1_X},
  see_f1_y = {K_y, keysee_f1_y},
  see_f1_Y = {K_Y, keysee_f1_Y}
;

tkeyparse* tkeyparsetbl_bump[] =
{
  TKEYPARSETBL_SEE, /* see.c specific */
  &see_f1_0, /* bump.c specific */
  &see_f1_1,
  &see_f1_2,
  &see_f1_3,
  &see_f1_4,
  &see_f1_5,
  &see_f1_6,
  &see_f1_7,
  &see_f1_8,
  &see_f1_9,
  &see_f1_d,
  &see_f1_D,
  &see_f1_s,
  &see_f1_S,
  &see_f1_x,
  &see_f1_X,
  &see_f1_y,
  &see_f1_Y,
  NULL
};
/*---------------------------------------------------------------------------*/
void bump()
{
  init_maps();
  memcpy(hmap, pbmp->line[0], 64000);

  x = SCREEN_W / 2;
  y = SCREEN_H / 2;
  dx = bump_x;
  dy = bump_y;

  lastkey = K_d;
  do
    {
      bumpeffect(x, y);
      memcpy(pbmp->line[0], dbuffer, 64000);
      vsync();
      blit(pbmp, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
      move_focus();
      ptkeyparsetbl = tkeyparsetbl_bump;
      key_scan();
      rest(bump_delay);
    }
  while ((lastkey == K_d) || (lastkey == K_D) ||
	 (lastkey == K_s) || (lastkey == K_S) ||
	 (lastkey == K_x) || (lastkey == K_X) ||
	 (lastkey == K_y) || (lastkey == K_Y));
  if (lastkey == K_ESC)
    {
      esc_hit = 1;
    }
}
/*---------------------------------------------------------------------------*/
void bump_restore()
{
  keysee_insert();
}
/*---------------------------------------------------------------------------*/
void bumpeffect(int hvx, int hvy)
{
  int nx, ny;
  int rx, ry;
  int i = SCREEN_W * 1;
  int x, y;

  for (y = 1; y < (SCREEN_H - 2); y++)
    {
      for (x = 0; x < SCREEN_W; x++)
	{
	  nx = hmap[i + 1] - hmap[i - 1];
	  ny = hmap[i + SCREEN_W] - hmap[i - SCREEN_W];
	  rx = x - hvx;
	  ry = y - hvy;
	  nx -= rx;
	  ny -= ry;
	  nx += 128/bump_sort;
	  ny += 128/bump_sort;
	  if (nx > 255/bump_sort || nx < 0)
	    {
	      nx = 255/bump_sort;
	    }
	  if (ny > 255/bump_sort || ny < 0)
	    {
	      ny = 255/bump_sort;
	    }
	  dbuffer[i] = litemap[nx + ny * 256];
	  i++;
	}
    }
}
/*---------------------------------------------------------------------------*/
void init_maps()
{
  int x, y;
  float nx, ny, nz;

  for (y = 0; y < (256); y++)
    {
      for (x = 0; x < (256); x++)
	{
	  nx = (x - 128) / 128.0;
	  ny = (y - 128) / 128.0;
	  nz = 1 - sqrt(nx * nx + ny * ny);
	  if (nz < 0)
	    {
	      nz = 0;
	    }
	  litemap[x + y * 256] = nz * 256;
	}
    }
}
/*---------------------------------------------------------------------------*/
void keysee_f1_0()
{
  keysee_f1_gen("f1_0");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_1()
{
  keysee_f1_gen("f1_1");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_2()
{
  keysee_f1_gen("f1_2");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_3()
{
  keysee_f1_gen("f1_3");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_4()
{
  keysee_f1_gen("f1_4");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_5()
{
  keysee_f1_gen("f1_5");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_6()
{
  keysee_f1_gen("f1_6");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_7()
{
  keysee_f1_gen("f1_7");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_8()
{
  keysee_f1_gen("f1_8");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_9()
{
  keysee_f1_gen("f1_9");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_D()
{
  paralong(&bump_delay, BUMP_DELAY_MIN, BUMP_DELAY_MAX, BUMP_DELAY_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f1_S()
{
  paraint(&bump_sort, BUMP_SORT_MIN, BUMP_SORT_MAX, BUMP_SORT_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f1_X()
{
  paraint(&bump_x, BUMP_X_MIN, BUMP_X_MAX, BUMP_X_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f1_Y()
{
  paraint(&bump_y, BUMP_Y_MIN, BUMP_Y_MAX, BUMP_Y_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f1_d()
{
  paralong(&bump_delay, BUMP_DELAY_MIN, BUMP_DELAY_MAX, BUMP_DELAY_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f1_gen(char s[256])
{
  int pi;
  char **tps;

  bump_restore();
  tps = get_config_argv("[See]", s, &pi);
  bump_delay = atoi(tps[1]);
  bump_sort = atoi(tps[2]);
  bump_x = atoi(tps[3]);
  bump_y = atoi(tps[4]);
  bump();
}
/*---------------------------------------------------------------------------*/
void keysee_f1_s()
{
  paraint(&bump_sort, BUMP_SORT_MIN, BUMP_SORT_MAX, BUMP_SORT_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f1_x()
{
  paraint(&bump_x, BUMP_X_MIN, BUMP_X_MAX, BUMP_X_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f1_y()
{
  paraint(&bump_y, BUMP_Y_MIN, BUMP_Y_MAX, BUMP_Y_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void move_focus()
{
  x += dx;
  y += dy;
  if (x < 10)
    {
      dx = +bump_x;
    }
  if (x > 310)
    {
      dx = -bump_x;
    }
  if (y < 10)
    {
      dy = +bump_y;
    }
  if (y > 190)
    {
      dy = -bump_y;
    }
}
