/* Copyright (C) 1998 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <errno.h>
#include <libc/dosio.h>

static unsigned char map[] = {
  /* 00-07 */ 0, EINVAL, ENOENT, ENOENT, EMFILE, EACCES, EBADF, EFAULT,
  /* 08-0f */ ENOMEM, EFAULT, EFAULT, EINVAL, EINVAL, EINVAL, EINVAL, ENODEV,
  /* 10-17 */ EBUSY, EXDEV, ENFILE, EROFS, ENXIO, ENXIO, EINVAL, EIO,
  /* 18-1f */ EINVAL, EIO, EIO, EIO, EIO, EIO, EIO, EIO,
  /* 20-27 */ EPERM, EPERM, ENXIO, EBADF, ENOLCK, EINVAL, EIO, ENOSPC,
  /* 28-2f */ EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL,
  /* 30-37 */ EINVAL, EINVAL, ENOSYS, EIO, EINVAL, EINVAL, EBUSY, ENXIO,
  /* 38-3f */ EINVAL, EIO, EIO, EIO, EIO, EAGAIN, EINVAL, ENOSPC,
  /* 40-47 */ EINVAL, EPERM, ENXIO, EINVAL, EINVAL, EINVAL, EBUSY, ENXIO,
  /* 48-4f */ EINVAL, ENOSYS, ENXIO, EPERM, EPERM, ENOSPC, EPERM, EINVAL,
  /* 50-57 */ EEXIST, EINVAL, EPERM, EINTR, EPERM, EPERM, EINVAL, EINVAL,
  /* 58-5f */ EIO, ENOSYS, ENOSYS, ENXIO, ENXIO, EINVAL, EINVAL, ENXIO,
  /* 60-67 */ EINVAL, EINVAL, EINVAL, EINVAL, EPERM, ENXIO, ENOMEM, EINVAL,
  /* 68-6f */ ENODEV, ESRCH, EPERM, ENODEV, EBUSY, EPIPE, ENOENT, ENOSPC,
  /* 70-77 */ ENOSPC, ENFILE, EBADF, EFAULT, EIO, ENOTTY, EINVAL, ENOSYS,
  /* 78-7f */ EINVAL, EIO, EINVAL, EFAULT, ENOSYS, ENOENT, EINVAL, EINVAL,
  /* 80-87 */ ECHILD, EAGAIN, EINVAL, ESPIPE, ESPIPE, EXDEV, EXDEV, EXDEV,
  /* 88-8f */ ENODEV, ENODEV, EXDEV, EXDEV, EXDEV, EXDEV, EBUSY, EEXIST,
  /* 90-97 */ EACCES, ENOTEMPTY, EBUSY, EBUSY, EBUSY, EXDEV, EIO, EIO,
  /* 98-9f */ EPERM, EINVAL, ENAMETOOLONG, EAGAIN, EPERM, EINVAL, EINVAL, EFAULT,
  /* a0-a7 */ EFAULT, EINVAL, EPERM, EIO, EAGAIN, EIO, EINVAL, EINVAL,
  /* a8-af */ EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL,
  /* b0-b7 */ ENXIO, ENXIO, ENODEV, EINVAL, ENOLCK, EIO, EINVAL, ENOMEM,
  /* b8-bf */ ECHILD, EAGAIN, EINVAL, EINVAL, ENOEXEC, ENOEXEC, ENOEXEC, ENOEXEC,
  /* c0-c7 */ ENOEXEC, ENOEXEC, ENOEXEC, ENOEXEC, EPERM, EPERM, ENOEXEC, ENOEXEC,
  /* c8-cf */ ENOEXEC, ENOEXEC, ENOEXEC, EINVAL, EINVAL, ENXIO, ENAMETOOLONG, EBUSY,
  /* d0-d7 */ ENAMETOOLONG, EINVAL, EINVAL, ENOSYS, EACCES, EINVAL, EAGAIN, EINVAL,
  /* d8-df */ EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL,
  /* e0-e7 */ EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, ENXIO, EBUSY,
  /* e8-ef */ EAGAIN, EPIPE, EIO, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL,
  /* f0-f7 */ EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL,
  /* f8-ff */ EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, EINVAL, ENXIO
	    };

int
__doserr_to_errno(int doserr)
{
  _doserrno = doserr;
  if (doserr >= 0 && doserr < sizeof(map)/sizeof(map[0]))
    return map[doserr];
  return EINVAL;
}
