/* Project SWORD
   V2.0

   SubSystem : Management of the Sound cards
   File      : Src/ToolBox/Sound/SBlaster.H
   ErrNos    : 200..299
   Author    : Eric NICOLAS
   Overview  : Sound blaster 16+ driver
   UpDate    : Oct 02, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "ToolBox/Sound/SBlaster.H"
#ifndef __TURBOC__
#include <pc.h>
#endif

// ===== Global Variables ===================================================

boolean SB_Present;

// ===== Local Variables ====================================================

word SB_Adr;
word SB_IntNo;
byte SB_DMA8;
byte SB_DMA16;

//---------------------------------------------------------------------------
//  DSP_Read : Lecture du DSP

byte DSP_Read(void)
{ while( !(inportb(SB_Adr+0x0E) & 0x80) ) ;
  return inportb(SB_Adr+0x0A);
}

//---------------------------------------------------------------------------
// DSP_Write : Ecriture sur DSP

void DSP_Write(byte V)
{ while( inportb(SB_Adr+0x0C) & 0x80 ) ;
  outportb( SB_Adr+0x0C, V);
}

//---------------------------------------------------------------------------
// DSP_Reset : Tente d'initialiser le DSP  l'adresse SB_Adr. Renvoie 1 si OK

int DSP_Reset(void)
{ long Dep;

  outportb(SB_Adr+0x06, 0x01);
  Delay(1);
  outportb(SB_Adr+0x06, 0x00);

  Dep=GetTime();
  do
  { if (inportb(SB_Adr+0x0A)==0xAA) return 1;
  } while (GetTime()==Dep);
  return 0;
}

//---------------------------------------------------------------------------
// SB_Detect : Dtecte le chip DSP et les autres renseignements

int SB_Detect(void)
{ word Adr;
  byte DSP_VerHi, DSP_VerLo;
  char Str[100];
  char Ch;
  int  x=wherex(), y=wherey();
  int  Index;
  byte DMAresult;
  // Dtecte le DSP
  Adr=0;
  SB_Adr=0x210;
  do
  { gotoxy(x,y);
    cprintf("Scanning DSP at : 0x%3X",SB_Adr);
    if (DSP_Reset()) Adr=SB_Adr;
    SB_Adr+=0x10;
  } while((SB_Adr<=0x280)&&(!Adr));
  if (!Adr)
  { gotoxy(x,y); clreol();
    cprintf("DSP not detected.\r\n");
    return 0;
  }
  SB_Adr=Adr;
  gotoxy(x,y); clreol();
  cprintf("DSP detected at adress : 0x%3x\r\n",SB_Adr);
  // Demande la version DSP
  DSP_Write(0xE1);
  DSP_VerHi=DSP_Read();
  DSP_VerLo=DSP_Read();
  if (DSP_VerHi<4)
  { gotoxy(x,y); clreol();
    printf("Not a SB16+ DSP.\n");
    return 0;
  }
  if (DSP_VerLo>=12) strcpy(Str,"SB AWE32");
  else
    if (DSP_VerLo>=11) strcpy(Str,"SB16 SCSI-2");
    else strcpy(Str,"SB16");
  printf("                        DSP version V%d.%d -> %s\n",
         DSP_VerHi, DSP_VerLo, Str);
  // Demande le copyright du DSP
  Index=0;
  DSP_Write(0xE3);
  Ch=DSP_Read();
  while(Ch)
  { Str[Index]=Ch;
    Index++;
    Ch=DSP_Read();
  }
  Str[Index]=0;
  printf("                        %s\n",Str);
  // Demande la ligne d'IRQ
  outportb(SB_Adr+0x04,0x80);
  switch(inportb(SB_Adr+0x05) & 0x0F)
  { case 0 :
      printf("                        IRQ Line not set\n");
      return 0;
    case 1 : SB_IntNo=2;   break;
    case 2 : SB_IntNo=5;   break;
    case 4 : SB_IntNo=7;   break;
    case 8 : SB_IntNo=10;  break;
  }
  printf("                        IRQ Line       = 0x%X\n",SB_IntNo);
  // Demande le canal DMA 8bits
  outportb(SB_Adr+0x04,0x81);
  DMAresult=inportb(SB_Adr+0x05);
  switch(DMAresult & 0x0B)
  { case 0 :
      printf("                        DMA 8bits channel Line not set\n");
      return 0;
    case 0x01 : SB_DMA8=0;     break;
    case 0x02 : SB_DMA8=1;     break;
    case 0x08 : SB_DMA8=3;     break;
  }
  printf("                        DMA 8bits      = Channel 0x%X\n",SB_DMA8);
  switch(DMAresult & 0xE0)
  { case 0 :
      printf("                        DMA 16bits channel Line not set\n");
      return 0;
    case 0x20 : SB_DMA16=5;    break;
    case 0x40 : SB_DMA16=6;    break;
    case 0x80 : SB_DMA16=7;    break;
  }
  printf("                        DMA 16bits     = Channel 0x%X\n",SB_DMA16);
  return 1;
}

//---------------------------------------------------------------------------
// InitSBlast

void InitSBlaster(void)
{// AddErrorHandler(ErrorMessage);
  cprintf("Sound-Blaster driver  : ");
  if (SB_Detect()) SB_Present=TRUE; else SB_Present=FALSE;
}

//---------------------------------------------------------------------------
// DoneSBlast

void DoneSBlaster(void)
{
}
