/* Project SWORD
   V2.0

   SubSystem : Mathematical toolbox
   File      : LibSrc/ToolBox/Math/Complex.CC
   Author    : Eric NICOLAS
   Overview  : Complex arithmetics in signle and double precision
   UpDate    : May 06, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <math.h>
#include "ToolBox/Math/Complex.H"

complex NUL(0,0);
complex cI(0,1);
complex cJ(-0.5,1.73205080757/2);
complex cPi(M_PI,0);
complex cE(M_E,0);

// ----- Class complex

float norm(complex& c)
{ return c.re*c.re+c.im*c.im;
}

float abs(complex& c)
{ return sqrt(c.re*c.re+c.im*c.im);
}

complex sqrt(complex& c)
{ float rD=sqrt(c.re*c.re+c.im*c.im);
  if (c.im<0) return complex( sqrt((c.re+rD)/2), - sqrt((-c.re+rD)/2) );
	 else return complex( sqrt((c.re+rD)/2),   sqrt((-c.re+rD)/2) );
}

complex operator/(complex& c1, complex& c2)
{ float n=c2.re*c2.re+c2.im*c2.im;
  return complex( (c1.re*c2.re+c1.im*c2.im)/n,
		  (c2.re*c1.im-c2.im*c1.re)/n
		);
}

complex &complex::operator*=(complex& c)
{ float fr=re*c.re-im*c.im;
  float fi=re*c.im+im*c.re;
  re=fr;
  im=fi;
  return *this;
}

complex &complex::operator/=(complex& c)
{ float n=c.re*c.re+c.im*c.im;
  float fr=(re*c.re+im*c.im)/n;
  float fi=(c.re*im-re*c.im)/n;
  re=fr;
  im=fi;
  return *this;
}

complex operator/(float    f,  complex& c)
{ return complex(f)/c;
}


complex exp(complex& c)
{ return complex(exp(c.re)*cos(c.im),exp(c.re)*sin(c.im));
}

complex sin(complex& c)
{ return (exp(cI*c)-exp(-cI*c))/(2*cI);
}

complex cos(complex& c)
{ return (exp(cI*c)+exp(-cI*c))/2;
}

complex tan(complex& c)
{ return sin(c)/cos(c);
}

complex sinh(complex& c)
{ return (exp(c)-exp(-c))/2;
}

complex cosh(complex& c)
{ return (exp(c)+exp(-c))/2;
}

complex tanh(complex& c)
{ return sinh(c)/cosh(c);
}

float arg(complex& c)
{ if ((c.re==0)&&(c.im==0)) return 0;
  return atan2(c.im,c.re);
}

complex pow(complex& x, complex& y)
{ return exp(y*log(x));
}

complex log(complex& c)
{ return complex(log(abs(c)),arg(c));
}

complex log10(complex& c)
{ return log(c)/log(10);
}

// ----- Classe lcomplex

double norm(lcomplex& c)
{ return c.re*c.re+c.im*c.im;
}

double abs(lcomplex& c)
{ return sqrt(c.re*c.re+c.im*c.im);
}

lcomplex operator/(lcomplex& c1, lcomplex& c2)
{ double n=c2.re*c2.re+c2.im*c2.im;
  return lcomplex( (c1.re*c2.re+c1.im*c2.im)/n,
		  (c2.re*c1.im-c2.im*c1.re)/n
		);
}

lcomplex &lcomplex::operator*=(lcomplex& c)
{ double fr=re*c.re-im*c.im;
  double fi=re*c.im+im*c.re;
  re=fr;
  im=fi;
  return *this;
}

lcomplex &lcomplex::operator/=(lcomplex& c)
{ double n=c.re*c.re+c.im*c.im;
  double fr=(re*c.re+im*c.im)/n;
  double fi=(c.re*im-re*c.im)/n;
  re=fr;
  im=fi;
  return *this;
}

lcomplex operator/(double f,  lcomplex& c)
{ return lcomplex(f)/c;
}

double arg(lcomplex& c)
{ if ((c.re==0)&&(c.im==0)) return 0;
  return atan2(c.im,c.re);
}
