/* Project SWORD
   V2.0

   SubSystem : ToolBox for 3D graphics
   File      : LibSrc/ToolBox/Graph3D/Facet.CC
   Author    : Eric NICOLAS
   Overview  : Object TFacet
   UpDate    : Mar 18, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <math.h>

#include "Common/Common.H"
#include "Mecanism/Collec.H"
#include "ToolBox/Graph3D/Point3D.H"
#include "ToolBox/Graph3D/Facet.H"

// ----- Object TFacet

// Constructors

TFacet::TFacet()
{ _P1=_P2=_P3=NULL;
}

TFacet::TFacet(TPoint3D* P1, TPoint3D* P2, TPoint3D* P3)
{ _P1=P1;
  _P2=P2;
  _P3=P3;
}

TFacet::TFacet(TFacet& F)
{ _P1=F._P1;
  _P2=F._P2;
  _P3=F._P3;
}

// Informations about facet

TPoint3D TFacet::N()
{ return ((*_P2)-(*_P1))^((*_P3)-(*_P1));
}

TPoint3D TFacet::Barycenter()
{ return ((*_P1)+(*_P2)+(*_P3))/3;
}
