/* Project SWORD
   V2.0

   SubSystem : Screen graphics management
   File      : Src/Gadgets/Mapping.CC
   Author    : Olivier PAYEN, Eric NICOLAS
   Overview  : TMapping Object : How to display bitmap
   UpDate    : Nov 06, 1994

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"

// ===== Variables locales

int IconeColorTable[17];
int SysIconeColorTable[5][5];

void InitMapping()
{ int i,j;
  IconeColorTable[0]=16;
  for(i=0;i<15;i++) IconeColorTable[i+1]=NoSysColor[i];
  for(j=0;j<5;j++)
  { SysIconeColorTable[j][0]=4;
    for(i=0;i<4;i++)
      SysIconeColorTable[j][i+1]=NoSysColor[SysColorGroup[j][i]];
  }
}

void DoneMapping()
{ }

// ===== TMapping

TMapping::TMapping()
{ Init();
}

TMapping::TMapping(int L, int H, char *Description, int *ColorTable)
{ Width=L;
  Height=H;
  if (Description!=NULL) Init(GrBuildPixmap(Description,L,H,ColorTable));
                    else Init();
}

TMapping::~TMapping()
{ if (Drawing!=NULL) GrDestroyPattern(Drawing);
}

void TMapping::Init(GrPattern *_Drawing)
{ Drawing=_Drawing;
  Options=MAP_Delete;
}

void TMapping::Draw(int X, int Y)
{ if (Drawing!=NULL)
  { GrContext *Temp=GrCreateContext(Width,Height,NULL,NULL);
    GrVidRAM   Buf;
    memcpy(&Buf,Temp,sizeof(GrVidRAM));
    memcpy(Temp,&(Drawing->gp_pxp_source),sizeof(GrVidRAM));
    GrBitBlt(NULL,X,Y,Temp,0,0,Width,Height,0);
    memcpy(Temp,&Buf,sizeof(GrVidRAM));
    GrDestroyContext(Temp);
  }
}

void TMapping::SetColorGroup(char )
{ }

void TMapping::Read(TDisk *file)
{ ReadInt(file,&Width);
  ReadInt(file,&Height);
}

void TMapping::Write(TDisk *file)
{ WriteInt(file,Width);
  WriteInt(file,Height);
}

// ===== TIcone

TIcone::TIcone() : TMapping()
{ Init();
}

TIcone::TIcone(int L, int H, char *Description) :
   TMapping(L,H,Description,IconeColorTable)
{ Init();
}

void TIcone::Init()
{ }

// ===== TSysIcone

TSysIcone::TSysIcone() : TMapping()
{ Init();
}

TSysIcone::TSysIcone(int L, int H, char *_Description) :
   TMapping(L,H,_Description,SysIconeColorTable[0])
{ Init(_Description);
}

void TSysIcone::Init(char *_Description)
{ Description=_Description;
  ColorGroup=0;
}

TSysIcone::~TSysIcone()
{ if (Options & MAP_DelDescription) delete Description;
}

void TSysIcone::SetColorGroup(char _ColorGroup)
{ if (ColorGroup!=_ColorGroup)
  { ColorGroup=_ColorGroup;
    if (Drawing!=NULL) GrDestroyPattern(Drawing);
    Drawing=GrBuildPixmap(Description,Width,Height,SysIconeColorTable[ColorGroup]);
  }
}

void TSysIcone::Read(TDisk *file)
{ TMapping::Read(file);
  if (Options & MAP_DelDescription) delete Description;
  Description=new char[Height*Width];
  file->Read(Description,Height*Width*sizeof(char));
  SetColorGroup(ColorGroup);
  Options|=MAP_DelDescription;
}

void TSysIcone::Write(TDisk *file)
{ TMapping::Write(file);
  file->Write(Description,Height*Width*sizeof(char));
}

// ===== TMappingObject

short RegTMappingObject;
char *IdentTMappingObject = "TMappingObject";

TMappingObject::TMappingObject() : TZone()
{ Init();
}

TMappingObject::TMappingObject(int X, int Y, TMapping *_Mapp) :
   TZone(X,Y,X+_Mapp->Width-1,Y+_Mapp->Height-1)
{ Init(_Mapp);
}

void TMappingObject::Init(TMapping *_Mapp)
{ Register=RegTMappingObject;
  Ident=IdentTMappingObject;
  Mapp=_Mapp;
}

TMappingObject::~TMappingObject(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

void TMappingObject::Done(void)
{ if (Mapp!=NULL)
    if (Mapp->Options & MAP_Delete) delete Mapp;
  TZone::Done();
}

void TMappingObject::Draw(TRect& )
{ if (Mapp!=NULL)
    Mapp->Draw(Corner.X(),Corner.Y());
}

void TMappingObject::SetColorGroup(char ColorGroup)
{ if (Mapp!=NULL) Mapp->SetColorGroup(ColorGroup);
  TZone::SetColorGroup(ColorGroup);
}
