/* Project SWORD
   V2.0

   SubSystem : Little usefull graphical objects
   File      : Src/Gadgets/StatText.CC
   Author    : Olivier PAYEN
   Overview  : Object TStaticText : a non interactive text string
   UpDate    : Oct 23, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"
#include "Drawings/Drawings.H"
#include "Gadgets/Gadgets.H"

// ----- TStaticText

short RegTStaticText;
char *IdentTStaticText = "TStaticText";

// Constructors

TStaticText::TStaticText() : TZone()
{ Init();
}

TStaticText::TStaticText(int X, int Y, int L, int H, char* _Text) :
	     TZone(X,Y,L,H)
{ Init(_Text);
}

TStaticText::TStaticText(TRect& R, char* _Text) : TZone(R)
{ Init(_Text);
}

TStaticText::~TStaticText(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

void TStaticText::Done(void)
{ if (Text!=NULL) free(Text);
  TZone::Done();
}

void TStaticText::Init(char* _Text)
{ Register=RegTStaticText;
  Ident=IdentTStaticText;
  if (_Text!=NULL)
  { Text=strdup(_Text);
    FontSystem->TruncStr(Where.L()-8,_Text,Text);
    Yt=(Where.H()-FontSystem->HeightStr(Text))/2;
  }
  else Text=NULL;
}

// Graphics

void TStaticText::Draw(TRect &)
{ SetSysColor(GetColor(LightGray));
  Bar(0,0,Where.L()-1,Where.H()-1);
  SetSysColor(GetColor(Black));
  if (Text!=NULL) PutStr(4,Yt,Text,FontSystem);
}

// Objects streams

void TStaticText::Read(TDisk *file)
{ TZone::Read(file);
  ReadString(file,&Text);
}

void TStaticText::Write(TDisk *file)
{ TZone::Write(file);
  WriteString(file,Text);
}
