/* Project SWORD
   V2.0

   SubSystem  : Little usefull graphical objects
   File       : Src/Gadgets/Scroller.CC
   Author     : Eric NICOLAS
   Overview   : TScroller object
   UpDate     : Nov 12, 1995

** Copyright (C) 1993,1995 Eric NICOLAS
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"
#include "Drawings/Drawings.H"
#include "Gadgets/Gadgets.H"

// --- TScroller object

short RegTScroller;
char *IdentTScroller = "TScroller";

TScroller::TScroller() : TZone()
{ Init(100,100,NULL,NULL);
}

TScroller::TScroller(int X, int Y, int L, int H, int WL, int WH,
                     TLift *_Horiz, TLift *_Vert) : TZone(X,Y,L,H)
{ Init(WL,WH,_Horiz,_Vert);
}

TScroller::TScroller(TRect& R, int WL, int WH, TLift *_Horiz, TLift *_Vert) : TZone(R)
{ Init(WL,WH,_Horiz,_Vert);
}

void TScroller::Init(int WL, int WH,TLift *_Horiz, TLift *_Vert)
{ Register=RegTScroller;
  Ident=IdentTScroller;
  Options|=opCSHiX | opCSHiY;
  //
  Horiz=_Horiz;
  if (Horiz!=NULL) Horiz->SetConnectedObject(this);
  Vert=_Vert;
  if (Vert!=NULL)  Vert->SetConnectedObject(this);
  WideL=WL;
  WideH=WH;
  DecX=0;
  DecY=0;
  StepX=5;
  StepY=5;
  SynchroLifts();
}

void TScroller::SynchroLifts(void)
{ if (Horiz)
  { Horiz->SetRealPos(0,WideL-1);
    Horiz->SetViewPos(DecX,DecX+Where.L()-1);
    Horiz->SetIncStep(StepX);
  }
  if (Vert)
  { Vert->SetRealPos(0,WideH-1);
    Vert->SetViewPos(DecY,DecY+Where.H()-1);
    Vert->SetIncStep(StepY);
  }
}

boolean TScroller::HandleCommand(long Command, char Info08b, short Info16b, long Info32b, void *InfoPtr)
{ int Dummy;
  if (TZone::HandleCommand(Command,Info08b,Info16b,Info32b,InfoPtr)) return TRUE;
  switch(Command)
  { case cmLiftHorizMoved :
      if (InfoPtr==this)
      { Horiz->GetViewPos(DecX,Dummy);
        Invalidate();
        return TRUE;
      }
      break;
    case cmLiftVertMoved :
      if (InfoPtr==this)
      { Vert->GetViewPos(DecY,Dummy);
        Invalidate();
        return TRUE;
      }
      break;
  }
  return FALSE;
}

void TScroller::DoChangeSize(int dX, int dY)
{ TZone::DoChangeSize(dX,dY);
  SynchroLifts();
}

void TScroller::Draw(TRect& Clip)
{ TZone::Draw(Clip);
  char Temp[100];
  SetSysColor(GetColor(Black));
  Bar(0,0,Where.L()-1,Where.H()-1);
  SetSysColor(GetColor(LightGray));
  FontSystem->BackColor(GetColor(LightGray));
  sprintf(Temp,"Wide Size.. : (%3d-%3d)",WideL,WideH);
  PutStr(10,10,Temp,FontListing);
  sprintf(Temp,"Real Size.. : (%3d-%3d)",Where.L(),Where.H());
  PutStr(10,30,Temp,FontListing);
  sprintf(Temp,"Pos........ : (%3d-%3d)",DecX,DecY);
  PutStr(10,50,Temp,FontListing);
  FontSystem->BackColor(FBack_NOCOLOR);
}
