/* Project SWORD
   V2.0

   SubSystem : Little usefull graphical objects
   File      : Src/Gadgets/Edition.CC
   Author    : Eric NICOLAS
   Overview  : EditLine objects
   UpDate    : May 22, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"
#include "Drawings/Drawings.H"
#include "Gadgets/Gadgets.H"

short RegTEditLine;
short RegTEditReal;
short RegTEditInteger;
char *IdentTEditLine    = "TEditLine";
char *IdentTEditReal    = "TEditReal";
char *IdentTEditInteger = "TEditInteger";

// ----- TEditLine

// Constructors

TEditLine::TEditLine() : TZone()
{ Init();
}

TEditLine::TEditLine(int X, int Y, int L, char Lt, char Dpl) :
  TZone(X,Y,L,22)
{ Init(Lt,Dpl);
}

TEditLine::TEditLine(TRect& R, char Lt, char Dpl) :
  TZone(R.X1(),R.Y1(),R.L(),22)
{ Init(Lt,Dpl);
}

TEditLine::~TEditLine(void)
{ delete TempText;
  delete NewText;
  delete Text;
}

void TEditLine::Init(char Lt, char Dpl)
{ Register=RegTEditLine;
  Ident=IdentTEditLine;

  Options|=opSelectable;
  LengthText=Lt;
  Deplacement=Dpl;
  BegText=0;
  Cursor=0;
  Text    =new char[Lt+1];
  NewText =new char[Lt+1];
  TempText=new char[Lt+12];
  *Text=0;
}

/*
void TEditLine::Draw(void)
{ if (Status & sfVisible)
  { DrawBegin();
    SetColor(GetColor(3));
	Bar(0,0,Size.X-1,Size.Y-1);
	SetColor(GetColor(1));
	LineX(0,0,Size.X-1);
	LineX(0,1,Size.X-2);
	LineY(0,2,Size.Y-2);
	LineY(1,2,Size.Y-3);
	SetColor(GetColor(2));
	LineX(1,Size.Y-2,Size.X-2);
	LineY(Size.X-2,2,Size.Y-3);
	DrawText();
//    TView::Draw();
    if (Focus()) DrawCursor();
    DrawEnd();
  }
  else
  { // Dans le cas o on ne trace pas, il faut malgr tout
    // Calculer LengthDraw afin de pouvoir effectuer la routine
    // CursorEnd()
    strcpy(TempText,Text+BegText);
    StrTrunc(TempText,Size.X-8,TempText);
    LengthDraw=strlen(TempText);
  }
}

void TEditLine::DrawText(void)
{ int   DX;
  if (Status & sfVisible)
  { DrawBegin();
    UseFont("SYSTEM");
    strcpy(TempText,Text+BegText);
    StrTrunc(TempText,Size.X-8,TempText);
    LengthDraw=strlen(TempText);
    SetBackColor(GetColor(3));
    SetColor(GetColor(0));
    strcat(TempText," ");
	 DX=PutStr(4,3,TempText,foFill);
	 SetColor(GetColor(3));
	 Bar(4+DX,3,Size.X-5,Size.Y-5);
    DrawEnd();
  }
}

void TEditLine::SetData(void* Ptr)
{ memmove(Text,Ptr,LengthText+1);
  Cursor=0;
  BegText=0;
  Draw();
  CursorEnd();
}

void TEditLine::GetData(void* Ptr)
{ memmove(Ptr,Text,LengthText+1);
}

int TEditLine::DataSize(void)
{ return TView::DataSize()+LengthText+1;
}

void TEditLine::DrawCursor(void)
{ int X,L;
  if (Status & sfVisible)
  { DrawBegin();
    UseFont("SYSTEM");
    SetWriteMode(wmXOR);
    memset(TempText,0,LengthText+1);
    strncpy(TempText,Text+BegText,Cursor-BegText);
	 X=2+StrLength(TempText);
	 SetColor(7);
	 if (CursorIns) Rectangle(X,2,X+1,Size.Y-3);
	 else
	 { if (Cursor<strlen(Text)) L=CharLength(Text[Cursor]);
		                    else L=CharLength('E');
 		Rectangle(X,2,X+L+1,Size.Y-3);
	 }
	 SetWriteMode(wmReplace);
	 DrawEnd();
  }
}

void TEditLine::Select(void)
{ if (!(Status & sfSelected))
  { TView::Select();
    if (Focus()) DrawCursor();
  }
}

void TEditLine::UnSelect(void)
{ if (Status & sfSelected)
  { if (Focus()) DrawCursor();
    TView::UnSelect();
  }
}

#pragma argsused
int TEditLine::ValidInput(int& ScanCode)
{ return TRUE;
}

int TEditLine::ValidResult(void)
{ return TRUE;
}

void TEditLine::CursorRight(void)
{ if (Cursor<strlen(Text))
  { DrawCursor();
    Cursor++;
    if ((BegText+LengthDraw<=Cursor) && (Cursor!=strlen(Text)))
    { BegText+=Deplacement;
      DrawText();
    }
    DrawCursor();
  }
}

void TEditLine::CursorLeft(void)
{ if (Cursor>0)
  { DrawCursor();
    Cursor--;
    if (Cursor<BegText)
    { if (BegText<Deplacement) BegText=0;
                          else BegText-=Deplacement;
      DrawText();
    }
    DrawCursor();
  }
}

void TEditLine::CursorEnd(void)
{ if (Cursor!=strlen(Text))
  { if (Focus()) DrawCursor();
    Cursor=strlen(Text);
    if (Cursor>BegText+LengthDraw)
    { do
      { BegText+=Deplacement;
        strcpy(TempText,Text+BegText);
        StrTrunc(TempText,Size.X-8,TempText);
        LengthDraw=strlen(TempText);
      } while(Cursor>BegText+LengthDraw);
      DrawText();
    }
    if (Focus()) DrawCursor();
  }
}

void TEditLine::CursorHome(void)
{ if (Cursor)
  { DrawCursor();
    Cursor=0;
    if (BegText)
    { BegText=0;
      DrawText();
    }
    DrawCursor();
  }
}

void TEditLine::Insertion(char C)
{ if (strlen(Text)<LengthText)
  { *TempText=C;
    *(TempText+1)=0;
    strcat(TempText,Text+Cursor);
    strcpy(NewText,Text);
    strcpy(NewText+Cursor,TempText);
    if (ValidResult())
    { DrawCursor();
      Cursor++;
      strcpy(Text,NewText);
      strcpy(TempText,Text+BegText);
      StrTrunc(TempText,Size.X-8,TempText);
      LengthDraw=strlen(TempText);
      if (BegText+LengthDraw<Cursor) BegText+=Deplacement;
      DrawText();
      DrawCursor();
      Modified();
    }
  }
}

void TEditLine::Recover(char C)
{ strcpy(NewText,Text);
  *(NewText+Cursor)=C;
  if (ValidResult())
  { DrawCursor();
    Cursor++;
    strcpy(Text,NewText);
    strcpy(TempText,Text+BegText);
    StrTrunc(TempText,Size.X-8,TempText);
    LengthDraw=strlen(TempText);
    if ((BegText+LengthDraw<=Cursor) && (Cursor!=strlen(Text))) BegText+=Deplacement;
    DrawText();
    DrawCursor();
    Modified();
  }
}

void TEditLine::BackSpace(void)
{ if (Cursor)
  { memset(NewText,0,LengthText+1);
    strncpy(NewText,Text,Cursor-1);
    strcat(NewText,Text+Cursor);
    if (ValidResult())
    { DrawCursor();
      strcpy(Text,NewText);
      Cursor--;
      if (Cursor<BegText)
        if (BegText<Deplacement) BegText=0;
        else BegText-=Deplacement;
      DrawText();
      DrawCursor();
      Modified();
    }
  }
}

void TEditLine::Delete(void)
{ if (Cursor!=strlen(Text))
  { memset(NewText,0,LengthText+1);
    strncpy(NewText,Text,Cursor);
    strcat(NewText,Text+Cursor+1);
    if (ValidResult())
    { DrawCursor();
      strcpy(Text,NewText);
      DrawText();
      DrawCursor();
      Modified();
    }
  }
}

void TEditLine::HandleEvent(TEvent* Event)
{ TView::HandleEvent(Event);
  switch(Event->What)
  { case evCommand :
      switch(Event->Command)
      { case cmComeToDeskArea :
        case cmLeaveDeskArea  :
        case cmSelect         :
        case cmUnSelect       :
        case cmDrawCursor     :
          if (Focus()) DrawCursor();
          break;
      }
      break;
    case evKeyDown :
      if (Focus())
        switch(Event->ScanCode)
        { case ScanRightArrow : CursorRight(); ClearEvent(Event); break;
          case ScanLeftArrow  : CursorLeft();  ClearEvent(Event); break;
//** A garder ?     ScanDownArrow  : SelectNext;
//** A garder ?     ScanUpArrow    : SelectPrevious;
          case ScanEnd        : CursorEnd();   ClearEvent(Event); break;
          case ScanHome       : CursorHome();  ClearEvent(Event); break;
          case ScanBackSpace  : BackSpace();   ClearEvent(Event); break;
          case ScanDelete     : Delete();      ClearEvent(Event); break;
          default             :
            if ((Event->ScanCode>=0x0020) && (Event->ScanCode<=0x00FF))
            { if (ValidInput(Event->ScanCode))
              { if (Cursor==strlen(Text)) Insertion(ScanToChar(Event->ScanCode));
                else
                  if (CursorIns) Insertion(ScanToChar(Event->ScanCode));
                  else Recover(ScanToChar(Event->ScanCode));
                ClearEvent(Event);
              }
             }
             break;
        } // switch(ScanCode)
      break;
    case evMouseLDown :
      UseFont("SYSTEM");
      if (Status & sfMouseIn)
      { MakeGlobal(Origin,Corner);
        if (!(Status & sfSelected)) Select();
        DrawCursor();
		if (Event->Where.X<Corner.X+4) Cursor=BegText;
        else
        { strcpy(TempText,Text+BegText);
          StrTrunc(TempText,Size.X-8,TempText);
		  while(Event->Where.X-(Corner.X+4)<StrLength(TempText))
            *(TempText+strlen(TempText)-1)=0;
          Cursor=BegText+strlen(TempText);
        }
        DrawCursor();
      }
      break;
  } // switch(What)
}
*/
// ----- Mthodes de TEditReal

// Constructors

TEditReal::TEditReal() : TEditLine()
{ Init();
}

TEditReal::TEditReal(int X, int Y, int L) : TEditLine(X,Y,L,40,5)
{ Init();
}

TEditReal::TEditReal(TRect& R) : TEditLine(R,40,5)
{ Init();
}

void TEditReal::Init(void)
{ Register=RegTEditReal;
  Ident=IdentTEditReal;
}

void TEditReal::SetData(void* Ptr)
{ float R;
  char* P;
  memmove(&R,Ptr,sizeof(float));
  sprintf(Text,"%g",R);
  P=Text;
  while((*P)&&(*P!='.')) P++;
  if (*P=='.') *P=inPointChar;
  Cursor=0;
  BegText=0;
  Draw();
  CursorEnd();
}

void TEditReal::GetData(void* Ptr)
{ float R;
  char  *P=Text;
  while((*P)&&(*P!=inPointChar)) P++;
  if (*P==inPointChar) *P='.';
  sscanf(Text,"%g",&R);
  if (*P=='.') *P=inPointChar;
  memmove(Ptr,&R,sizeof(float));
}

int TEditReal::DataSize(void)
{ return (TView::DataSize()+sizeof(float));
}

int TEditReal::ValidInput(int& ScanCode)
{ switch(ScanCode)
  { case 0x0030 :     // '0'
    case 0x0031 :     // '1'
    case 0x0032 :     // '2'
    case 0x0033 :     // '3'
    case 0x0034 :     // '4'
    case 0x0035 :     // '5'
    case 0x0036 :     // '6'
    case 0x0037 :     // '7'
    case 0x0038 :     // '8'
    case 0x0039 :     // '9'
      break;
    case 0x0045 :     // 'E'
    case 0x0065 :     // 'e'
      ScanCode=0x0045;
      break;
    case 0x002E :    // '.'
    case 0x002C :    // ','
      ScanCode=(int)inPointChar;
      break;
    case 0x002D :   // '-'
    case 0x002B :   // '+'
      break;
    default :
      return FALSE;
  }
  return TRUE;
}

// *** Routines d'analyse syntaxique d'un rel
// Syntaxe de la grammaire : |    Ou bien
//                           [ ]  Rptition n fois, n=0,1,2...
//                           ( )  Facultation (rptition 0 ou 1 fois)
// Digit ::= '0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9'
// NP    ::= [ Digit ]
// ZP    ::=   NP ( PointChar NP )
// N     ::= ( '-' | '+' ) NP
// Z     ::= ( '-' | '+' ) ZP
// R     ::= Z ( 'E' N )

int ScanDigit(char* &P)
{ if ((*P>='0') && (*P<='9'))
  { P++;
    return TRUE;
  }
  return FALSE;
}

void ScanNP(char* &P)
{ while(ScanDigit(P)) ;
}

void ScanZP(char* &P)
{ ScanNP(P);
  if (*P==inPointChar)
  { P++;
    ScanNP(P);
  }
}

void ScanN(char* &P)
{ if ((*P=='-') || (*P=='+')) P++;
  ScanNP(P);
}

void ScanZ(char* &P)
{ if ((*P=='-') || (*P=='+')) P++;
  ScanZP(P);
}

int ScanR(char*& P)
{ ScanZ(P);
  if (*P=='E')
  { P++;
    ScanN(P);
  }
  if (*P) return FALSE;
  return TRUE;
}

int TEditReal::ValidResult(void)
{ char* P=NewText;
  if (!(*P)) return TRUE;
        else return ScanR(P);
}

// ----- Mthodes de TEditInteger

// Constructors

TEditInteger::TEditInteger() : TEditLine()
{ Init();
}

TEditInteger::TEditInteger(int X, int Y, int L) : TEditLine(X,Y,L,40,5)
{ Init();
}

TEditInteger::TEditInteger(TRect& R) : TEditLine(R,40,5)
{ Init();
}

void TEditInteger::Init(void)
{ Register=RegTEditInteger;
  Ident=IdentTEditInteger;
}

void TEditInteger::SetData(void* Ptr)
{ int R;
  memmove(&R,Ptr,sizeof(int));
  sprintf(Text,"%d",R);
  Cursor=0;
  BegText=0;
  Draw();
  CursorEnd();
}

void TEditInteger::GetData(void* Ptr)
{ int R;
  sscanf(Text,"%d",&R);
  memmove(Ptr,&R,sizeof(int));
}

int TEditInteger::DataSize(void)
{ return (TView::DataSize()+sizeof(int));
}

int TEditInteger::ValidInput(int& ScanCode)
{ switch(ScanCode)
  { case 0x0030 :     // '0'
    case 0x0031 :     // '1'
    case 0x0032 :     // '2'
    case 0x0033 :     // '3'
    case 0x0034 :     // '4'
    case 0x0035 :     // '5'
    case 0x0036 :     // '6'
    case 0x0037 :     // '7'
    case 0x0038 :     // '8'
    case 0x0039 :     // '9'
      break;
    case 0x002D :     // '-'
    case 0x002B :     // '+'
      break;
    default :
      return FALSE;
  }
  return TRUE;
}

int TEditInteger::ValidResult(void)
{ char* P=NewText;
  if (!(*P)) return TRUE;
        else
  { if ((*P=='-') || (*P=='+')) P++;
    while(*P)
    { if ((*P<'0')||(*P>'9')) return FALSE;
      P++;
    }
    return TRUE;
  }
}
