#include "Common/Common.H"
#include "Mecanism/Disk.H"
#include "ToolBox/IntList/Index.H"

int main(int , char *argv[])
{ char        FileName[200],IndexName[200];
  char        Buffer[200],Buffer2[200],Tmp;
  TDisk      *File, *FileIDX;
  int         i;
  long        NEntries=0;
  TIntListIDX Entry;
  // Begin program
  InitCommon(argv[0]);
  // Open the file
  sprintf(FileName,"%sINTLIST/INTERRUPT.LST",SwordPath);
  sprintf(IndexName,"%sINTLIST/INTERRUPT.IDX",SwordPath);
  printf("\n\nBuilding the Intlist Index...\n\n");
  printf("IntList File  : %s\n",FileName);
  printf("IntList Index : %s\n\n",IndexName);
  // Open input IntList file
  File=new TDisk(FileName,stOpen | stTextMode);
  if (Error) FatalError();
  // Create output Index file
  FileIDX=new TDisk(IndexName,stCreate);
  if (Error) FatalError();
  // Keep space for Nb of entries
  FileIDX->Write(&NEntries,sizeof(long));
  //
  while(!Error)
  { File->ReadLn(Buffer,200);
    // See if 8 first chars are all '-'
    Tmp=Buffer[8]; Buffer[8]=0;
    i=strcmp(Buffer,"--------");
    Buffer[8]=Tmp;
    if (!i)
    { // This is a separation Line
      // :: Get the category
      Entry.Category=Buffer[8];
      if (Entry.Category!='!')
      { // This a IntList entry
        // :: Get the Int No
        Tmp=Buffer[12]; Buffer[12]=0;
        sscanf(Buffer+10,"%X",&Entry.IntNo);
        Buffer[12]=Tmp;
        // :: Get First Number
        Tmp=Buffer[16]; Buffer[16]=0;
        strcpy(Entry.FstNumber,Buffer+12);
        Buffer[16]=Tmp;
        for(i=0;i<4;i++)
          if (Entry.FstNumber[i]=='-') Entry.FstNumber[i]=0;
        // :: Get Second Number
        Tmp=Buffer[22]; Buffer[22]=0;
        strcpy(Entry.SecNumber,Buffer+18);
        Buffer[22]=Tmp;
        for(i=0;i<4;i++)
          if (Entry.SecNumber[i]=='-') Entry.SecNumber[i]=0;
        Tmp=Buffer[18]; Buffer[18]=0;
        strcpy(Entry.SecReg,Buffer+16);
        Buffer[18]=Tmp;
        // Get Next line
        File->ReadLn(Buffer,200);
        // :: Fill-In Special flags
        if (Buffer[7]!='-')
        { i=7;
          while(Buffer[i]!=' ') i++;
          Buffer[i]=0;
          strcpy(Entry.Special,Buffer+7);
          Buffer[i]=' ';
          i+=2;
        }
        else
        { Entry.Special[0]=0;
          i=8;
        }
        // :: Get the Title
        while(Buffer[i]==' ') i++;
        strcpy(Entry.Title,Buffer+i);
        // :: Expand TABS in title
        RemoveTABS(Entry.Title,3);
        // :: Save File Position for line after title
        Entry.Position=File->Position();
        // Show entry found
        BuildIntListIDXDescription(&Entry, Buffer);
        sprintf(Buffer2,"%s - %s",Buffer,Entry.Title);
        Buffer2[79]=0;
        clreol();
        printf("%s\r",Buffer2);
        // Write Index entry to Index File
        FileIDX->Write(&Entry,sizeof(TIntListIDX));
        NEntries++;
      }
    }
  }
  // Write Nb of entries
  Error=0;
  FileIDX->Seek(0,stBegining);
  FileIDX->Write(&NEntries,sizeof(long));
  // Close the files
  delete FileIDX;
  delete File;
  clreol();
  printf("Index build successfully. %ld entries found\n\n",NEntries);
  // Exit
  DoneCommon();
  return 0;
}