/* Project SWORD
   V2.0

   SubSystem : Basic objects, General use mecanisms
   File      : Include/Mecanism/Event.H
   Author    : Eric NICOLAS
   Overview  : Object TEvent : an event (mouse, keyboard, command...)
   UpDate    : May 13, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _MECANISM_EVENT_H_
#define _MECANISM_EVENT_H_

struct TEvent
{ long   What;
  int    Options;
  TPoint Where;
  int    Buttons;
  int    KbStat;
  int    ScanCode;
  long   Command;
  char   Info08b;
  short  Info16b;
  long   Info32b;
  void*  InfoPtr;
  // Constructors
  TEvent();
  TEvent(TEvent& E);
};

// What can be the What field...

#define evNothing     0x0000

#define evMouseLDown  0x0001
#define evMouseRDown  0x0002
#define evMouseDown   0x0003
#define evMouseLUp    0x0004
#define evMouseRUp    0x0008
#define evMouseUp     0x000C
#define evMouseDblCl  0x0010
#define evMouseMove   0x0020
#define evMouse       0x003F

#define evKeyDown     0x0080
#define evToggleKey   0x0100
#define evKeyboard    0x0180

#define evTimeSec     0x0200
#define evTimeMin     0x0400
#define evTimeHou     0x0800
#define evTime        0x0E00
#define evDate        0x1000

#define evCommand     0x2000

#define evAuto        0x8000

#define evPositionnal 0x001F
#define evFocused     0x0080
#define evNotModal   (0x0E00 | 0x1000 | 0x0100)

// What can be Options filed...

#define evOpForward  0      // What is the sens of propagation of this event
#define evOpBackward 1      // in the lists

#endif //_MECANISM_EVENT_H_
