/* Project SWORD
   V2.0

   SubSystem : Basic objects, General use mecanisms
   File      : Include/Mecanism/BitField.H
   Author    : Eric NICOLAS
   Overview  : TBitField object : Array of bits (0 or 1 value)
   UpDate    : Nov 13, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _MECANISM_BITFIELD_H_
#define _MECANISM_BITFIELD_H_

class TBitField
{ protected:
    int   NBits;
    byte *Bytes;
  public:
    // Constructor/Destructor
    TBitField(int _NBits);
   ~TBitField(void);
    // Access to datas
  protected:
    int     BitOffset(int N);
    byte    BitMask(int N);
  public:
    boolean GetBit(int N);
    void    SetBit(int N);
    void    ClearBit(int N);
};

// Inline funcs

inline int TBitField::BitOffset(int N)
{ return N/8;
}

inline byte TBitField::BitMask(int N)
{ return (1 << (N % 8));
}

inline boolean TBitField::GetBit(int N)
{ if ((N<0)||(N>=NBits)) return FALSE;
  return (boolean)(Bytes[BitOffset(N)] & BitMask(N));
}

inline void TBitField::SetBit(int N)
{ if ((N<0)||(N>=NBits)) return;
  Bytes[BitOffset(N)]|=BitMask(N);
}

inline void TBitField::ClearBit(int N)
{ if ((N<0)||(N>=NBits)) return;
  Bytes[BitOffset(N)]&=~BitMask(N);
}

#endif // _MECANISM_BITFIELD_H_
