#include <grx.h>
#include <mousex.h>
#include <grxfont.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int numchars;
int numdisp;
int startchr;
int rows;
int cols;
int cellx;
int celly;
int xpos;
int ypos;

GrTextOption option;
GrFBoxColors colors;


void displaychars(void)
{
	int chr = startchr;
	int x = xpos;
	int y = ypos;
	int ii,jj;

	for(ii = 0; ii < rows; ii++) {
	    for(jj = 0; jj < cols; jj++) {
		GrDrawChar(chr,x,y,&option);
		x += cellx;
		chr++;
	    }
	    x = xpos;
	    y += celly;
	}
}

void displayframe(void)
{
	GrFBoxColors cc = colors;
	int x1,y1,x2,y2;
	int pos;

	GrClearScreen(colors.fbx_intcolor);
	x1 = xpos - 2;
	y1 = ypos - 2;
	x2 = x1 + cols*cellx;
	y2 = y1 + rows*celly;
	cc.fbx_intcolor = option.txo_bgcolor.v;
	GrFramedBox(x1-2,y1-2,x2+2,y2+2,GrSizeX()/160,&cc);
	for(pos = x1; pos <= x2; pos += cellx)
	    GrVLine(pos,y1,y2,option.txo_fgcolor.v);
	for(pos = y1; pos <= y2; pos += celly)
	    GrHLine(x1,x2,pos,option.txo_fgcolor.v);
}

int getpwr2(int number)
{
	int result = 1 << 14;

	while(result > number) result >>= 1;
	return(result);
}

int setup(GrFont *font)
{
	memset(&option,0,sizeof(option));
	option.txo_font = font;
	option.txo_xmag = 1;
	option.txo_ymag = 1;
	option.txo_fgcolor.v = GrBlack();
	option.txo_bgcolor.v = GrWhite();
	numchars = font->fnt_maxchar - font->fnt_minchar + 1;
	if(getpwr2(numchars) != numchars)
	    numchars = getpwr2(numchars) << 1;
	startchr = 0;
	cellx = font->fnt_isfixed ?
	    font->fnt_width + 3 :
	    PFP(font)->pf_maxwidth + 3;
	celly = font->fnt_height + 3;
	rows = (GrSizeY() - 10) / celly;
	cols = (GrSizeX() - 10) / cellx;
	if((rows == 0) || (cols == 0))
	    return(0);
	rows = getpwr2(rows);
	cols = getpwr2(cols);
	while((cols * rows) > numchars) {
	    cols >>= 1;
	    if((cols * rows) == numchars) break;
	    rows >>= 1;
	}
	xpos = (GrSizeX() - cols*cellx) / 2 + 2;
	ypos = (GrSizeY() - rows*celly) / 2 + 2;
	displayframe();
	return(1);
}

int displayfont(GrFont *font)
{
	if(!setup(font)) return(0);
	displaychars();
	getkey();
	return(1);
}

void setupcolors(void)
{
	int r = 0;
	int g = 100;
	int b = 160;

	colors.fbx_intcolor    = GrAllocColor(r,g,b);
	colors.fbx_bottomcolor = GrAllocColor((7*r)/10,(7*g)/10,(7*b)/10);
	colors.fbx_topcolor    = GrAllocColor((14*r)/10,(14*g)/10,(14*b)/10);
	colors.fbx_leftcolor   = colors.fbx_topcolor;
	colors.fbx_rightcolor  = colors.fbx_bottomcolor;
}

void usage(void)
{
	fprintf(stderr,"usage: fontdisp [-m <width>x<height>] font ...\n");
	exit(1);
}

void main(int argc,char **argv)
{
	GrFont *f;
	char *p;
	char **fonts,**fp;
	int  mode,w,h;
	int  numfonts;

	fonts = malloc(sizeof(char *) * (argc + 3));
	if(fonts == NULL) {
	    fprintf(stderr,"insufficient memory\n");
	    exit(1);
	}
	mode = GR_default_graphics;
	w = h = 0;
	numfonts = 0;
	fp = fonts;
	while(--argc > 0) {
	    if(*(p = *++argv) == '-') {
		switch(p[1]) {
		  case 'm':
		  case 'M':
		    if(p[2] != '\0') p += 2;
		    else if(--argc == 0) usage();
		    else p = *++argv;
		    if(sscanf(p,"%dx%d",&w,&h) < 2) usage();
		    if((w < 320) || (h < 200)) usage();
		    mode = GR_width_height_graphics;
		    break;
		  default:
		    usage();
		}
	    }
	    else {
		*fp++ = p;
		numfonts++;
	    }
	}
	if(numfonts == 0) {
	    *fp++ = "@:pc8x8.fnt";
	    *fp++ = "@:pc8x14.fnt";
	    *fp++ = "@:pc8x16.fnt";
	    numfonts = 3;
	}
	GrSetMode(mode,w,h);
	setupcolors();
	for(fp = fonts; --numfonts >= 0; fp++) {
	    if((f = GrLoadFont(*fp)) == NULL) {
		GrSetMode(GR_default_text);
		fprintf(stderr,"could not load font: %s\n",*fp);
		exit(1);
	    }
	    if(!displayfont(f)) {
		GrSetMode(GR_default_text);
		fprintf(stderr,"could not display font: %s\n",*fp);
		exit(1);
	    }
	}
	GrSetMode(GR_default_text);
	exit(0);
}

