/** 
 ** CLEAR.C 
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"

void GrClearClipBox(int bg)
{
	MOUSE_FLAG;

	MOUSE_BLOCK(CURC,_GrLoX,_GrLoY,_GrHiX,_GrHiY);
	_GrSetPixBlock(PIXEL_ADDR(_GrLoX,_GrLoY),
	    bg,
	    (_GrHiX - _GrLoX + 1),
	    (_GrHiY - _GrLoY + 1)
	);
	MOUSE_UNBLOCK();
}

void GrClearContext(int bg)
{
	MOUSE_FLAG;

	MOUSE_BLOCK(CURC,0,0,_GrMaxX,_GrMaxY);
	_GrSetPixBlock(PIXEL_ADDR(0,0),bg,_GrSizeX,_GrSizeY);
	MOUSE_UNBLOCK();
}

void GrClearScreen(int bg)
{
	GrContext save;
	MOUSE_FLAG;

	GrSaveContext(&save);
	GrSetContext(SCREEN);
	MOUSE_BLOCK(CURC,0,0,_GrMaxX,_GrMaxY);
	_GrSetPixBlock(PIXEL_ADDR(0,0),bg,_GrScreenX,_GrScreenY);
	MOUSE_UNBLOCK();
	GrSetContext(&save);
}

