#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#include <grx.h>
#include <grdriver.h>

void usage(char *progname,char *reason)
{
	fputs(progname,stderr);
	fputs(reason,stderr);
	fputs("\n"
	    "usage: VMODE mode [resolution [colors]]\n"
	    "arguments:\n"
	    "\tmode         - selects text (T) or graphics (G) mode\n"
	    "\tresolution   - format: WIDTHxHEIGHT if omitted use driver defaults\n"
	    "\tcolors       - number of colors to set up\n\n",
	    stderr
	);
}

void main(int argc,char **argv)
{
	int type,w,h,c,n = 0;

	if(argc < 2) {
	    usage(argv[0],": missing argument(s)\n");
	    exit(1);
	}
	if(((type = toupper(argv[1][0])) != 'T') && (type != 'G')) {
	    usage(argv[0],": invalid mode argument\n");
	    exit(1);
	}
	if(argc > 2) n  = sscanf(argv[2],"%dx%d",&w,&h);
	if(argc > 3) n += sscanf(argv[3],"%d",&c);
	_GrLowSetMode(
	    ((type == 'G') ?
		((n < 2) ?
		    GR_default_graphics :
		    ((n > 2) ?
			GR_width_height_color_graphics :
			GR_width_height_graphics)) :
		((n < 2) ? GR_default_text : GR_width_height_text)),
	    w,h,c
	);
	exit(0);
}

