/*------------------------------------------------------------
 * 
 *  markwin.c
 * 
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *  used internally by curses
 * 
 *  mark and unmark a windows dirty region
 * 
 *----------------------------------------------------------*/

#include "curses.h"

void
markwin(win)
WINDOW *win;
{
    int cy, cx;
	
    getyx(win,cy,cx);

    if (cy > win->lasty) 
        win->lasty = cy;

    if (cy < win->firsty) 
        win->firsty = cy;

    if (cx < win->firstx[cy])
        win->firstx[cy] = cx;
    if (cx > win->lastx[cy])
        win->lastx[cy] = cx;
        
    win->flags |= _WDIRTY;
}

void
umarkwin(win)
WINDOW *win;
{
    int y, maxy;
    
    maxy = getmaxr(win);
    
    win->firsty = INT_MAX;
    win->lasty = -1;

    for (y = 0; y <= maxy; y++) {
        win->firstx[y] = INT_MAX;
        win->lastx[y] = -1;
    }

    win->flags &= ~_WDIRTY;
}

void
touchwin(win)
WINDOW *win;
{
    int y, maxy, maxx;
    
    getmaxrc(win, maxy, maxx);
    
    win->firsty = 0;
    win->lasty = win->maxy;

    for (y = 0; y < maxy; y++) {
        win->firstx[y] = 0;
        win->lastx[y] = maxx;
    }
    
    win->flags |= _WDIRTY;
}
