/*----------------------------------------------------------------------
 *
 *  cornerchar.c 
 *
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *  returns the correct corner character
 *
 *  cornerchar(n,v,h)
 *
 *  v & h are 0 for single line, 1 for double,
 *  n is location as per the following diagram:
 *
 *      0   1
 *
 *      3   2
 *
 *  SEE ALSO: teechar.c, line.c
 *
 *----------------------------------------------------------------------
 */

#include "curses.h"

int
cornerchar(n, v, h)
int n, v, h;
{
    static UCHAR cchars[][2][2] = {
        218, 213, 214, 201, 
        191, 184, 183, 187,
        217, 190, 189, 188,
        192, 212, 211, 200
      };
  
    return cchars[n][v][h];
}

