/*------------------------------------------------------------
 * 
 *  box.c
 * 
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *  
 *  box a window -- curses 3.X
 * 
 *----------------------------------------------------------*/

#include "curses.h"

box(win, v, h)
WINDOW  *win;
int     v, h;
{
    /*
        if v and h are 0 or 1, they are interpreted to mean
        the IBM char set line drawing character with single
        or double lines, respectively
        
        if the above case holds, or v and h are really IBM
        line drawing characters, then the corner characters
        are picked from the IBM char set to match
        
        otherwise, v and h are treated as ASCII values, and
        the corners are filled in using the v character
    */

    static UCHAR ulchars[2][2] = {
        218, 213,
        214, 201
      };

    static UCHAR urchars[2][2] = {
        191, 184,
        183, 187
    };

    static UCHAR llchars[2][2] = {
        192, 212,
        211, 200
    };

    static UCHAR lrchars[2][2] = {
        217, 190,
        189, 188
    };

    static UCHAR hchars[2] = {
        196, 205
    };

    static UCHAR vchars[2] = {
        179, 186
    };

    int     vtype, 
            htype, 
            cnt, 
            attrib,
            ulchr,
            urchr,
            llchr,
            lrchr;

    VIDCHR  *buf;

    if (v == 0 || v == 1)
        v = vchars[vtype = v];
    else 
        for (vtype = 1; vtype > -1; vtype--)
            if (v == vchars[vtype])
                break;

    if (h == 0 || h == 1)
        h = hchars[htype = h];
    else 
        for (htype = 1; htype > -1; htype--)
            if (h == hchars[htype])
                break;

    buf = win->buf[0];
    attrib = win->attrib;

    if (htype > -1 && vtype > -1) {
        /* IBM box chars */
        ulchr = ulchars[vtype][htype];
        urchr = urchars[vtype][htype];
        llchr = llchars[vtype][htype];
        lrchr = lrchars[vtype][htype];
    } else 
        ulchr = urchr = llchr = lrchr = v;
    
    buf->chr = ulchr;
    buf++->att = attrib;

    for (cnt = 1; cnt < win->maxx; cnt++) {
      buf->chr = h;
      buf++->att = attrib;
    }

    buf->chr = urchr;
    buf++->att = attrib;

    for (cnt = 1; cnt < win->maxy; cnt++) {
        buf = win->buf[cnt];
        buf->chr = v;
        buf->att = attrib;
        buf += win->maxx;
        buf->chr = v;
        buf->att = attrib;
    }

    buf = win->buf[cnt];

    buf->chr = llchr;
    buf++->att = attrib;

    for (cnt = 1; cnt < win->maxx; cnt++) {
        buf->chr = h;
        buf++->att = attrib;
    }

    buf->chr = lrchr;
    buf->att = attrib;

    touchwin(win);
    win->flags |= _WBOX;

    return OK;
}

