/**********************************************************************
 *  
 *  aztecdos.h
 *  
 *  copyright (c) 1988,89,90 J. Alan Eldridge
 *
 *  include file to define union REGS for Aztec C
 *  
 *  for some reason, they didn't put this anywhere in 
 *  the header files that come with the compiler
 *  
 *  NOTE:
 *
 *  this is not quite the same as the MSC50 and TURBOC
 *  data structure: they have the flags as an element of the
 *  structure, whereas Aztec C gives the flags as the
 *  return value of sysint()
 *  
 *********************************************************************/

#ifndef __AZTECDOS__
#define __AZTECDOS__

union REGS {
    struct {
        short ax, bx, cx, dx, si, di, ds, es;
    } x;
    struct {
        UCHAR al, ah, bl, bh, cl, ch, dl, dh;
    } h;
};

#define int86(n,i,o)    sysint(n,i,o)

#ifndef NO_PROTO

int sysint(
    int         int_num,
    union REGS  *in_regs,
    union REGS  *out_regs);

void movblock(
    void far    *src,
    void far    *dest,
    int         cnt);
    
#endif  /* NO_PROTO */
    
#endif  /* __AZTECDOS__ */

