*** orig/texinfo-.1/info/terminal.c	Sun Aug 29 18:41:20 1993
--- src/texinfo-.1/info/terminal.c	Sun Aug 29 19:04:00 1993
***************
*** 29,34 ****
--- 29,37 ----
  #include <sys/types.h>
  #include "terminal.h"
  #include "termdep.h"
+ #if defined (__GO32__)
+ #include "pc_term.h"
+ #endif /* __GO32__ */
  
  extern void *xmalloc (), *xrealloc ();
  
***************
*** 43,48 ****
--- 46,69 ----
     function is called when appropriate instead of its namesake.  Your
     function is called with exactly the same arguments that were passed
     to the namesake function. */
+ #if defined (__GO32__)
+ VFunction *terminal_begin_inverse_hook       = pc_begin_inverse;
+ VFunction *terminal_end_inverse_hook         = pc_end_inverse;
+ VFunction *terminal_prep_terminal_hook       = pc_prep_terminal;
+ VFunction *terminal_unprep_terminal_hook     = pc_unprep_terminal;
+ VFunction *terminal_up_line_hook             = pc_up_line;
+ VFunction *terminal_down_line_hook           = pc_down_line;
+ VFunction *terminal_clear_screen_hook        = pc_clear_screen;
+ VFunction *terminal_clear_to_eol_hook        = pc_clear_to_eol;
+ VFunction *terminal_get_screen_size_hook     = pc_get_screen_size;
+ VFunction *terminal_goto_xy_hook             = pc_goto_xy;
+ VFunction *terminal_initialize_terminal_hook = pc_initialize_terminal;
+ VFunction *terminal_new_terminal_hook        = pc_new_terminal;
+ VFunction *terminal_put_text_hook            = pc_put_text;
+ VFunction *terminal_ring_bell_hook           = pc_ring_bell;
+ VFunction *terminal_write_chars_hook         = pc_write_chars;
+ VFunction *terminal_scroll_terminal_hook     = pc_scroll_terminal;
+ #else /* __GO32__ */
  VFunction *terminal_begin_inverse_hook = (VFunction *)NULL;
  VFunction *terminal_end_inverse_hook = (VFunction *)NULL;
  VFunction *terminal_prep_terminal_hook = (VFunction *)NULL;
***************
*** 59,64 ****
--- 80,86 ----
  VFunction *terminal_ring_bell_hook = (VFunction *)NULL;
  VFunction *terminal_write_chars_hook = (VFunction *)NULL;
  VFunction *terminal_scroll_terminal_hook = (VFunction *)NULL;
+ #endif /* __GO32__ */
  
  /* **************************************************************** */
  /*								    */
***************
*** 135,140 ****
--- 157,165 ----
  static void
  terminal_end_using_terminal ()
  {
+ #if defined (__GO32__)
+   terminal_clear_screen();  /* to end up with a clean screen for DOS */
+ #endif /* __GO32__ */
    send_to_terminal (term_end_use);
  }
  
***************
*** 514,520 ****
--- 539,547 ----
        ospeed = B9600;
    }
  #else
+ #if !defined(__MSDOS__)
    ospeed = B9600;
+ #endif
  #endif				/* !TIOCGETP */
  
    term_cr = tgetstr ("cr", &buffer);
***************
*** 599,608 ****
--- 626,637 ----
  /* A buffer containing the terminal mode flags upon entry to info. */
  struct termio original_termio, ttybuff;
  #else /* !HAVE_TERMIO_H */
+ #if !defined (__MSDOS__)
  /* Buffers containing the terminal mode flags upon entry to info. */
  int original_tty_flags = 0;
  int original_lmode;
  struct sgttyb ttybuff;
+ #endif /* !__MSDOS__ */
  #endif /* !HAVE_TERMIO_H */
  
  /* Prepare to start using the terminal to read characters singly. */
***************
*** 638,643 ****
--- 667,673 ----
    ioctl (tty, TCSETA, &ttybuff);
  
  #else /* !HAVE_TERMIO_H */
+ #if !defined (__MSDOS__)
  
    ioctl (tty, TIOCGETP, &ttybuff);
  
***************
*** 702,707 ****
--- 732,738 ----
    ttybuff.sg_flags &= ~ECHO;
    ttybuff.sg_flags |= CBREAK;
    ioctl (tty, TIOCSETN, &ttybuff);
+ #endif /* !__MSDOS__ */
  #endif /* !HAVE_TERMIO_H */
  }
  
***************
*** 723,728 ****
--- 754,760 ----
  #if defined (HAVE_TERMIO_H)
    ioctl (tty, TCSETA, &original_termio);
  #else /* !HAVE_TERMIO_H */
+ #if !defined (__MSDOS__)
    ioctl (tty, TIOCGETP, &ttybuff);
    ttybuff.sg_flags = original_tty_flags;
    ioctl (tty, TIOCSETN, &ttybuff);
***************
*** 739,745 ****
    ioctl (tty, TIOCLSET, &original_lmode);
  #endif /* TIOCLGET && LPASS8 */
  
  #endif /* !HAVE_TERMIO_H */
    terminal_end_using_terminal ();
  }
- 
--- 771,777 ----
    ioctl (tty, TIOCLSET, &original_lmode);
  #endif /* TIOCLGET && LPASS8 */
  
+ #endif /* !__MSDOS__ */
  #endif /* !HAVE_TERMIO_H */
    terminal_end_using_terminal ();
  }
