#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <string.h>
#include <errno.h>
#include <io.h>
#include <dos.h>
#include <time.h>

#include "oread.h"

void Fatal(char *msg)
{
  fprintf(stderr, "Fatal! %s!\n", msg);
  exit(1);
}

/*------------------------------------------------------------------------*/

int v_switch = 0;

main(int argc, char **argv)
{
  int i = 1;
  for (; i < argc; i++)
  {
    if (strcmp(argv[i], "-v") == 0)
      v_switch = 1 - v_switch;
    else
      tarlist(argv[i]);
  }
}

/*------------------------------------------------------------------------*/

typedef struct {
  char name[100];
  char operm[8];
  char ouid[8];
  char ogid[8];
  char osize[11];
  char otime[12];
  char ocsum[8];
  char flags[2];
  char filler[355];
} TARREC;

char buf[512];

tarlist(char *fname)
{
  TARREC header;
  int r;
  void *f;
  long perm, uid, gid, size, ftime, csum, posn=0;
  int dsize;
  char *changed_name;
  struct tm *ltm;

  f = oread_open(fname);

  while (1)
  {
    oread_read(f, &header);
    if (header.name[0] == 0)
      break;
    sscanf(header.operm, "%lo", &perm);
    sscanf(header.ouid, "%lo", &uid);
    sscanf(header.ogid, "%lo", &gid);
    sscanf(header.osize, "%lo", &size);
    sscanf(header.otime, "%lo", &ftime);
    if (v_switch)
      printf("%08lx %6lo ", posn, perm);
    else
      printf("%c%c%c%c ",
             perm & 040000 ? 'd' : '-',
             perm & 000400 ? 'r' : '-',
             perm & 000200 ? 'w' : '-',
             perm & 000100 ? 'x' : '-');
    printf("%.20s %9ld %s", ctime(&ftime)+4, size, header.name, posn);
    if (header.flags[1] == 0x32)
      printf(" -> %s", header.filler);
    printf("\n");
    oread_skip(f, (size+511) & ~511);
    posn += 512 + (size+511) & ~511;
  }
  oread_close(f);
}
