/* This is file STUBINFO.H */
/*
** Copyright (C) 1993 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _STUBINFO_H_
#define _STUBINFO_H_

typedef struct {
  char magic[16];

  /* This is the length of the structure defined in stub.exe.
     If it gives more or less bytes than you expect, then it's
     from a different version and you need to handle that. */
  word32 struct_length;

  /* the base name of the extender to use */
  char go32[16];
  
  /* The version of go32.exe this program expects.  The word8's encode
     the version as follows:
       .b[0] - release number (fcs always zero)
       .b[1] - release type 'a'=alpha, 'b'=beta, 'f'=fcs, 'm'=maintainance
	       set to 's' for special versions - exact match required, use
	       release number as special type indicator.
       .b[2] - minor version number
       .b[3] - major version number
     Example: for the third beta of 1.11, the entries would be
     {3, 'b', 11, 1}.  The order is chosen such that the _w value
     will monotonically increase with each release. */
  word8 required_go32_version[4];
#define required_go32_version_w(x) (*(word32 *)(x.required_go32_version))

  /* the minimum amount of stack space required */
  word32 min_stack;

  /* The maximum amount of virtual memory to keep around
     when this program spawns another program */
  word32 max_keep_on_spawn;

  /* this replaces the base of the file name we are for paging_set_file
     if [0] is non-zero */
  char actual_file_to_run[15];
  
  /* if set, disable globbing (the program will glob for us) */
  word8 enable_globbing;
  
  /* amount of conventional memory to leave available to DOS allocation calls */
  word32 free_conventional_memory;
} StubInfo;

#define STUB_INFO_MAGIC "StubInfoMagic!!"

#define GO32_MAJOR_VERSION      1
#define GO32_MINOR_VERSION      12
#define GO32_RELEASE_TYPE       "fcs"
#define GO32_RELEASE_TYPE_C     'f'
#define GO32_RELEASE_NUMBER     1

/* 1.08.fcs0 */
#define GO32_LOWEST_COMPATIBLE_VERSION 0x01086600L

extern StubInfo stub_info;

extern char *char2rtype(word8 rtype, word8 relnum); /* go32.exe only */

#endif
