/* original Copyright(C) 1992 Hiroya Tsubakimoto
 * modifications Copyright(C) 1993 Charles Sandmann
 * Merged with GO32 V1.09+ C. Sandmann sandmann@clio.rice.edu
 * Distributed under terms of "copying.dj" when distributed with GO32 source
 * Distributed under terms of GPL if used in any other code  */

typedef struct {
  struct {
    word8 minor, major;
  } version;
  word16 flags;
  word16 cpu;
  struct {
    word8 slave, master;
  } PIC;
} DPMIinfo;

typedef struct {
  word32 address;
  word32 bytes;
  word32 handle;
} DPMImemory;

typedef struct {
  word32 offset;
  word16 selector;
} DPMIaddress;

typedef struct {
  word32 largest_block;
  word32 physical_mem;
  word32 swap_mem;
} DPMImaxmeminfo;

extern int exitDPMI;
extern char use_DPMI;

/* real mode function(s) */
int initDPMI(DPMIinfo* info);
void DPMIprotectedMode(void);
int DPMIexecute(void);

int DPMIsetBreak(word16 sizetype, word32 addr);
int DPMIcancelBreak(int handle);

void Pmemget(word16 sel, word32 off, void* addr, word16 bytes);
void Pmemput(word16 sel, word32 off, const void* addr, word16 bytes);
void Pmemset(word16 sel, word32 off, word8 value, word32 bytes);
word16 Pmemscan(word16 sel, word32 off, word8 value, word16 bytes);

/* protected mode function(s) */
void uninitDPMI(int retcode);
void DPMIrealMode(void);
void DPMImaxmem(DPMImaxmeminfo*);
int DPMIalloc(DPMImemory* mem, word32 bytes);
int DPMIrealloc(DPMImemory* mem, word32 bytes);
void DPMIfree(DPMImemory* mem);
word16 DPMIselector(word16 number);
int DPMIassignSelector(word16 selector, word16 type, word32 base, word32 limit);
int DPMISelectorBase(word16 selector, word32 base);
void DPMIchangeException(word8 no, DPMIaddress* handler);
void DPMIchangeInterrupt(word8 no, DPMIaddress* handler);
void DPMIhandler(word8 no, DPMIaddress* handler);
void DPMIehandler(word8 no, DPMIaddress* handler);
void DPMIhandlerNPX(DPMIaddress* handler);

#define exit(n) ( exit(exitDPMI=(n)) )
