/*
  (c) Copyright 1992 Eric Backus

  This software may be used freely so long as this copyright notice is
  left intact.  There is no warrantee on this software.
*/

#include <time.h>		/* For localtime() */
#include <fcntl.h>		/* For open() */
#include <dos.h>		/* For intdos() */
#include <errno.h>		/* For errno */
#include <utime.h>		/* For utime() */

/* An implementation of utime() for DJGPP.  The utime() function
   specifies an access time and a modification time.  DOS has only one
   time, so we will (arbitrarily) use the modification time. */
int
utime(const char *path, const struct utimbuf *times)
{
    union REGS		regs;
    struct tm		*tm;
    time_t		modtime;
    int			fildes;
    unsigned int	dostime, dosdate;

    /* DOS wants the file open */
    fildes = open(path, O_RDONLY);
    if (fildes == -1) return -1;

    /* NULL times means use current time */
    if (times == NULL)
	modtime = time((time_t *) 0);
    else
	modtime = times->modtime;

    /* Convert UNIX time to DOS date and time */
    tm = localtime(&modtime);
    if (tm->tm_year < 80) tm->tm_year = 80; /* DOS starts at 1980 */
    dosdate = tm->tm_mday + ((tm->tm_mon + 1) << 5) +
	((tm->tm_year - 80) << 9);
    dostime = tm->tm_sec / 2 + (tm->tm_min << 5) +
	(tm->tm_hour << 11);

    /* Set the file timestamp */
    regs.h.ah = 0x57;		/* DOS FileTimes call */
    regs.h.al = 0x01;		/* Set date/time request */
    regs.x.bx = fildes;		/* File handle */
    regs.x.cx = dostime;	/* New time */
    regs.x.dx = dosdate;	/* New date */
    (void) intdos(&regs, &regs);

    /* Close the file */
    (void) close(fildes);

    /* Return */
    if (regs.x.cflag != 0)
    {
	/* Not sure this is even possible. */
	errno = regs.x.ax;
	return -1;
    }
    else
	return 0;
}
