/*
  (c) Copyright 1992 Eric Backus

  This software may be used freely so long as this copyright notice is
  left intact.  There is no warrantee on this software.
*/

#include <dir.h>		/* For findfirst() */
#include <mntent.h>		/* For struct mntent, etc. */

/* From fixpath.c */
extern int	_get_default_drive(void);

static char		mnt_count = 0;
static struct mntent	mntent;
static struct ffblk	mnt_ff;
static char		drive_string[7];

/* These functions are being implemented so that we can compile and
   use the GNU df program.  This program gets the list of mounted
   filesystems, and then summarizes the disk space available on each
   one.

   To be complete, the getmntent() function should return all possible
   drives from A to the system's lastdrive parameter.  For each one,
   it should return the volume name.  However, this doesn't turn out
   to work well for floppy disks, because we'll get the ever-popular
   "Abort, Retry, Fail?" prompt when trying to read the volume name
   from a non-existant disk.

   As a compromise, the getmntent() function has been made to return
   the 'A' or 'B' drive only if they are the current drive.  This
   works okay, but it means that you must explicitly change to a
   floppy disk before you can df it, which is kind of bogus. */

/*ARGSUSED*/
FILE *
setmntent(char *filename, char *type)
{
    mnt_count = 1;
    return (FILE *) 1;
}

struct mntent *
getmntent(FILE *filep)
{
    int			drive_number;
    char		*p, *q;

    if (mnt_count == 0) return NULL;
    if (mnt_count > 26) return NULL;

    if (mnt_count == 1)
    {
	drive_number = _get_default_drive();

	switch (drive_number)
	{
	case 0:
	    mnt_count = 1;	/* 'A' drive */
	    break;
	case 1:
	    mnt_count = 2;	/* 'B' drive */
	    break;
	default:
	    mnt_count = 3;	/* 'C' drive */
	    break;
	}
    }

    /* Add '*.*' to end for findfirst */
    (void) sprintf(drive_string, "%c:/*.*", 'a' + mnt_count - 1);

    /* Get the volume name.  If this fails, the drive is probably not
       a valid drive */
    if (findfirst(drive_string, &mnt_ff, FA_LABEL) != 0)
	return NULL;

    /* Strip out extraneous '.' separator */
    if (strlen(mnt_ff.ff_name) > 8 && mnt_ff.ff_name[8] == '.')
    {
	/* Overlapping copy, don't use strcpy() */
	p = &mnt_ff.ff_name[8];
	q = p + 1;
	while ((*p++ = *q++) != '\0');
    }

    /* Remove the '*.*' from the drive string for use as mnt_dir */
    drive_string[3] = '\0';

    mntent.mnt_fsname = mnt_ff.ff_name;
    mntent.mnt_dir = drive_string;
    mntent.mnt_type = "dos";
    mntent.mnt_opts = "rw";
    mntent.mnt_freq = -1;
    mntent.mnt_passno = -1;
    mntent.mnt_time = -1;

    /* Increment drive number.  Skip up to 'C' drive */
    if (mnt_count < 3)
	mnt_count = 3;
    else
	mnt_count++;

    return &mntent;
}

/*ARGSUSED*/
int addmntent(FILE *filep, struct mntent *mnt)
{
    return 1;
}

/*ARGSUSED*/
char *hasmntopt(struct mntent *mnt, char *opt)
{
    return NULL;
}

/*ARGSUSED*/
int endmntent(FILE *filep)
{
    mnt_count = 0;
    return 1;
}
