#include "emu.h"
#include "rmov.h"

void emu_64()
{
  if (empty())
    return;
  if (modrm > 0277)
  {
    // fsubp st(i),st
    int i = modrm & 7;
    if (empty(i))
      return;
    reg tmp;
    r_sub(st(), st(i), tmp);
    r_mov(tmp, st(i));
    st().tag = TW_E;
    top++;
    return;
  }
  else
  {
    // fisub m16int
    reg t1, t2;
    r_mov((short *)get_modrm(), t1);
    r_sub(st(), t1, t2);
    r_mov(t2, st());
  }
}
