/*
** Copyright (C) 1993 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <atexit.h>
#include <stdlib.h>

struct atexit *__atexit = 0;

int
on_exit(func,arg)
void (*func)(int);
int arg;
{
  struct atexit *a;
  if (func == 0)
    return -1;
  a = (struct atexit *)malloc(sizeof(struct atexit));
  if (!a)
    return -1;
  a->next = __atexit;
  a->function = func;
  a->arg = arg;
  __atexit = a;
  return 0;
}

int
atexit(a)
     void (*a)(void);
{
  return on_exit(a,0);
}
